Most laptop batteries are smart and consist of the “chemical battery” that is managed by the “digital battery.” A common protocol is the System Management Bus, better known as SMBus.

The typical SMBus battery has five or more battery connections consisting of positive and negative battery terminals, thermistor, clock and data. The connections are often unmarked; however, the positive and negative are commonly located at the outer edges of the connector and the inner contacts accommodate the clock and data. (The one-wire system combines clock and data.) For safety reasons, a separate thermistor wire is brought to the outside. Figure 1 illustrates a battery with six connections.

Terminal connection of a typical laptop battery
Figure 1: Terminal connection of a typical laptop battery [1]
The positive and negative terminals are usually placed on the outside; no norm exists on the arrangement of the other contacts.


Some batteries are equipped with a solid-state switch that is normally in the “off” position and no voltage is present at the battery terminals. Connecting the switch terminal to ground or pulling it up often turns the battery on. If this does not work, the pack may need a code for activation. Battery manufacturers keep these proprietary codes a well-guarded secret to which even service personnel have no access.

Use a voltmeter to locate the positive and negative battery terminals and establish the polarity. If no voltage is present, a solid-state switch may be in the “off” position and needs activating. Connect the voltmeter to the outer terminals, take a 100-Ohm resistor (other values may also work), tie one end to ground and with the other end touch each terminal while observing the voltmeter. Repeat by tying the resistor to a positive voltage potential. If there is no response, then it is possible that the battery is dead or locked by a code. The 100-Ohm resistor is low enough to engage a digital circuit and high enough to protect the battery against a possible electrical short.

Establishing the connection to the battery terminals should now enable charging. If the charge current stops after 30 seconds, an activation code may be required. Some battery manufacturers add an end-of-battery-life switch that turns the battery off when reaching a certain age or cycle count. They argue that customer satisfaction and safety can only be guaranteed by regularly replacing the battery. Mind you, such a policy also rotates inventory.

If at all possible, connect the thermistor during charging and discharging to protect the battery against possible overheating. Use an ohmmeter to locate the internal thermistor. The most common thermistors are 10 Kilo Ohm NTC, which reads 10kΩ at 20C (68F). NTC stands for negative temperature coefficient, meaning that the resistance decreases with rising temperature. In comparison, a positive temperature coefficient (PTC) causes the resistance to increase. Warming the battery with your hand is sufficient to detect a small change in resistor value when looking for the correct terminal on the battery.

After repair, the fuel gauge might not work, is inaccurate or provides wrong information. The battery may need some sort of an initialization/calibration process by fully charging and discharging the pack to reset the flags. A “flag” is a measuring point to mark and record an event(See BU-603: How to Calibrate a “Smart” Battery)

The circuits of some smart batteries must be kept “alive” during the replacement of the cells. Disconnecting the voltage for only a fraction of a second can erase vital data in the memory. An analogy is open-heart surgery where doctors must keep all organs of the patient alive. The lost data could contain the resistor value of the digitized shunt that is responsible for the coulomb counter and other data.

To assure continued operation when changing the cells, supply a secondary voltage of same voltage level through a 100-Ohm resistor to the circuit before disconnection. Remove the outside supply only after the circuit receives voltage again from the new cells. Furthermore, some fuel gauge chips run wires to each cell. These must be reassembled in the correct sequence beginning with cell one, then two, three and so forth