/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.items.complex;

import net.minecraft.class_1935;
import org.betterx.bclib.api.v2.advancement.AdvancementManager;
import org.betterx.bclib.items.tool.BaseShearsItem;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.items.NetherArmor;
import org.betterx.betternether.items.NetherAxe;
import org.betterx.betternether.items.NetherHoe;
import org.betterx.betternether.items.NetherPickaxe;
import org.betterx.betternether.items.NetherShovel;
import org.betterx.betternether.items.NetherSword;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.registry.NetherItems;
import org.betterx.wover.complex.api.equipment.ArmorSlot;
import org.betterx.wover.complex.api.equipment.ArmorTier;
import org.betterx.wover.complex.api.equipment.EquipmentSet;
import org.betterx.wover.complex.api.equipment.ToolSlot;
import org.betterx.wover.complex.api.equipment.ToolTier;

public class NetherSet
extends EquipmentSet {
    public NetherSet(String prefix, ToolTier toolTier, ArmorTier armorTier, boolean withShears) {
        this(prefix, toolTier, armorTier, withShears, null);
    }

    public NetherSet(String prefix, ToolTier toolTier, ArmorTier armorTier, boolean withShears, EquipmentSet templateBaseSet) {
        super(BetterNether.C, prefix, toolTier, armorTier, (class_1935)NetherBlocks.NETHER_REED_STEM, templateBaseSet);
        if (toolTier != null) {
            ToolSlot.PropertiesBuilder toolPropertiesBuilder = (slot, tier) -> {
                ToolTier.ToolValues values = tier.getValues(slot);
                if (values == null) {
                    throw new IllegalArgumentException("Values for " + String.valueOf(slot) + " are not defined for " + String.valueOf(tier));
                }
                if (slot == ToolSlot.SWORD_SLOT) {
                    return NetherItems.createDefaultNetherSwordSettings(tier.toolTier, values.attackDamage(), values.attackSpeed());
                }
                return NetherItems.createDefaultNetherToolSettings(tier.toolTier, values.attackDamage(), values.attackSpeed());
            };
            ToolSlot.PropertiesBuilder shearPropertiesBuilder = (slot, tier) -> toolPropertiesBuilder.build(slot, tier).method_7895((int)((double)tier.toolTier.method_8025() * 0.75));
            this.add(ToolSlot.PICKAXE_SLOT, NetherPickaxe::new, toolPropertiesBuilder);
            this.add(ToolSlot.AXE_SLOT, NetherAxe::new, toolPropertiesBuilder);
            this.add(ToolSlot.SHOVEL_SLOT, NetherShovel::new, toolPropertiesBuilder);
            this.add(ToolSlot.HOE_SLOT, NetherHoe::new, toolPropertiesBuilder);
            this.add(ToolSlot.SWORD_SLOT, NetherSword::new, toolPropertiesBuilder);
            if (withShears) {
                this.add(ToolSlot.SHEARS_SLOT, (t, p) -> new BaseShearsItem(p), shearPropertiesBuilder);
            }
        }
        if (armorTier != null) {
            ArmorSlot.PropertiesBuilder armorPropertiesBuilder = (slot, tier) -> {
                ArmorTier.ArmorValues values = tier.getValues(slot);
                if (values == null) {
                    throw new IllegalArgumentException("Values for " + String.valueOf(slot) + " are not defined for " + String.valueOf(tier));
                }
                return NetherItems.createDefaultNetherArmorSettings(slot.armorType, values.durability());
            };
            this.add(ArmorSlot.HELMET_SLOT, NetherArmor::new, armorPropertiesBuilder);
            this.add(ArmorSlot.CHESTPLATE_SLOT, NetherArmor::new, armorPropertiesBuilder);
            this.add(ArmorSlot.LEGGINGS_SLOT, NetherArmor::new, armorPropertiesBuilder);
            this.add(ArmorSlot.BOOTS_SLOT, NetherArmor::new, armorPropertiesBuilder);
        }
    }

    private AdvancementManager.Builder addEquipmentSetSlotCriterion(AdvancementManager.Builder builder, ToolSlot slot) {
        return builder.addInventoryChangedCriterion(this.baseName + "_" + slot.name, new class_1935[]{this.get(slot)});
    }

    private AdvancementManager.Builder addEquipmentSetSlotCriterion(AdvancementManager.Builder builder, ArmorSlot slot) {
        return builder.addInventoryChangedCriterion(this.baseName + "_" + slot.name, new class_1935[]{this.get(slot)});
    }

    public AdvancementManager.Builder addArmorSetCriterion(AdvancementManager.Builder builder) {
        this.addEquipmentSetSlotCriterion(builder, ArmorSlot.HELMET_SLOT);
        this.addEquipmentSetSlotCriterion(builder, ArmorSlot.CHESTPLATE_SLOT);
        this.addEquipmentSetSlotCriterion(builder, ArmorSlot.LEGGINGS_SLOT);
        this.addEquipmentSetSlotCriterion(builder, ArmorSlot.BOOTS_SLOT);
        return builder;
    }

    public AdvancementManager.Builder addToolSetCriterion(AdvancementManager.Builder builder) {
        this.addEquipmentSetSlotCriterion(builder, ToolSlot.PICKAXE_SLOT);
        this.addEquipmentSetSlotCriterion(builder, ToolSlot.AXE_SLOT);
        this.addEquipmentSetSlotCriterion(builder, ToolSlot.SHOVEL_SLOT);
        this.addEquipmentSetSlotCriterion(builder, ToolSlot.SWORD_SLOT);
        this.addEquipmentSetSlotCriterion(builder, ToolSlot.HOE_SLOT);
        return builder;
    }
}

