/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.recipes;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_7800;
import org.betterx.wover.recipe.api.RecipeBuilder;
import org.jetbrains.annotations.ApiStatus;

public class RecipesHelper {
    private static final String[] SHAPE_ROOF = new String[]{"# #", "###", " # "};
    private static final String[] SHAPE_STAIR = new String[]{"#  ", "## ", "###"};
    private static final String[] SHAPE_SLAB = new String[]{"###"};
    private static final String[] SHAPE_BUTTON = new String[]{"#"};
    private static final String[] SHAPE_PLATE = new String[]{"##"};
    private static final String[] SHAPE_X2 = new String[]{"##", "##"};
    private static final String[] SHAPE_3X2 = new String[]{"###", "###"};
    private static final String[] SHAPE_COLORING = new String[]{"###", "#I#", "###"};
    private static final String[] SHAPE_ROUND = new String[]{"###", "# #", "###"};
    private static final String[] SHAPE_FIRE_BOWL = new String[]{"#I#", " # ", "L L"};
    private static final List<RecipeBuilder> RECIPES = new LinkedList<RecipeBuilder>();

    @ApiStatus.Internal
    public static void provideRecipes(RecipeBuilder.Templates t) {
        RECIPES.forEach(r -> r.accept(t));
    }

    public static void addProvider(RecipeBuilder provider) {
        RECIPES.add(provider);
    }

    public static void makeRoofRecipe(class_2248 source, class_2248 roof) {
        RECIPES.add(t -> t.makeRoofRecipe(source, roof));
    }

    public static void makeStairsRecipe(class_2248 source, class_2248 stairs) {
        RECIPES.add(t -> t.makeStairsRecipe(source, stairs));
    }

    public static void makeSlabRecipe(class_2248 source, class_2248 slab) {
        RECIPES.add(t -> t.makeSlabRecipe(source, slab));
    }

    public static void makeButtonRecipe(class_2248 source, class_2248 button) {
        RECIPES.add(t -> t.makeButtonRecipe(source, button));
    }

    public static void makePlateRecipe(class_2248 source, class_2248 plate) {
        RECIPES.add(t -> t.makePlateRecipe(source, plate));
    }

    public static void makeSimpleRecipe2(class_2248 source, class_2248 result, int count, String group, class_7800 category) {
        RECIPES.add(t -> t.makeSimpleRecipe2x2(source, result, count, group, category));
    }

    public static void makeWallRecipe(class_2248 source, class_2248 wall) {
        RECIPES.add(t -> t.makeWallRecipe(source, wall));
    }

    public static void makeColoringRecipe(class_2248 source, class_2248 result, class_1792 dye, String group, class_7800 category) {
        RECIPES.add(t -> t.makeColoringRecipe(source, result, dye, group, category));
    }

    public static void makeRoundRecipe(class_2248 source, class_2248 result, String group, class_7800 category) {
        RECIPES.add(t -> t.makeRoundRecipe(source, result, group, category));
    }

    public static void makeFireBowlRecipe(class_2248 material, class_2248 inside, class_1792 leg, class_2248 result) {
        RECIPES.add(t -> t.makeFireBowlRecipe(material, inside, leg, result));
    }

    public static interface RecipeBuilder
    extends Consumer<RecipeBuilder.Templates> {
    }
}

