/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.advancements.predicate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.advancements.predicate.EntityInFramePredicate;
import io.github.mortuusars.exposure.advancements.predicate.ExtraDataPredicate;
import io.github.mortuusars.exposure.advancements.predicate.ShutterSpeedPredicate;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.level.storage.ExposureIdentifier;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2096;
import net.minecraft.class_2520;
import net.minecraft.class_9331;
import net.minecraft.class_9365;
import org.jetbrains.annotations.NotNull;

public record FramePredicate(Optional<ExposureIdentifier> identifier, Optional<String> type, Optional<String> photographer, Optional<ShutterSpeedPredicate> shutterSpeed, Optional<class_2096.class_2100> focalLength, Optional<class_2096.class_2100> lightLevel, Optional<class_2096.class_2100> dayTime, Optional<class_2096.class_2100> entitiesInFrameCount, Optional<List<EntityInFramePredicate>> entitiesInFrame, Optional<ExtraDataPredicate> extraData) implements class_9365<Frame>
{
    public static final Codec<FramePredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExposureIdentifier.CODEC.optionalFieldOf("identifier").forGetter(FramePredicate::identifier), (App)Codec.STRING.optionalFieldOf("type").forGetter(FramePredicate::type), (App)Codec.STRING.optionalFieldOf("photographer").forGetter(FramePredicate::photographer), (App)ShutterSpeedPredicate.CODEC.optionalFieldOf("shutter_speed").forGetter(FramePredicate::shutterSpeed), (App)class_2096.class_2100.field_45763.optionalFieldOf("focal_length").forGetter(FramePredicate::focalLength), (App)class_2096.class_2100.field_45763.optionalFieldOf("light_level").forGetter(FramePredicate::lightLevel), (App)class_2096.class_2100.field_45763.optionalFieldOf("day_time").forGetter(FramePredicate::dayTime), (App)class_2096.class_2100.field_45763.optionalFieldOf("entities_in_frame_count").forGetter(FramePredicate::entitiesInFrameCount), (App)EntityInFramePredicate.CODEC.listOf().optionalFieldOf("entities_in_frame").forGetter(FramePredicate::entitiesInFrame), (App)ExtraDataPredicate.CODEC.optionalFieldOf("extra_data").forGetter(FramePredicate::extraData)).apply((Applicative)instance, FramePredicate::new));

    @NotNull
    public class_9331<Frame> method_58163() {
        return Exposure.DataComponents.PHOTOGRAPH_FRAME;
    }

    public boolean matches(class_1799 stack, Frame frame) {
        return this.matches(frame);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matches(Frame frame) {
        if (!this.identifier.isEmpty()) {
            if (!this.identifier.get().equals(frame.identifier())) return false;
        }
        if (!this.type.isEmpty()) {
            if (!this.type.get().equals(frame.type().method_15434())) return false;
        }
        if (!this.photographer.isEmpty()) {
            if (!this.photographer.get().equals(frame.photographer().name())) return false;
        }
        if (!this.shutterSpeed.isEmpty()) {
            if (!this.shutterSpeed.get().matches(frame.extraData().get(Frame.SHUTTER_SPEED))) return false;
        }
        if (!this.focalLength.isEmpty()) {
            if (frame.extraData().get(Frame.FOCAL_LENGTH).map(arg_0 -> ((class_2096.class_2100)this.focalLength.get()).method_9054(arg_0)).orElse(false) == false) return false;
        }
        if (!this.lightLevel.isEmpty()) {
            if (frame.extraData().get(Frame.LIGHT_LEVEL).map(arg_0 -> ((class_2096.class_2100)this.lightLevel.get()).method_9054(arg_0)).orElse(false) == false) return false;
        }
        if (!this.dayTime.isEmpty()) {
            if (frame.extraData().get(Frame.DAY_TIME).map(arg_0 -> ((class_2096.class_2100)this.dayTime.get()).method_9054(arg_0)).orElse(false) == false) return false;
        }
        if (!this.entitiesInFrameCount.isEmpty()) {
            if (!this.entitiesInFrameCount.get().method_9054(frame.entitiesInFrame().size())) return false;
        }
        if (!this.entitiesInFrame.isEmpty()) {
            if (!this.entitiesInFrame.get().stream().allMatch(predicate -> predicate.matches(frame.entitiesInFrame()))) return false;
        }
        if (this.extraData.isEmpty()) return true;
        if (!this.extraData.get().matches((class_2520)frame.extraData())) return false;
        return true;
    }
}

