/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui.component;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.client.gui.Tooltips;
import io.github.mortuusars.exposure.client.gui.Widgets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1060;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7919;
import net.minecraft.class_8666;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CycleButton<T>
extends class_4185 {
    protected final List<T> values;
    protected final T startingValue;
    protected final Map<T, class_8666> spritesMap;
    protected OnCycle<T> onCycle;
    protected boolean loop = true;
    @Nullable
    protected class_7919 defaultTooltip;
    protected Map<T, @Nullable class_7919> tooltips = Collections.emptyMap();
    @Nullable
    protected class_3414 clickSound;
    protected int currentIndex;

    public CycleButton(int x, int y, int width, int height, List<T> values, @NotNull T startingValue, Map<T, class_8666> spritesMap, OnCycle<T> onCycle) {
        super(x, y, width, height, class_5244.field_39003, b -> {}, field_40754);
        Preconditions.checkArgument((!values.isEmpty() ? 1 : 0) != 0, (Object)"Cannot create a CycleButton with 0 possible values.");
        this.values = values;
        this.startingValue = startingValue;
        Preconditions.checkArgument((!spritesMap.isEmpty() ? 1 : 0) != 0, (Object)"Cannot create a CycleButton with 0 sprites.");
        this.spritesMap = spritesMap;
        this.onCycle = onCycle;
        this.setCurrentIndex(Math.max(values.indexOf(startingValue), 0));
    }

    public CycleButton(int x, int y, int width, int height, List<T> values, @NotNull T startingValue, Map<T, class_8666> spritesMap) {
        this(x, y, width, height, values, startingValue, spritesMap, (CycleButton<T> b, T v) -> {});
    }

    public CycleButton(int x, int y, int width, int height, List<T> values, @NotNull T startingValue, Function<T, class_8666> spritesFunc, OnCycle<T> onCycle) {
        this(x, y, width, height, values, startingValue, Widgets.createMap(values, spritesFunc), onCycle);
    }

    public CycleButton(int x, int y, int width, int height, List<T> values, @NotNull T startingValue, Function<T, class_8666> spritesFunc) {
        this(x, y, width, height, values, startingValue, Widgets.createMap(values, spritesFunc), (CycleButton<T> b, T v) -> {});
    }

    public CycleButton<T> setLooping(boolean loop) {
        this.loop = loop;
        return this;
    }

    public CycleButton<T> setDefaultTooltip(class_7919 tooltip) {
        this.defaultTooltip = tooltip;
        this.updateVisuals();
        return this;
    }

    public CycleButton<T> setTooltips(Map<T, class_7919> tooltips) {
        this.tooltips = tooltips;
        this.updateVisuals();
        return this;
    }

    public CycleButton<T> setTooltips(Function<T, class_2561> tooltipFunc) {
        this.tooltips = Tooltips.createMap(this.values, tooltipFunc);
        this.updateVisuals();
        return this;
    }

    public CycleButton<T> setClickSound(class_3414 soundEvent) {
        this.clickSound = soundEvent;
        return this;
    }

    public CycleButton<T> onCycle(OnCycle<T> onCycle) {
        this.onCycle = onCycle;
        return this;
    }

    public CycleButton<T> onCycle(Consumer<T> onCycle) {
        this.onCycle = (button, newValue) -> onCycle.accept(newValue);
        return this;
    }

    public T getCurrentValue() {
        return this.values.get(class_3532.method_15340((int)this.currentIndex, (int)0, (int)(this.values.size() - 1)));
    }

    public void setCurrentValue(T value) {
        this.setCurrentIndex(class_3532.method_15340((int)this.values.indexOf(value), (int)0, (int)(this.values.size() - 1)));
    }

    public void setCurrentIndex(int index) {
        this.currentIndex = index;
        this.updateVisuals();
    }

    public void cycle(boolean reverse) {
        int value = this.currentIndex;
        if ((value += reverse ? -1 : 1) < 0) {
            value = this.loop ? this.values.size() - 1 : 0;
        } else if (value >= this.values.size()) {
            int n = value = this.loop ? 0 : this.values.size() - 1;
        }
        if (this.currentIndex != value) {
            this.currentIndex = value;
            this.onCycle();
        }
    }

    protected void onCycle() {
        this.updateVisuals();
        this.onCycle.onCycle(this, this.getCurrentValue());
    }

    private void updateVisuals() {
        @Nullable class_7919 tooltip = this.tooltips.getOrDefault(this.getCurrentValue(), this.defaultTooltip);
        if (tooltip != null) {
            this.method_47400(tooltip);
        }
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        @Nullable class_8666 sprites = this.spritesMap.get(this.getCurrentValue());
        class_2960 spriteLocation = sprites != null ? sprites.method_52729(this.method_37303(), this.method_25367()) : class_1060.field_5285;
        guiGraphics.method_52706(spriteLocation, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if ((button == 0 || button == 1) && this.method_25361(mouseX, mouseY)) {
            this.cycle(button == 1);
            this.method_25354(class_310.method_1551().method_1483());
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.cycle(scrollY < 0.0);
        this.method_25354(class_310.method_1551().method_1483());
        return true;
    }

    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        boolean pressed = super.method_25404(pKeyCode, pScanCode, pModifiers);
        if (pressed) {
            this.cycle(class_437.method_25442());
        }
        return pressed;
    }

    public void method_25354(class_1144 handler) {
        if (this.clickSound != null) {
            handler.method_4873((class_1113)class_1109.method_4758((class_3414)this.clickSound, (float)1.0f));
        }
    }

    public static interface OnCycle<T> {
        public void onCycle(CycleButton<T> var1, T var2);
    }
}

