/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui.screen.element.textbox;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.exposure.client.gui.screen.element.textbox.DisplayCache;
import io.github.mortuusars.exposure.client.gui.screen.element.textbox.HorizontalAlignment;
import io.github.mortuusars.exposure.util.Pos2i;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3728;
import net.minecraft.class_437;
import net.minecraft.class_5225;
import net.minecraft.class_5244;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_768;
import org.jetbrains.annotations.NotNull;

public class TextBox
extends class_339 {
    public final class_327 font;
    public Supplier<String> textGetter;
    public Consumer<String> textSetter;
    public Predicate<String> textValidator = text -> {
        int n;
        if (text == null) return false;
        int n2 = this.getFont().method_1713(text, this.field_22758);
        if (text.endsWith("\n")) {
            Objects.requireNonNull(this.getFont());
            n = 9;
        } else {
            n = 0;
        }
        if (n2 + n > this.field_22759) return false;
        return true;
    };
    public HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
    public int fontColor = -16777216;
    public int fontUnfocusedColor = -16777216;
    public int selectionColor = -16776961;
    public int selectionUnfocusedColor = -2013265665;
    public final class_3728 textFieldHelper;
    protected DisplayCache displayCache = new DisplayCache();
    protected int frameTick;
    protected long lastClickTime;
    protected int lastIndex = -1;

    public TextBox(@NotNull class_327 font, int x, int y, int width, int height, Supplier<String> textGetter, Consumer<String> textSetter) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.font = font;
        this.textGetter = textGetter;
        this.textSetter = textSetter;
        this.textFieldHelper = new class_3728(this::getText, this::setText, class_3728.method_27550((class_310)class_310.method_1551()), class_3728.method_27561((class_310)class_310.method_1551()), this::validateText);
    }

    public void tick() {
        ++this.frameTick;
    }

    public class_327 getFont() {
        return this.font;
    }

    @NotNull
    public String getText() {
        return this.textGetter.get();
    }

    public TextBox setText(@NotNull String text) {
        this.textSetter.accept(text);
        this.clearDisplayCache();
        return this;
    }

    protected boolean validateText(String text) {
        return this.textValidator.test(text);
    }

    public void method_53533(int height) {
        this.field_22759 = height;
        this.clearDisplayCache();
    }

    public int getCurrentFontColor() {
        return this.method_25370() ? this.fontColor : this.fontUnfocusedColor;
    }

    public TextBox setFontColor(int fontColor, int fontUnfocusedColor) {
        this.fontColor = fontColor;
        this.fontUnfocusedColor = fontUnfocusedColor;
        this.clearDisplayCache();
        return this;
    }

    public TextBox setFontColor(int fontColor) {
        this.fontColor = fontColor;
        this.fontUnfocusedColor = fontColor;
        this.clearDisplayCache();
        return this;
    }

    public TextBox setSelectionColor(int selectionColor, int selectionUnfocusedColor) {
        this.selectionColor = selectionColor;
        this.selectionUnfocusedColor = selectionUnfocusedColor;
        this.clearDisplayCache();
        return this;
    }

    public void setCursorToEnd() {
        this.textFieldHelper.method_16204();
        this.clearDisplayCache();
    }

    public void refresh() {
        this.clearDisplayCache();
    }

    protected DisplayCache getDisplayCache() {
        if (this.displayCache.needsRebuilding) {
            this.displayCache.rebuild(this.font, this.getText(), this.textFieldHelper.method_16201(), this.textFieldHelper.method_16203(), this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), this.horizontalAlignment);
        }
        return this.displayCache;
    }

    protected void clearDisplayCache() {
        this.displayCache.needsRebuilding = true;
    }

    protected Pos2i convertLocalToScreen(Pos2i pos) {
        return new Pos2i(this.method_46426() + pos.x, this.method_46427() + pos.y);
    }

    protected Pos2i convertScreenToLocal(Pos2i screenPos) {
        return new Pos2i(screenPos.x - this.method_46426(), screenPos.y - this.method_46427());
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        DisplayCache displayCache = this.getDisplayCache();
        for (DisplayCache.LineInfo lineInfo : displayCache.lines) {
            guiGraphics.method_51439(this.font, lineInfo.asComponent, this.method_46426() + lineInfo.x, this.method_46427() + lineInfo.y, this.getCurrentFontColor(), false);
        }
        this.renderHighlight(guiGraphics, displayCache.selectionAreas);
        if (this.method_25370()) {
            this.renderCursor(guiGraphics, displayCache.cursorPos, displayCache.cursorAtEnd);
        }
    }

    protected void renderHighlight(class_332 guiGraphics, class_768[] highlightAreas) {
        for (class_768 selection : highlightAreas) {
            int x = this.method_46426() + selection.method_3321();
            int y = this.method_46427() + selection.method_3322();
            int x1 = x + selection.method_3319();
            int y1 = y + selection.method_3320();
            guiGraphics.method_51739(class_1921.method_51786(), x, y - 1, x1, y1, this.method_25370() ? this.selectionColor : this.selectionUnfocusedColor);
        }
    }

    protected void renderCursor(class_332 guiGraphics, Pos2i cursorPos, boolean isEndOfText) {
        if (this.frameTick / 6 % 2 == 0) {
            cursorPos = this.convertLocalToScreen(cursorPos);
            if (isEndOfText) {
                guiGraphics.method_51433(this.font, "_", cursorPos.x, cursorPos.y, this.getCurrentFontColor(), false);
            } else {
                guiGraphics.method_51448().method_22903();
                guiGraphics.method_51448().method_46416(0.0f, 0.0f, 50.0f);
                RenderSystem.disableBlend();
                int n = cursorPos.x;
                int n2 = cursorPos.y - 1;
                int n3 = cursorPos.x + 1;
                int n4 = cursorPos.y;
                Objects.requireNonNull(this.font);
                guiGraphics.method_25294(n, n2, n3, n4 + 9, this.getCurrentFontColor());
                guiGraphics.method_51448().method_22909();
            }
        }
    }

    protected void method_47399(class_6382 narrationElementOutput) {
        narrationElementOutput.method_37034(class_6381.field_33788, (class_2561)this.method_25360());
    }

    @NotNull
    public class_2561 method_25369() {
        return class_2561.method_43470((String)this.getText());
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.method_25370()) {
            return false;
        }
        boolean handled = this.handleKeyPressed(keyCode, scanCode, modifiers);
        if (handled) {
            this.clearDisplayCache();
        }
        return handled;
    }

    protected boolean handleKeyPressed(int keyCode, int scanCode, int modifiers) {
        class_3728.class_7279 cursorStep;
        class_3728.class_7279 class_72792 = cursorStep = class_437.method_25441() ? class_3728.class_7279.field_38309 : class_3728.class_7279.field_38308;
        if (keyCode == 265) {
            this.changeLine(-1);
            return true;
        }
        if (keyCode == 264) {
            this.changeLine(1);
            return true;
        }
        if (keyCode == 268) {
            this.keyHome();
            return true;
        }
        if (keyCode == 269) {
            this.keyEnd();
            return true;
        }
        if (keyCode == 259) {
            this.textFieldHelper.method_42574(-1, cursorStep);
            return true;
        }
        if (keyCode == 261) {
            this.textFieldHelper.method_42574(1, cursorStep);
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            this.textFieldHelper.method_16197(class_5244.field_33849.getString());
            return true;
        }
        return this.textFieldHelper.method_16202(keyCode);
    }

    public boolean method_25400(char codePoint, int modifiers) {
        if (!this.method_25370()) {
            return false;
        }
        boolean typed = this.textFieldHelper.method_16199(codePoint);
        if (typed) {
            this.clearDisplayCache();
        }
        return typed;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.field_22762 && this.field_22764 && this.method_37303() && button == 0) {
            long currentTime = class_156.method_658();
            DisplayCache displayCache = this.getDisplayCache();
            int index = displayCache.getIndexAtPosition(this.font, this.convertScreenToLocal(new Pos2i((int)mouseX, (int)mouseY)));
            if (index >= 0) {
                if (index == this.lastIndex && currentTime - this.lastClickTime < 250L) {
                    if (!this.textFieldHelper.method_27568()) {
                        this.selectWord(index);
                    } else {
                        this.textFieldHelper.method_27563();
                    }
                } else {
                    this.textFieldHelper.method_27560(index, class_437.method_25442());
                }
                this.clearDisplayCache();
            }
            this.lastIndex = index;
            this.lastClickTime = currentTime;
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0) {
            DisplayCache displayCache = this.getDisplayCache();
            int index = displayCache.getIndexAtPosition(this.font, this.convertScreenToLocal(new Pos2i((int)mouseX, (int)mouseY)));
            this.textFieldHelper.method_27560(index, true);
            this.clearDisplayCache();
        }
        return true;
    }

    protected void selectWord(int index) {
        String string = this.getText();
        this.textFieldHelper.method_27548(class_5225.method_27483((String)string, (int)-1, (int)index, (boolean)false), class_5225.method_27483((String)string, (int)1, (int)index, (boolean)false));
    }

    protected void changeLine(int yChange) {
        int cursorPos = this.textFieldHelper.method_16201();
        int line = this.getDisplayCache().changeLine(cursorPos, yChange);
        this.textFieldHelper.method_27560(line, class_437.method_25442());
    }

    protected void keyHome() {
        if (class_437.method_25441()) {
            this.textFieldHelper.method_27553(class_437.method_25442());
        } else {
            int cursorIndex = this.textFieldHelper.method_16201();
            int lineStartIndex = this.getDisplayCache().findLineStart(cursorIndex);
            this.textFieldHelper.method_27560(lineStartIndex, class_437.method_25442());
        }
    }

    protected void keyEnd() {
        if (class_437.method_25441()) {
            this.textFieldHelper.method_27558(class_437.method_25442());
        } else {
            DisplayCache displayCache = this.getDisplayCache();
            int cursorIndex = this.textFieldHelper.method_16201();
            int lineEndIndex = displayCache.findLineEnd(cursorIndex);
            this.textFieldHelper.method_27560(lineEndIndex, class_437.method_25442());
        }
    }
}

