/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.image;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.client.image.Image;
import io.github.mortuusars.exposure.client.image.renderable.RenderableImage;
import io.github.mortuusars.exposure.client.image.renderable.RenderableImageIdentifier;
import io.github.mortuusars.exposure.util.color.Color;
import java.io.IOException;
import java.util.concurrent.Executor;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1049;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceImage
extends class_1049
implements RenderableImage {
    @Nullable
    protected class_1011 image;

    public ResourceImage(class_2960 location) {
        super(location);
    }

    @NotNull
    public static RenderableImage getOrCreate(class_2960 location) {
        class_1060 textureManager = class_310.method_1551().method_1531();
        @Nullable class_1044 existingTexture = (class_1044)textureManager.field_5286.get(location);
        if (existingTexture instanceof ResourceImage) {
            ResourceImage resourceImage = (ResourceImage)existingTexture;
            return resourceImage;
        }
        try {
            ResourceImage texture = new ResourceImage(location);
            textureManager.method_4616(location, (class_1044)texture);
            return texture;
        }
        catch (Exception e) {
            Exposure.LOGGER.error("Cannot load texture [{}]. {}", (Object)location, (Object)e);
            return RenderableImage.MISSING;
        }
    }

    @Override
    public int width() {
        @Nullable class_1011 image = this.getNativeImage();
        return image != null ? image.method_4307() : 1;
    }

    @Override
    public int height() {
        @Nullable class_1011 image = this.getNativeImage();
        return image != null ? image.method_4323() : 1;
    }

    @Override
    public int getPixelARGB(int x, int y) {
        @Nullable class_1011 image = this.getNativeImage();
        return image != null ? Color.ABGRtoARGB(image.method_4315(x, y)) : 0;
    }

    @Nullable
    public class_1011 getNativeImage() {
        if (this.image != null) {
            return this.image;
        }
        try {
            class_1011 image;
            this.image = image = super.method_18153(class_310.method_1551().method_1478()).method_18157();
            return image;
        }
        catch (IOException e) {
            Exposure.LOGGER.error("Cannot load texture: {}", (Object)e.toString());
            return null;
        }
    }

    public void method_18169(@NotNull class_1060 textureManager, @NotNull class_3300 resourceManager, @NotNull class_2960 path, @NotNull Executor executor) {
        super.method_18169(textureManager, resourceManager, path, executor);
        if (this.image != null) {
            this.image.close();
            this.image = null;
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.image != null) {
            this.image.close();
            this.image = null;
        }
    }

    @Override
    public Image getImage() {
        return this;
    }

    @Override
    public RenderableImageIdentifier getIdentifier() {
        return new RenderableImageIdentifier(this.field_5224.toString());
    }
}

