/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.image.modifier.pixel;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.client.image.modifier.pixel.PixelEffect;
import java.util.Random;
import net.minecraft.class_3532;
import net.minecraft.class_5253;

public class NoiseEffect
implements PixelEffect {
    protected final Random random = new Random();
    protected final float intensity;

    public NoiseEffect(float intensity) {
        Preconditions.checkArgument((intensity >= 0.0f && intensity <= 1.0f ? 1 : 0) != 0, (Object)"intensity should be in 0-1 range.");
        this.intensity = intensity;
    }

    @Override
    public String getIdentifier() {
        return "noise-" + this.intensity;
    }

    @Override
    public int modify(int colorARGB) {
        int alpha = class_5253.class_5254.method_27762((int)colorARGB);
        int red = class_5253.class_5254.method_27765((int)colorARGB);
        int green = class_5253.class_5254.method_27766((int)colorARGB);
        int blue = class_5253.class_5254.method_27767((int)colorARGB);
        float brightness = (0.299f * (float)red + 0.587f * (float)green + 0.114f * (float)blue) / 255.0f;
        float intensity = this.intensity * (1.0f - brightness);
        intensity = class_3532.method_16439((float)0.25f, (float)intensity, (float)this.intensity);
        int noise = (int)(this.random.nextGaussian() * (double)intensity * 155.0);
        int rNoise = (int)(this.random.nextGaussian() * (double)intensity * 100.0);
        int gNoise = (int)(this.random.nextGaussian() * (double)intensity * 100.0);
        int bNoise = (int)(this.random.nextGaussian() * (double)intensity * 100.0);
        red = class_3532.method_15340((int)(red + noise + rNoise), (int)0, (int)255);
        green = class_3532.method_15340((int)(green + noise + gNoise), (int)0, (int)255);
        blue = class_3532.method_15340((int)(blue + noise + bNoise), (int)0, (int)255);
        return class_5253.class_5254.method_27764((int)alpha, (int)red, (int)green, (int)blue);
    }
}

