/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.render;

import io.github.mortuusars.exposure.client.animation.Animation;
import io.github.mortuusars.exposure.client.animation.EasingFunction;
import io.github.mortuusars.exposure.client.camera.CameraClient;
import io.github.mortuusars.exposure.client.camera.viewfinder.Viewfinder;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class FovModifier {
    private static double lastFov = -1.0;
    @Nullable
    private static Animation restoringAnimation;
    private static double overrideFov;

    public static boolean shouldOverride() {
        return overrideFov != -1.0 || CameraClient.viewfinder() != null && CameraClient.viewfinder().isLookingThrough();
    }

    public static double modify(double originalValue) {
        if (overrideFov != -1.0) {
            return overrideFov;
        }
        Viewfinder viewfinder = CameraClient.viewfinder();
        if (viewfinder == null || !viewfinder.isLookingThrough()) {
            return FovModifier.restoreToOriginal(originalValue);
        }
        restoringAnimation = null;
        lastFov = viewfinder.zoom().getCurrentFov();
        return lastFov;
    }

    public static void setOverride(double fov) {
        overrideFov = fov;
    }

    public static void cancelOverride() {
        overrideFov = -1.0;
    }

    private static double restoreToOriginal(double originalValue) {
        if (lastFov == -1.0) {
            return originalValue;
        }
        if (restoringAnimation == null) {
            restoringAnimation = new Animation(300, EasingFunction.EASE_OUT_EXPO);
        }
        double fov = class_3532.method_16436((double)restoringAnimation.getValue(), (double)lastFov, (double)originalValue);
        if (restoringAnimation.isFinished()) {
            restoringAnimation = null;
            lastFov = -1.0;
        }
        return fov;
    }

    static {
        overrideFov = -1.0;
    }
}

