/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.render.photograph;

import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.client.image.renderable.RenderableImage;
import io.github.mortuusars.exposure.client.render.image.RenderCoordinates;
import io.github.mortuusars.exposure.client.render.photograph.PhotographStyle;
import io.github.mortuusars.exposure.client.render.texture.TextureRenderer;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import io.github.mortuusars.exposure.world.item.StackedPhotographsItem;
import io.github.mortuusars.exposure.world.item.util.ItemAndStack;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7833;

public class PhotographRenderer {
    public boolean render(class_1799 itemStack, boolean renderPaper, boolean renderBackside, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        return this.render(itemStack, renderPaper, renderBackside, poseStack, bufferSource, packedLight, 255, 255, 255, 255);
    }

    public boolean render(class_1799 itemStack, boolean renderPaper, boolean renderBackside, class_4587 poseStack, class_4597 bufferSource, int packedLight, int r, int g, int b, int a) {
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof PhotographItem) {
            PhotographItem photographItem = (PhotographItem)class_17922;
            return this.renderPhotograph(poseStack, bufferSource, photographItem, itemStack, renderPaper, renderBackside, packedLight, r, g, b, a);
        }
        class_17922 = itemStack.method_7909();
        if (class_17922 instanceof StackedPhotographsItem) {
            StackedPhotographsItem stackedPhotographsItem = (StackedPhotographsItem)class_17922;
            return this.renderStackedPhotographs(stackedPhotographsItem, itemStack, poseStack, bufferSource, packedLight, r, g, b, a);
        }
        return false;
    }

    public boolean renderPhotograph(class_4587 poseStack, class_4597 bufferSource, PhotographItem photographItem, class_1799 photographStack, boolean renderPaper, boolean renderBackside, int packedLight, int r, int g, int b, int a) {
        PhotographStyle style = PhotographStyle.of(photographStack);
        Frame frame = photographItem.getFrame(photographStack);
        RenderableImage image = style.process(ExposureClient.renderedExposures().getOrCreate(frame));
        int paperRotation = frame.identifier().hashCode() % 4 * 90;
        if (renderPaper && style.paperTexture() != ExposureClient.Textures.EMPTY) {
            poseStack.method_22903();
            poseStack.method_46416(0.5f, 0.5f, 0.0f);
            poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)paperRotation));
            poseStack.method_46416(-0.5f, -0.5f, 0.0f);
            TextureRenderer.render(poseStack, bufferSource, style.paperTexture(), packedLight, r, g, b, a);
            poseStack.method_22909();
            if (renderBackside) {
                poseStack.method_22903();
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                poseStack.method_22904(-0.5, 0.0, -0.5);
                poseStack.method_46416(0.5f, 0.5f, 0.0f);
                poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)paperRotation));
                poseStack.method_46416(-0.5f, -0.5f, 0.0f);
                TextureRenderer.render(poseStack, bufferSource, style.paperTexture(), packedLight, (int)((float)r * 0.85f), (int)((float)g * 0.85f), (int)((float)b * 0.85f), a);
                poseStack.method_22909();
            }
        }
        if (renderPaper) {
            poseStack.method_22903();
            float offset = 0.0625f;
            poseStack.method_22904((double)offset, (double)offset, 0.001);
            poseStack.method_22905(0.875f, 0.875f, 0.875f);
            ExposureClient.imageRenderer().render(image, poseStack, bufferSource, RenderCoordinates.DEFAULT, packedLight, r, g, b, a);
            poseStack.method_22909();
        } else {
            ExposureClient.imageRenderer().render(image, poseStack, bufferSource, RenderCoordinates.DEFAULT, packedLight, r, g, b, a);
        }
        if (renderPaper && style.hasOverlayTexture()) {
            poseStack.method_22903();
            poseStack.method_46416(0.5f, 0.5f, 0.0f);
            poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)paperRotation));
            poseStack.method_46416(-0.5f, -0.5f, 0.0f);
            poseStack.method_22904(0.0, 0.0, 0.002);
            TextureRenderer.render(poseStack, bufferSource, style.overlayTexture(), packedLight, r, g, b, a);
            poseStack.method_22909();
        }
        return !image.isEmpty();
    }

    public boolean renderStackedPhotographs(StackedPhotographsItem stackedPhotographsItem, class_1799 stack, class_4587 poseStack, class_4597 bufferSource, int packedLight, int r, int g, int b, int a) {
        List<ItemAndStack<PhotographItem>> photographs = stackedPhotographsItem.getPhotographs(stack);
        return this.renderStackedPhotographs(photographs, poseStack, bufferSource, packedLight, r, g, b, a);
    }

    public boolean renderStackedPhotographs(List<ItemAndStack<PhotographItem>> photographs, class_4587 poseStack, class_4597 bufferSource, int packedLight, int r, int g, int b, int a) {
        if (photographs.isEmpty()) {
            return false;
        }
        boolean photographRendered = false;
        for (int i = 2; i >= 0; --i) {
            if (photographs.size() - 1 < i) continue;
            ItemAndStack<PhotographItem> photograph = photographs.get(i);
            if (i == 0) {
                poseStack.method_22903();
                poseStack.method_22904(0.0, 0.0, 0.002);
                photographRendered = this.renderPhotograph(poseStack, bufferSource, photograph.getItem(), photograph.getItemStack(), true, false, packedLight, r, g, b, a);
                poseStack.method_22909();
                break;
            }
            float posOffset = this.getStackedPhotographOffset() * (float)i;
            poseStack.method_22903();
            poseStack.method_22904((double)posOffset, (double)posOffset, 0.002 - (double)((float)i / 1000.0f));
            poseStack.method_46416(0.5f, 0.5f, 0.0f);
            Frame frame = photograph.getItem().getFrame(photograph.getItemStack());
            int rotation = frame.identifier().hashCode() % 4 * 90;
            poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)rotation));
            poseStack.method_46416(-0.5f, -0.5f, 0.0f);
            float brightness = 1.0f - this.getStackedBrightnessStep() * (float)i;
            PhotographStyle photographStyle = PhotographStyle.of(photograph.getItemStack());
            TextureRenderer.render(poseStack, bufferSource, photographStyle.paperTexture(), packedLight, (int)((float)r * brightness), (int)((float)g * brightness), (int)((float)b * brightness), a);
            poseStack.method_22909();
        }
        return photographRendered;
    }

    public float getStackedBrightnessStep() {
        return 0.2f;
    }

    public float getStackedPhotographOffset() {
        return 0.03125f;
    }
}

