/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.render.photograph;

import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.client.image.modifier.ImageEffect;
import io.github.mortuusars.exposure.client.image.renderable.RenderableImage;
import io.github.mortuusars.exposure.client.render.photograph.PhotographStyles;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public record PhotographStyle(class_2960 paperTexture, class_2960 overlayTexture, class_2960 albumPaperTexture, class_2960 albumOverlayTexture, ImageEffect modifier) {
    public static final PhotographStyle REGULAR = new PhotographStyle(ExposureClient.Textures.Photograph.REGULAR_PAPER, ExposureClient.Textures.EMPTY, ExposureClient.Textures.Photograph.REGULAR_ALBUM_PAPER, ExposureClient.Textures.EMPTY, ImageEffect.EMPTY);

    public static PhotographStyle of(class_1799 photographStack) {
        PhotographStyle photographStyle;
        class_1792 class_17922 = photographStack.method_7909();
        if (class_17922 instanceof PhotographItem) {
            PhotographItem photographItem = (PhotographItem)class_17922;
            photographStyle = PhotographStyles.get(photographItem.getType(photographStack));
        } else {
            photographStyle = REGULAR;
        }
        return photographStyle;
    }

    public boolean hasOverlayTexture() {
        return !this.overlayTexture().equals((Object)ExposureClient.Textures.EMPTY);
    }

    public boolean hasAlbumOverlayTexture() {
        return !this.albumOverlayTexture().equals((Object)ExposureClient.Textures.EMPTY);
    }

    public RenderableImage process(RenderableImage image) {
        return !this.modifier.equals(ImageEffect.EMPTY) ? image.modifyWith(this.modifier) : image;
    }
}

