/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.commands.exposure;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.commands.argument.TextureLocationArgument;
import io.github.mortuusars.exposure.commands.suggestion.ExposureIdSuggestionProvider;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.clientbound.ExposureDataResponseS2CP;
import io.github.mortuusars.exposure.network.packet.clientbound.ShowExposureCommandS2CP;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.level.storage.ExposureIdentifier;
import io.github.mortuusars.exposure.world.level.storage.RequestedPalettedExposure;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class ShowCommand {
    public static LiteralArgumentBuilder<class_2168> get() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"show").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"latest").executes(context -> ShowCommand.latest((class_2168)context.getSource(), ((class_2168)context.getSource()).method_9207(), false))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> ShowCommand.latest((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), false))).then(class_2170.method_9247((String)"negative").executes(context -> ShowCommand.latest((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), true))))).then(class_2170.method_9247((String)"negative").executes(context -> ShowCommand.latest((class_2168)context.getSource(), ((class_2168)context.getSource()).method_9207(), true))))).then(class_2170.method_9247((String)"id").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new ExposureIdSuggestionProvider()).executes(context -> ShowCommand.exposureId((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"id"), false))).then(class_2170.method_9247((String)"negative").executes(context -> ShowCommand.exposureId((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"id"), true)))))).then(class_2170.method_9247((String)"texture").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"path", (ArgumentType)new TextureLocationArgument()).executes(context -> ShowCommand.texture((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"path"), false))).then(class_2170.method_9247((String)"negative").executes(context -> ShowCommand.texture((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"path"), true)))));
    }

    private static int latest(class_2168 stack, @NotNull class_3222 player, boolean negative) {
        List<Frame> frames = ExposureServer.frameHistory().getFramesOf((class_1297)player);
        if (frames.isEmpty()) {
            stack.method_9213((class_2561)class_2561.method_43470((String)(player.method_5820() + " has not taken any photos yet.")));
            return 0;
        }
        Packets.sendToClient(new ShowExposureCommandS2CP(frames, negative), player);
        return 0;
    }

    private static int exposureId(class_2168 stack, String id, boolean negative) {
        class_3222 player = stack.method_44023();
        if (player == null) {
            stack.method_9213((class_2561)class_2561.method_43471((String)"command.exposure.show.error.not_a_player"));
            return 1;
        }
        RequestedPalettedExposure palettedExposure = ExposureServer.exposureRepository().load(id);
        if (palettedExposure.getData().isEmpty()) {
            stack.method_9213((class_2561)class_2561.method_43469((String)"command.exposure.show.error.not_found", (Object[])new Object[]{id}));
            return 0;
        }
        Packets.sendToClient(new ExposureDataResponseS2CP(id, palettedExposure), player);
        Packets.sendToClient(ShowExposureCommandS2CP.identifier(ExposureIdentifier.id(id), negative), player);
        return 0;
    }

    private static int texture(class_2168 stack, class_2960 path, boolean negative) {
        class_3222 player = stack.method_44023();
        if (player == null) {
            stack.method_9213((class_2561)class_2561.method_43471((String)"command.exposure.show.error.not_a_player"));
            return 1;
        }
        ExposureIdentifier identifier = ExposureIdentifier.texture(path);
        Packets.sendToClient(ShowExposureCommandS2CP.identifier(identifier, negative), player);
        return 0;
    }
}

