/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import io.github.mortuusars.exposure.Exposure;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.apache.commons.lang3.function.TriConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraData
extends class_2487 {
    public static final Codec<ExtraData> CODEC = class_2487.field_25128.xmap(ExtraData::new, data -> data);
    public static final class_9139<ByteBuf, ExtraData> STREAM_CODEC = class_9135.field_48556.method_56432(ExtraData::new, data -> data);
    public static final ExtraData EMPTY = new ExtraData(Collections.emptyMap());
    private final Map<String, class_2520> tags;

    protected ExtraData(Map<String, class_2520> tags) {
        super(tags);
        this.tags = tags;
    }

    public ExtraData() {
        this(new HashMap<String, class_2520>());
    }

    public ExtraData(class_2487 tag) {
        this(new HashMap<String, class_2520>());
        this.merge(tag);
    }

    public <T> Optional<T> get(@NotNull Type<T> type) {
        if (!this.method_10545(type.key())) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(type.getter().apply(this, type.key()));
        }
        catch (Exception e) {
            Exposure.LOGGER.error("Cannot get ExtraData entry: {}", (Object)e.getMessage());
            return Optional.empty();
        }
    }

    public <T> T getOrDefault(@NotNull Type<T> type, T defaultValue) {
        if (!this.method_10545(type.key())) {
            return defaultValue;
        }
        try {
            @Nullable T value = type.getter().apply(this, type.key());
            return value != null ? value : defaultValue;
        }
        catch (Exception e) {
            Exposure.LOGGER.error("Cannot get ExtraData entry: {}", (Object)e.getMessage());
            return defaultValue;
        }
    }

    public <T> void put(Type<T> type, @NotNull T value) {
        Preconditions.checkNotNull(value, (Object)"value");
        type.setter().accept((Object)this, (Object)type.key(), value);
    }

    public <T> void remove(Type<T> type) {
        this.method_10551(type.key());
    }

    @NotNull
    public ExtraData copy() {
        HashMap map = Maps.newHashMap((Map)Maps.transformValues(this.tags, class_2520::method_10707));
        return new ExtraData(map);
    }

    @NotNull
    public ExtraData merge(class_2487 other) {
        for (String key : other.method_10541()) {
            class_2520 tag = other.method_10580(key);
            assert (tag != null);
            if (tag.method_10711() == 10) {
                if (this.method_10573(key, 10)) {
                    class_2487 compoundTag = this.method_10562(key);
                    compoundTag.method_10543((class_2487)tag);
                    continue;
                }
                this.method_10566(key, tag.method_10707());
                continue;
            }
            this.method_10566(key, tag.method_10707());
        }
        return this;
    }

    public record Type<T>(String key, BiFunction<ExtraData, String, @Nullable T> getter, TriConsumer<ExtraData, String, T> setter) {
        public static Type<String> string(String key) {
            return new Type<String>(key, class_2487::method_10558, class_2487::method_10582);
        }

        public static Type<Boolean> bool(String key) {
            return new Type<Boolean>(key, class_2487::method_10577, class_2487::method_10556);
        }

        public static Type<Integer> intVal(String key) {
            return new Type<Integer>(key, class_2487::method_10550, class_2487::method_10569);
        }

        public static Type<Long> longVal(String key) {
            return new Type<Long>(key, class_2487::method_10537, class_2487::method_10544);
        }

        public static Type<Float> floatVal(String key) {
            return new Type<Float>(key, class_2487::method_10583, class_2487::method_10548);
        }

        public static Type<Double> doubleVal(String key) {
            return new Type<Double>(key, class_2487::method_10574, class_2487::method_10549);
        }

        public static <T extends class_3542> Type<T> stringRepresentable(String key, Function<String, @Nullable T> deserializeFunction) {
            return new Type<class_3542>(key, (data, k) -> (class_3542)deserializeFunction.apply(data.method_10558(k)), (data, k, value) -> data.method_10582(k, value.method_15434()));
        }

        public static Type<class_243> vec3(String key) {
            return new Type<class_243>(key, (data, k) -> {
                class_2499 pos = data.method_10554(k, 6);
                return new class_243(pos.method_10611(0), pos.method_10611(1), pos.method_10611(2));
            }, (data, k, value) -> {
                class_2499 pos = new class_2499();
                pos.add((Object)class_2489.method_23241((double)value.method_10216()));
                pos.add((Object)class_2489.method_23241((double)value.method_10214()));
                pos.add((Object)class_2489.method_23241((double)value.method_10215()));
                data.method_10566(k, (class_2520)pos);
            });
        }

        public static Type<class_2960> resourceLocation(String key) {
            return new Type<class_2960>(key, (data, k) -> class_2960.method_60654((String)data.method_10558(k)), (data, k, value) -> data.method_10582(k, value.toString()));
        }

        public static <T> Type<List<T>> list(String key, int tagType, Function<class_2520, T> extractFunc, Function<T, class_2520> packFunc) {
            return new Type<List<T>>(key, (data, k) -> data.method_10554(k, tagType).stream().map(extractFunc).toList(), (data, k, value) -> {
                class_2499 list = new class_2499();
                list.addAll(value.stream().map(packFunc).toList());
                data.method_10566(k, (class_2520)list);
            });
        }

        public static <T> Type<List<T>> stringBasedList(String key, Function<String, T> extractFunc, Function<T, String> packFunc) {
            return Type.list(key, 8, tag -> extractFunc.apply(tag.method_10714()), value -> class_2519.method_23256((String)((String)packFunc.apply(value))));
        }
    }
}

