/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.camera;

import com.mojang.serialization.Codec;
import io.github.mortuusars.exposure.Exposure;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public enum ColorChannel implements class_3542
{
    RED(-2600386),
    GREEN(-8665525),
    BLUE(-11635762);

    public static final Codec<ColorChannel> CODEC;
    public static final class_9139<ByteBuf, ColorChannel> STREAM_CODEC;
    private final int color;

    private ColorChannel(int color) {
        this.color = color;
    }

    public int getRepresentationColor() {
        return this.color;
    }

    public static Optional<ColorChannel> fromFilterStack(class_1799 stack) {
        if (stack.method_31573(Exposure.Tags.Items.RED_FILTERS)) {
            return Optional.of(RED);
        }
        if (stack.method_31573(Exposure.Tags.Items.GREEN_FILTERS)) {
            return Optional.of(GREEN);
        }
        if (stack.method_31573(Exposure.Tags.Items.BLUE_FILTERS)) {
            return Optional.of(BLUE);
        }
        return Optional.empty();
    }

    public static ColorChannel fromStringOrDefault(String serializedName, ColorChannel defaultValue) {
        for (ColorChannel value : ColorChannel.values()) {
            if (!value.method_15434().equals(serializedName)) continue;
            return value;
        }
        return defaultValue;
    }

    public static Optional<ColorChannel> fromStringOptional(String serializedName) {
        for (ColorChannel value : ColorChannel.values()) {
            if (!value.method_15434().equals(serializedName)) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public static ColorChannel fromStringOrThrow(String serializedName) {
        for (ColorChannel value : ColorChannel.values()) {
            if (!value.method_15434().equals(serializedName)) continue;
            return value;
        }
        throw new IllegalArgumentException(serializedName + " is not a valid ColorChannel.");
    }

    @NotNull
    public String method_15434() {
        return this.toString().toLowerCase();
    }

    public class_2960 getShader() {
        return Exposure.resource("shaders/" + this.method_15434() + "_filter.json");
    }

    static {
        CODEC = class_3542.method_28140(ColorChannel::values);
        STREAM_CODEC = class_9135.method_56375(id -> ColorChannel.values()[id], Enum::ordinal);
    }
}

