/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.camera.component;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.util.Fov;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FocalRange
implements class_3542 {
    public static final Codec<FocalRange> RANGE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("min").forGetter(FocalRange::min), (App)Codec.INT.fieldOf("max").forGetter(FocalRange::max)).apply((Applicative)instance, FocalRange::new));
    public static final Codec<FocalRange> PRIME_CODEC = Codec.INT.xmap(FocalRange::new, FocalRange::min);
    public static final Codec<FocalRange> CODEC = Codec.either(PRIME_CODEC, RANGE_CODEC).xmap(Either::unwrap, focalRange -> focalRange.isPrime() ? Either.left((Object)focalRange) : Either.right((Object)focalRange));
    public static final class_9139<ByteBuf, FocalRange> STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.field_48550, FocalRange::min, (class_9139)class_9135.field_48550, FocalRange::max, FocalRange::new);
    public static final FocalRange REGULAR = new FocalRange(18, 55);
    public static final int ALLOWED_MIN = 10;
    public static final int ALLOWED_MAX = 300;
    private final int min;
    private final int max;

    public FocalRange(int min, int max) {
        Preconditions.checkArgument((10 <= min && min <= 300 ? 1 : 0) != 0, (Object)(min + " is not in allowed range for 'min'."));
        Preconditions.checkArgument((10 <= max && max <= 300 ? 1 : 0) != 0, (Object)(max + " is not in allowed range for 'max'."));
        Preconditions.checkArgument((min <= max ? 1 : 0) != 0, (Object)("'min' should not be larger than 'max'. min: " + min + ", max: " + max));
        this.min = min;
        this.max = max;
    }

    public FocalRange(int primeValue) {
        Preconditions.checkArgument((10 <= primeValue && primeValue <= 300 ? 1 : 0) != 0, (Object)(primeValue + " is not in allowed range: 10-300"));
        this.min = primeValue;
        this.max = primeValue;
    }

    public boolean isPrime() {
        return this.min == this.max;
    }

    public double focalLengthFromZoom(double zoom) {
        zoom = class_3532.method_15350((double)zoom, (double)0.0, (double)1.0);
        return class_3532.method_33722((double)zoom, (double)0.0, (double)1.0, (double)this.min, (double)this.max);
    }

    public double fovFromZoom(double zoom) {
        return Fov.focalLengthToFov(this.focalLengthFromZoom(zoom));
    }

    public double zoomFromFov(double fov) {
        double focalLength = Fov.fovToFocalLength(fov);
        return class_3532.method_33722((double)focalLength, (double)this.min(), (double)this.max(), (double)0.0, (double)1.0);
    }

    public double clampFocalLength(double focalLength) {
        return class_3532.method_15350((double)focalLength, (double)this.min, (double)this.max);
    }

    public double clampFov(double fov) {
        return class_3532.method_15350((double)fov, (double)Fov.focalLengthToFov(this.max), (double)Fov.focalLengthToFov(this.min));
    }

    @NotNull
    public static FocalRange getDefault() {
        return FocalRange.parse((String)Config.Server.CAMERA_DEFAULT_FOCAL_RANGE.get());
    }

    @NotNull
    public String method_15434() {
        return this.isPrime() ? Integer.toString(this.min) : this.min + "-" + this.max;
    }

    public static FocalRange parse(String value) {
        int dashIndex = value.indexOf("-");
        if (dashIndex == -1) {
            int prime = Integer.parseInt(value);
            return new FocalRange(prime);
        }
        int min = Integer.parseInt(value.substring(0, dashIndex));
        int max = Integer.parseInt(value.substring(dashIndex + 1));
        return new FocalRange(min, max);
    }

    public static FocalRange fromJson(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Item cannot be null");
        }
        if (json.isJsonPrimitive()) {
            int fixedValue = json.getAsInt();
            return new FocalRange(fixedValue);
        }
        if (json.isJsonObject()) {
            JsonObject obj = json.getAsJsonObject();
            int min = obj.get("min").getAsInt();
            int max = obj.get("max").getAsInt();
            return new FocalRange(min, max);
        }
        throw new JsonSyntaxException("Invalid FocalRange json. Expected a number or json object with 'min' and 'max'.");
    }

    public int min() {
        return this.min;
    }

    public int max() {
        return this.max;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        FocalRange that = (FocalRange)obj;
        return this.min == that.min && this.max == that.max;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }

    public String toString() {
        if (this.isPrime()) {
            return "FocalRange[fixed=" + this.min + "]";
        }
        return "FocalRange[min=" + this.min + ", max=" + this.max + "]";
    }
}

