/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.data.ColorPalette;
import io.github.mortuusars.exposure.data.ColorPalettes;
import io.github.mortuusars.exposure.world.camera.capture.DitherMode;
import io.github.mortuusars.exposure.world.camera.film.properties.ColorBalance;
import io.github.mortuusars.exposure.world.camera.film.properties.FilmProperties;
import io.github.mortuusars.exposure.world.camera.film.properties.FilmStyle;
import io.github.mortuusars.exposure.world.camera.film.properties.HSB;
import io.github.mortuusars.exposure.world.camera.film.properties.Levels;
import io.github.mortuusars.exposure.world.item.FilmItem;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SensitiveFilmItem
extends FilmItem {
    @NotNull
    default public FilmProperties getFilmProperties(class_1799 stack) {
        return new FilmProperties(this.getType(), Optional.of(this.getFrameSize(stack)), this.getColorPalette(stack), this.getDitherMode(stack), this.getFilmStyle(stack));
    }

    @NotNull
    default public FilmStyle getFilmStyle(class_1799 stack) {
        return (FilmStyle)stack.method_57825(Exposure.DataComponents.FILM_STYLE, (Object)FilmStyle.EMPTY);
    }

    default public class_5321<ColorPalette> getColorPalette(class_1799 stack) {
        @Nullable class_2960 location = (class_2960)stack.method_57824(Exposure.DataComponents.FILM_COLOR_PALETTE);
        if (location != null) {
            return ColorPalettes.createKey(location);
        }
        return ColorPalettes.DEFAULT;
    }

    @NotNull
    default public DitherMode getDitherMode(class_1799 stack) {
        return (DitherMode)((Object)stack.method_57825(Exposure.DataComponents.FILM_DITHER_MODE, (Object)DitherMode.DITHERED));
    }

    default public void addFrameSizeToTooltip(class_1799 stack, List<class_2561> list) {
        int frameSize = this.getFrameSize(stack);
        if (frameSize != this.getDefaultFrameSize(stack)) {
            list.add((class_2561)class_2561.method_43469((String)"item.exposure.film_roll.tooltip.frame_size", (Object[])new Object[]{class_2561.method_43470((String)String.format("%.1f", Float.valueOf((float)frameSize / 10.0f)))}).method_27692(class_124.field_1080));
        }
    }

    default public void addPaletteToTooltip(class_1799 stack, List<class_2561> list) {
        class_5321<ColorPalette> palette = this.getColorPalette(stack);
        if (!palette.equals(ColorPalettes.DEFAULT)) {
            list.add((class_2561)class_2561.method_43469((String)"item.exposure.film_roll.tooltip.palette", (Object[])new Object[]{palette.method_29177().toString()}).method_27692(class_124.field_1063));
        }
    }

    default public void addStyleToTooltip(class_1799 stack, List<class_2561> list) {
        FilmStyle style = this.getFilmStyle(stack);
        if (style.sensitivity().floatValue() != 0.0f) {
            list.add((class_2561)class_2561.method_43469((String)"item.exposure.film_roll.tooltip.sensitivity", (Object[])new Object[]{style.sensitivity()}).method_27692(class_124.field_1063));
        }
        if (style.contrast().floatValue() != 0.0f) {
            list.add((class_2561)class_2561.method_43469((String)"item.exposure.film_roll.tooltip.contrast", (Object[])new Object[]{style.contrast()}).method_27692(class_124.field_1063));
        }
        if (style.levels() != Levels.EMPTY) {
            list.add((class_2561)class_2561.method_43469((String)"item.exposure.film_roll.tooltip.levels", (Object[])new Object[]{style.levels().toString()}).method_27692(class_124.field_1063));
        }
        if (style.hsb() != HSB.EMPTY) {
            list.add((class_2561)class_2561.method_43469((String)"item.exposure.film_roll.tooltip.hsb", (Object[])new Object[]{style.hsb().toString()}).method_27692(class_124.field_1063));
        }
        if (style.colorBalance() != ColorBalance.EMPTY) {
            list.add((class_2561)class_2561.method_43469((String)"item.exposure.film_roll.tooltip.color_balance", (Object[])new Object[]{style.colorBalance().toString()}).method_27692(class_124.field_1063));
        }
        if (style.noise().floatValue() != 0.0f) {
            list.add((class_2561)class_2561.method_43469((String)"item.exposure.film_roll.tooltip.noise", (Object[])new Object[]{style.noise()}).method_27692(class_124.field_1063));
        }
    }
}

