/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item.camera;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.world.item.FilmRollItem;
import io.github.mortuusars.exposure.world.item.component.StoredItemStack;
import io.github.mortuusars.exposure.world.sound.Sound;
import io.github.mortuusars.exposure.world.sound.SoundEffect;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_9331;

public record Attachment<T extends class_1792>(class_2960 id, class_9331<StoredItemStack> component, Predicate<class_1799> itemPredicate, Class<T> itemType, Supplier<Integer> maxCount, Optional<SoundEffect> insertedSound, Optional<SoundEffect> removedSound) {
    public static final Attachment<FilmRollItem> FILM = new Attachment<FilmRollItem>(Exposure.resource("film"), Exposure.DataComponents.FILM, stack -> stack.method_7909() instanceof FilmRollItem, FilmRollItem.class, () -> 1, new SoundEffect(Exposure.SoundEvents.FILM_ADVANCE, 0.9f, 1.0f), new SoundEffect(Exposure.SoundEvents.FILM_REMOVED, 0.7f, 1.0f));
    public static final Attachment<class_1792> FLASH = new Attachment<class_1792>(Exposure.resource("flash"), Exposure.DataComponents.FLASH, stack -> stack.method_31573(Exposure.Tags.Items.FLASHES), class_1792.class, () -> 1, new SoundEffect(Exposure.SoundEvents.CAMERA_GENERIC_CLICK, 0.6f, 1.15f), new SoundEffect(Exposure.SoundEvents.CAMERA_GENERIC_CLICK, 0.35f, 0.95f));
    public static final Attachment<class_1792> LENS = new Attachment<class_1792>(Exposure.resource("lens"), Exposure.DataComponents.LENS, stack -> stack.method_31573(Exposure.Tags.Items.LENSES), class_1792.class, () -> 1, new SoundEffect(Exposure.SoundEvents.LENS_INSERT), new SoundEffect(Exposure.SoundEvents.LENS_REMOVE));
    public static final Attachment<class_1792> FILTER = new Attachment<class_1792>(Exposure.resource("filter"), Exposure.DataComponents.FILTER, stack -> stack.method_31573(Exposure.Tags.Items.FILTERS), class_1792.class, () -> 1, new SoundEffect(Exposure.SoundEvents.FILTER_INSERT), new SoundEffect(Exposure.SoundEvents.FILTER_REMOVE, 0.5f));

    public Attachment(class_2960 id, class_9331<StoredItemStack> component, Predicate<class_1799> itemPredicate, Class<T> itemType, Supplier<Integer> maxCount, SoundEffect insertedSound, SoundEffect removedSound) {
        this(id, component, itemPredicate, itemType, maxCount, Optional.of(insertedSound), Optional.of(removedSound));
    }

    public Attachment(class_2960 id, class_9331<StoredItemStack> component, Predicate<class_1799> itemPredicate, Class<T> itemType, Supplier<Integer> maxCount) {
        this(id, component, itemPredicate, itemType, maxCount, Optional.empty(), Optional.empty());
    }

    public boolean matches(class_1799 stack) {
        return this.itemPredicate.test(stack);
    }

    public boolean isEmpty(class_1799 stack) {
        StoredItemStack storedItemStack = this.get(stack);
        return storedItemStack.isEmpty() || !this.itemType.isInstance(storedItemStack.getItem());
    }

    public boolean isPresent(class_1799 stack) {
        return !this.isEmpty(stack);
    }

    public StoredItemStack get(class_1799 stack) {
        return (StoredItemStack)stack.method_57825(this.component, (Object)StoredItemStack.EMPTY);
    }

    public Attachment<T> ifPresent(class_1799 stack, BiConsumer<T, class_1799> ifPresent) {
        StoredItemStack storedItemStack = this.get(stack);
        if (this.itemType.isInstance(storedItemStack.getItem())) {
            ifPresent.accept((class_1792)this.itemType.cast(storedItemStack.getItem()), storedItemStack.getForReading());
        }
        return this;
    }

    public Attachment<T> ifPresent(class_1799 stack, Consumer<class_1799> ifPresent) {
        StoredItemStack storedItemStack = this.get(stack);
        if (this.itemType.isInstance(storedItemStack.getItem())) {
            ifPresent.accept(storedItemStack.getForReading());
        }
        return this;
    }

    public Attachment<T> orElse(class_1799 stack, Runnable orElse) {
        StoredItemStack storedItemStack = this.get(stack);
        if (!this.itemType.isInstance(storedItemStack.getItem())) {
            orElse.run();
        }
        return this;
    }

    public Attachment<T> ifPresentOrElse(class_1799 stack, BiConsumer<T, class_1799> ifPresent, Runnable orElse) {
        return this.ifPresent(stack, ifPresent).orElse(stack, orElse);
    }

    public <R> Optional<R> map(class_1799 stack, Function<class_1799, R> mappingFunc) {
        return this.mapOrElse(stack, (class_1799 st) -> Optional.of(mappingFunc.apply((class_1799)st)), Optional::empty);
    }

    public <R> Optional<R> map(class_1799 stack, BiFunction<T, class_1799, R> mappingFunc) {
        return this.mapOrElse(stack, (T it, class_1799 st) -> Optional.of(mappingFunc.apply((Object)it, (class_1799)st)), Optional::empty);
    }

    public <R> R mapOrElse(class_1799 stack, Function<class_1799, R> ifPresentMappingFunc, Supplier<R> orElseSupplier) {
        StoredItemStack storedItemStack = this.get(stack);
        return this.itemType.isInstance(storedItemStack.getItem()) ? ifPresentMappingFunc.apply(storedItemStack.getForReading()) : orElseSupplier.get();
    }

    public <R> R mapOrElse(class_1799 stack, BiFunction<T, class_1799, R> ifPresentMappingFunc, Supplier<R> orElseSupplier) {
        StoredItemStack storedItemStack = this.get(stack);
        return this.itemType.isInstance(storedItemStack.getItem()) ? ifPresentMappingFunc.apply((class_1792)this.itemType.cast(storedItemStack.getItem()), storedItemStack.getForReading()) : orElseSupplier.get();
    }

    public Attachment<T> set(class_1799 stack, class_1799 attachment) {
        if (attachment.method_7960()) {
            stack.method_57381(this.component);
        } else {
            stack.method_57379(this.component, (Object)new StoredItemStack(attachment));
        }
        return this;
    }

    public void playInsertSoundSided(class_1297 entity) {
        this.insertedSound().ifPresent(sound -> Sound.playUniqueSided(Integer.toString(entity.method_5628()), entity, sound, class_3419.field_15248));
    }

    public void playRemoveSoundSided(class_1297 entity) {
        this.removedSound().ifPresent(sound -> Sound.playUniqueSided(Integer.toString(entity.method_5628()), entity, sound, class_3419.field_15248));
    }

    @Override
    public String toString() {
        return "Attachment{id='" + String.valueOf(this.id) + "'}";
    }
}

