/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item.camera;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.data.Filter;
import io.github.mortuusars.exposure.data.Filters;
import io.github.mortuusars.exposure.data.Lenses;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.clientbound.CaptureStartS2CP;
import io.github.mortuusars.exposure.network.packet.clientbound.ShutterOpenedS2CP;
import io.github.mortuusars.exposure.network.packet.serverbound.OpenCameraAttachmentsInCreativePacketC2SP;
import io.github.mortuusars.exposure.server.CameraInstance;
import io.github.mortuusars.exposure.server.CameraInstances;
import io.github.mortuusars.exposure.util.ExtraData;
import io.github.mortuusars.exposure.util.PointOfView;
import io.github.mortuusars.exposure.util.TranslatableError;
import io.github.mortuusars.exposure.util.UnixTimestamp;
import io.github.mortuusars.exposure.util.Vec3Util;
import io.github.mortuusars.exposure.util.color.Color;
import io.github.mortuusars.exposure.world.camera.Camera;
import io.github.mortuusars.exposure.world.camera.CameraId;
import io.github.mortuusars.exposure.world.camera.CameraInHand;
import io.github.mortuusars.exposure.world.camera.CameraOnStand;
import io.github.mortuusars.exposure.world.camera.ColorChannel;
import io.github.mortuusars.exposure.world.camera.ExposureType;
import io.github.mortuusars.exposure.world.camera.capture.CaptureParameters;
import io.github.mortuusars.exposure.world.camera.capture.CaptureType;
import io.github.mortuusars.exposure.world.camera.capture.Projection;
import io.github.mortuusars.exposure.world.camera.component.FocalRange;
import io.github.mortuusars.exposure.world.camera.component.SelfTimer;
import io.github.mortuusars.exposure.world.camera.component.ShutterSpeed;
import io.github.mortuusars.exposure.world.camera.film.properties.FilmProperties;
import io.github.mortuusars.exposure.world.camera.frame.EntitiesInFrame;
import io.github.mortuusars.exposure.world.camera.frame.EntityInFrame;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.camera.frame.Photographer;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import io.github.mortuusars.exposure.world.entity.CameraOperator;
import io.github.mortuusars.exposure.world.entity.CameraStandEntity;
import io.github.mortuusars.exposure.world.inventory.CameraInHandAttachmentsMenu;
import io.github.mortuusars.exposure.world.item.FilmRollItem;
import io.github.mortuusars.exposure.world.item.InterplanarProjectorItem;
import io.github.mortuusars.exposure.world.item.SensitiveFilmItem;
import io.github.mortuusars.exposure.world.item.camera.Attachment;
import io.github.mortuusars.exposure.world.item.camera.CameraSettings;
import io.github.mortuusars.exposure.world.item.camera.Flash;
import io.github.mortuusars.exposure.world.item.camera.Shutter;
import io.github.mortuusars.exposure.world.item.camera.Timer;
import io.github.mortuusars.exposure.world.item.component.StoredItemStack;
import io.github.mortuusars.exposure.world.level.LevelUtil;
import io.github.mortuusars.exposure.world.level.storage.ExposureIdentifier;
import io.github.mortuusars.exposure.world.sound.Sound;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1560;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2504;
import net.minecraft.class_2561;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9334;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;

public class CameraItem
extends class_1792 {
    public static final int BASE_COOLDOWN = 2;
    public static final int PROJECT_COOLDOWN = 20;
    protected final Shutter shutter = this.createShutter();
    protected final Timer timer = this.createTimer();
    protected final Flash flash = this.createFlash();
    protected final List<Attachment<?>> attachments = this.defineAttachments();
    protected final List<ShutterSpeed> availableShutterSpeeds = this.defineShutterSpeeds();

    public CameraItem(class_1792.class_1793 properties) {
        super(properties);
        this.shutter.onOpen((TriConsumer<CameraHolder, class_3218, class_1799>)((TriConsumer)this::onShutterOpen));
        this.shutter.onClosed((TriConsumer<CameraHolder, class_3218, class_1799>)((TriConsumer)this::onShutterClosed));
    }

    protected Shutter createShutter() {
        return new Shutter();
    }

    protected Timer createTimer() {
        return new Timer();
    }

    protected Flash createFlash() {
        return new Flash();
    }

    @NotNull
    protected List<Attachment<?>> defineAttachments() {
        return List.of(Attachment.FILM, Attachment.FLASH, Attachment.LENS, Attachment.FILTER);
    }

    protected List<ShutterSpeed> defineShutterSpeeds() {
        return List.of(new ShutterSpeed("1/500"), new ShutterSpeed("1/250"), new ShutterSpeed("1/125"), new ShutterSpeed("1/60"), new ShutterSpeed("1/30"), new ShutterSpeed("1/15"), new ShutterSpeed("1/8"), new ShutterSpeed("1/4"), new ShutterSpeed("1/2"), new ShutterSpeed("1\""));
    }

    public boolean hasAttachmentsMenu() {
        return true;
    }

    public Shutter getShutter() {
        return this.shutter;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public Flash getFlash() {
        return this.flash;
    }

    public List<ShutterSpeed> getAvailableShutterSpeeds() {
        return this.availableShutterSpeeds;
    }

    public List<Attachment<?>> getAttachments() {
        return this.attachments;
    }

    public Attachment<?> getFilmAttachment() {
        return Attachment.FILM;
    }

    @NotNull
    public FilmProperties getFilmProperties(class_1799 stack) {
        class_1799 filmStack = this.getFilmAttachment().get(stack).getForReading();
        class_1792 class_17922 = filmStack.method_7909();
        if (!(class_17922 instanceof SensitiveFilmItem)) {
            throw new IllegalStateException("Cannot take a photo without SensitiveFilmItem in the camera. stack: " + String.valueOf(stack));
        }
        SensitiveFilmItem filmItem = (SensitiveFilmItem)class_17922;
        return filmItem.getFilmProperties(filmStack);
    }

    public class_3414 getViewfinderOpenSound() {
        return Exposure.SoundEvents.VIEWFINDER_OPEN.get();
    }

    public class_3414 getViewfinderCloseSound() {
        return Exposure.SoundEvents.VIEWFINDER_CLOSE.get();
    }

    public class_3414 getReleaseButtonSound() {
        return Exposure.SoundEvents.CAMERA_RELEASE_BUTTON_CLICK.get();
    }

    public class_2960 getCaptureType(class_1799 stack) {
        return CaptureType.CAMERA;
    }

    public double getSelfieCameraDistance(class_1799 stack) {
        return (Double)Config.Server.SELFIE_CAMERA_DISTANCE.get();
    }

    public double getYPositionOffset(class_1799 stack) {
        return (Boolean)Config.Server.WAIST_LEVEL_VIEWFINDER.get() != false ? -0.35 : 0.0;
    }

    public float getScaleOnStand() {
        return 0.9f;
    }

    public float getCropFactor() {
        return 0.875f;
    }

    public FocalRange getFocalRange(class_5455 registryAccess, class_1799 stack) {
        return Attachment.LENS.map(stack, lensStack -> Lenses.getFocalRangeOrDefault(registryAccess, lensStack)).orElse(FocalRange.getDefault());
    }

    public double getFov(class_1937 level, class_1799 stack) {
        double zoom = CameraSettings.ZOOM.getOrDefault(stack).floatValue();
        FocalRange focalRange = this.getFocalRange(level.method_30349(), stack);
        return focalRange.fovFromZoom(zoom);
    }

    public double getViewfinderFov(class_1937 level, class_1799 stack) {
        return this.getFov(level, stack) * (double)this.getCropFactor();
    }

    public PointOfView getPointOfView(CameraHolder holder, class_1799 stack) {
        if (this.isInSelfieMode(stack)) {
            return PointOfView.of(holder).reverseDirection().limitMaxDistance(holder, this.getSelfieCameraDistance(stack)).rotateX(-CameraSettings.SELFIE_ROTATION_X.getOrDefault(stack).doubleValue()).rotateY(-CameraSettings.SELFIE_ROTATION_Y.getOrDefault(stack).doubleValue());
        }
        return PointOfView.of(holder).move(0.0, this.getYPositionOffset(stack), 0.0);
    }

    public Optional<Filter> getFilter(class_5455 registryAccess, class_1799 stack) {
        return Attachment.FILTER.map(stack, filter -> Filters.of(registryAccess, filter)).flatMap(Function.identity());
    }

    public Optional<class_2960> getFilterShaderLocation(class_5455 registryAccess, class_1799 stack) {
        return this.getFilter(registryAccess, stack).map(Filter::shader);
    }

    protected Optional<ColorChannel> getChromaticChannel(class_1799 stack) {
        return Attachment.FILTER.map(stack, ColorChannel::fromFilterStack).orElse(Optional.empty());
    }

    protected Optional<Projection> getProjection(class_1799 stack) {
        return Attachment.FILTER.map(stack, (filterItem, filterStack) -> {
            Optional<Object> optional;
            if (filterItem instanceof InterplanarProjectorItem) {
                InterplanarProjectorItem projectorItem = (InterplanarProjectorItem)((Object)filterItem);
                optional = projectorItem.getProjection((class_1799)filterStack);
            } else {
                optional = Optional.empty();
            }
            return optional;
        }).orElse(Optional.empty());
    }

    public CameraId getOrCreateId(class_1799 stack) {
        if (!stack.method_57826(Exposure.DataComponents.CAMERA_ID)) {
            stack.method_57379(Exposure.DataComponents.CAMERA_ID, (Object)CameraId.create());
        }
        return (CameraId)stack.method_57824(Exposure.DataComponents.CAMERA_ID);
    }

    public boolean isInSelfieMode(class_1799 stack) {
        return CameraSettings.SELFIE_MODE.getOrDefault(stack);
    }

    public boolean isActive(class_1799 stack) {
        return (Boolean)stack.method_57825(Exposure.DataComponents.CAMERA_ACTIVE, (Object)false);
    }

    public void setActive(class_1799 stack, boolean active) {
        if (!active) {
            stack.method_57381(Exposure.DataComponents.CAMERA_ACTIVE);
        } else {
            stack.method_57379(Exposure.DataComponents.CAMERA_ACTIVE, (Object)true);
        }
    }

    public boolean isDisassembled(class_1799 stack) {
        return (Boolean)stack.method_57825(Exposure.DataComponents.CAMERA_DISASSEMBLED, (Object)false);
    }

    public void setDisassembled(class_1799 stack, boolean disassembled) {
        if (!disassembled) {
            stack.method_57381(Exposure.DataComponents.CAMERA_DISASSEMBLED);
        } else {
            stack.method_57379(Exposure.DataComponents.CAMERA_DISASSEMBLED, (Object)true);
        }
    }

    public long getLastActionTime(class_1799 stack) {
        return (Long)stack.method_57825(Exposure.DataComponents.CAMERA_LAST_ACTION_TIME, (Object)-1L);
    }

    public void setLastActionTime(class_1799 stack, long lastActionTime) {
        stack.method_57379(Exposure.DataComponents.CAMERA_LAST_ACTION_TIME, (Object)lastActionTime);
    }

    public void actionPerformed(class_1799 stack, CameraHolder holder) {
        this.setLastActionTime(stack, holder.asHolderEntity().method_37908().method_8510());
        holder.asHolderEntity().method_32876((class_6880)class_5712.field_28146);
    }

    @NotNull
    public class_1271<class_1799> activateInHand(class_1657 player, class_1799 stack, @NotNull class_1268 hand) {
        player.setActiveExposureCamera((Camera)new CameraInHand((CameraHolder)player, this.getOrCreateId(stack), hand));
        if (player.method_37908().field_9236) {
            Minecrft.releaseUseButton();
        }
        return this.activate((class_1297)player, stack);
    }

    @NotNull
    public class_1271<class_1799> activateOnStand(class_1657 player, class_1799 stack, CameraStandEntity cameraStand) {
        player.setActiveExposureCamera((Camera)new CameraOnStand((CameraOperator)player, cameraStand, this.getOrCreateId(stack)));
        if (player.method_37908().field_9236) {
            Minecrft.releaseUseButton();
        }
        return this.activate((class_1297)player, stack);
    }

    @NotNull
    public class_1271<class_1799> activate(class_1297 entity, class_1799 stack) {
        this.setActive(stack, true);
        this.setDisassembled(stack, false);
        Sound.play(entity, this.getViewfinderOpenSound(), entity.method_5634(), 0.35f, 0.9f, 0.2f);
        entity.method_32876((class_6880)class_5712.field_28739);
        return class_1271.method_22428((Object)stack);
    }

    @NotNull
    public class_1271<class_1799> deactivate(class_1297 entity, class_1799 stack) {
        this.setActive(stack, false);
        CameraSettings.SELFIE_MODE.set(stack, (Boolean)false);
        Sound.play(entity, this.getViewfinderCloseSound(), entity.method_5634(), 0.35f, 0.9f, 0.2f);
        entity.method_32876((class_6880)class_5712.field_28739);
        return class_1271.method_22428((Object)stack);
    }

    public int calculateCooldownAfterShot(class_1799 stack, CaptureParameters captureParameters) {
        if (captureParameters.projection().isPresent()) {
            return 20;
        }
        if (captureParameters.getFlash()) {
            return this.getFlash().getCooldown();
        }
        return 2;
    }

    public boolean method_31567(@NotNull class_1799 stack) {
        return (Boolean)Config.Client.CAMERA_SHOW_FILM_BAR_ON_ITEM.get() != false && Attachment.FILM.map(stack, FilmRollItem::method_31567).orElse(false) != false;
    }

    public int method_31569(@NotNull class_1799 stack) {
        return Attachment.FILM.map(stack, FilmRollItem::method_31569).orElse(0);
    }

    public int method_31571(@NotNull class_1799 stack) {
        return Attachment.FILM.map(stack, FilmRollItem::method_31571).orElse(0);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> components, class_1836 tooltipFlag) {
        if (((Boolean)Config.Client.CAMERA_SHOW_FILM_FRAMES_IN_TOOLTIP.get()).booleanValue()) {
            Attachment.FILM.ifPresent(stack, (filmItem, filmStack) -> {
                int exposed = filmItem.getStoredFramesCount(filmStack);
                int max = filmItem.getMaxFrameCount(filmStack);
                components.add((class_2561)class_2561.method_43469((String)"item.exposure.camera.tooltip.film_roll_frames", (Object[])new Object[]{exposed, max}));
            });
        }
        if (((Boolean)Config.Client.CAMERA_SHOW_TOOLTIP_DETAILS.get()).booleanValue()) {
            if (stack.method_27319() instanceof CameraStandEntity) {
                if (class_437.method_25442()) {
                    components.add((class_2561)class_2561.method_43471((String)"item.exposure.camera.tooltip.details_attachments_screen_on_stand"));
                    components.add((class_2561)class_2561.method_43471((String)"item.exposure.camera.tooltip.details_hotswap_on_stand"));
                } else {
                    components.add((class_2561)class_2561.method_43471((String)"tooltip.exposure.hold_for_details"));
                }
                return;
            }
            boolean rClickAttachments = (Boolean)Config.Server.CAMERA_GUI_RIGHT_CLICK_OPEN_ATTACHMENTS.get();
            boolean rClickHotswap = (Boolean)Config.Server.CAMERA_GUI_RIGHT_CLICK_HOTSWAP.get();
            if (rClickAttachments || rClickHotswap) {
                if (class_437.method_25442()) {
                    if (rClickAttachments) {
                        components.add((class_2561)class_2561.method_43471((String)"item.exposure.camera.tooltip.details_attachments_screen"));
                    }
                    if (rClickHotswap) {
                        components.add((class_2561)class_2561.method_43471((String)"item.exposure.camera.tooltip.details_hotswap"));
                    }
                } else {
                    components.add((class_2561)class_2561.method_43471((String)"tooltip.exposure.hold_for_details"));
                }
            }
        }
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 action, class_1657 player, class_5630 access) {
        if (action != class_5536.field_27014) {
            return false;
        }
        if (this.getShutter().isOpen(stack)) {
            player.method_5783(Exposure.SoundEvents.CAMERA_LENS_RING_CLICK.get(), 0.9f, 1.0f);
            player.method_7353((class_2561)class_2561.method_43471((String)"item.exposure.camera.camera_attachments.fail.shutter_open").method_27692(class_124.field_1061), true);
            return true;
        }
        if (otherStack.method_7960() && ((Boolean)Config.Server.CAMERA_GUI_RIGHT_CLICK_OPEN_ATTACHMENTS.get()).booleanValue()) {
            if (!(slot.field_7871 instanceof class_1661)) {
                return false;
            }
            if (player.method_7337() && player.method_37908().method_8608()) {
                Packets.sendToServer(new OpenCameraAttachmentsInCreativePacketC2SP(slot.method_34266()));
                return true;
            }
            this.openCameraAttachments(player, slot.method_34266(), true);
            return true;
        }
        return (Boolean)Config.Server.CAMERA_GUI_RIGHT_CLICK_HOTSWAP.get() != false && this.hotswap((CameraHolder)player, stack, otherStack, access) != class_1269.field_5811;
    }

    public class_1269 handleStandSneakInteraction(CameraStandEntity stand, class_1657 player, class_1268 hand, class_1799 cameraStack) {
        class_1799 itemInHand = player.method_5998(hand);
        int slot = hand == class_1268.field_5810 ? 40 : player.method_31548().field_7545;
        class_5630 access = class_5630.method_32328((class_1263)player.method_31548(), (int)slot);
        return this.hotswap(stand, cameraStack, itemInHand, access);
    }

    protected class_1269 hotswap(CameraHolder holder, class_1799 stack, class_1799 otherStack, class_5630 access) {
        for (Attachment<?> attachment : this.getAttachments()) {
            StoredItemStack storedStack = attachment.get(stack);
            int maxCount = attachment.maxCount().get();
            if (otherStack.method_7960()) {
                if (storedStack.isEmpty()) {
                    return class_1269.field_5814;
                }
                access.method_32332(storedStack.getCopy());
                attachment.set(stack, class_1799.field_8037);
                attachment.playRemoveSoundSided(holder.asHolderEntity());
                return class_1269.field_5812;
            }
            if (!attachment.matches(otherStack)) continue;
            if (storedStack.isEmpty() || class_1799.method_31577((class_1799)storedStack.getForReading(), (class_1799)otherStack)) {
                int availableCount = Math.max(0, maxCount - storedStack.getForReading().method_7947());
                if (availableCount == 0) {
                    holder.asHolderEntity().method_5783(Exposure.SoundEvents.CAMERA_LENS_RING_CLICK.get(), 0.9f, 1.0f);
                    return class_1269.field_5814;
                }
                class_1799 insertedStack = otherStack.method_7971(availableCount);
                insertedStack.method_7939(insertedStack.method_7947() + storedStack.getForReading().method_7947());
                attachment.set(stack, insertedStack);
                access.method_32332(otherStack);
                attachment.playInsertSoundSided(holder.asHolderEntity());
                return class_1269.field_5812;
            }
            if (otherStack.method_7947() > maxCount) {
                holder.asHolderEntity().method_5783(Exposure.SoundEvents.CAMERA_LENS_RING_CLICK.get(), 0.9f, 1.0f);
                return class_1269.field_5814;
            }
            class_1799 returnedStack = storedStack.getCopy();
            attachment.set(stack, otherStack);
            access.method_32332(returnedStack);
            attachment.playInsertSoundSided(holder.asHolderEntity());
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public class_1271<class_1799> openCameraAttachments(@NotNull class_1657 player, class_1799 stack, boolean openedFromGUI) {
        Preconditions.checkArgument((boolean)(stack.method_7909() instanceof CameraItem), (String)"%s is not a CameraItem.", (Object)stack);
        int cameraSlot = this.getMatchingSlotInInventory(player.method_31548(), stack);
        if (cameraSlot < 0) {
            Exposure.LOGGER.error("Cannot open camera attachments: slot index is not found for item '{}'.", (Object)stack);
            return class_1271.method_22431((Object)stack);
        }
        return this.openCameraAttachments(player, cameraSlot, openedFromGUI);
    }

    public class_1271<class_1799> openCameraAttachments(@NotNull class_1657 player, final int slotIndex, final boolean openedFromGUI) {
        Preconditions.checkArgument((slotIndex >= 0 ? 1 : 0) != 0, (String)"slotIndex '%s' is invalid. Should be larger than 0", (int)slotIndex);
        final class_1799 stack = player.method_31548().method_5438(slotIndex);
        Preconditions.checkArgument((boolean)(stack.method_7909() instanceof CameraItem), (String)"Item in slotIndex '%s' is not a CameraItem but '%s'.", (int)slotIndex, (Object)stack);
        if (this.getShutter().isOpen(stack)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"item.exposure.camera.camera_attachments.fail.shutter_open").method_27692(class_124.field_1061), true);
            return class_1271.method_22431((Object)stack);
        }
        this.getOrCreateId(stack);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.getTimer().stop(stack);
            class_3908 menuProvider = new class_3908(){

                @NotNull
                public class_2561 method_5476() {
                    return stack.method_57824(class_9334.field_49631) != null ? stack.method_7964() : class_2561.method_43471((String)"container.exposure.camera");
                }

                @NotNull
                public class_1703 createMenu(int containerId, @NotNull class_1661 playerInventory, @NotNull class_1657 player) {
                    return new CameraInHandAttachmentsMenu(containerId, playerInventory, slotIndex, openedFromGUI);
                }
            };
            PlatformHelper.openMenu(serverPlayer, menuProvider, buffer -> {
                buffer.method_53002(slotIndex);
                buffer.method_52964(openedFromGUI);
            });
        }
        this.setDisassembled(stack, true);
        Sound.play((class_1297)player, Exposure.SoundEvents.CAMERA_GENERIC_CLICK.get(), class_3419.field_15248, 0.9f, 0.9f, 0.2f);
        return class_1271.method_22427((Object)stack);
    }

    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int slotId, boolean isSelected) {
        if (!(entity instanceof CameraHolder)) {
            return;
        }
        CameraHolder holder = (CameraHolder)entity;
        this.tick(holder, stack);
        if (level.field_9236 && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            boolean matchesActive = player.getActiveExposureCameraOptional().map(camera -> camera.idMatches(this.getOrCreateId(stack))).orElse(false);
            if (this.isActive(stack) && !matchesActive) {
                this.setActive(stack, false);
            }
        }
    }

    public boolean tick(CameraHolder holder, class_1799 stack) {
        class_1937 level = holder.asHolderEntity().method_37908();
        if (!(level instanceof class_3218)) {
            return false;
        }
        class_3218 serverLevel = (class_3218)level;
        boolean shutterStateChanged = this.getShutter().tick(holder, serverLevel, stack);
        boolean timerChanged = this.getTimer().tick(holder, serverLevel, stack);
        if (((Boolean)Config.Server.TIMER_ATTRACTS_MOB_ATTENTION.get()).booleanValue() && this.getTimer().isTicking(holder, stack) || this.getTimer().getTicksSinceLastRelease(holder, stack) < 10L) {
            this.grabAttentionOfNearbyMobs(holder, stack);
        }
        boolean projectionChanged = CameraInstances.getOptional(stack).map(instance -> {
            CameraInstance.ProjectionState state = instance.getProjectionState(level);
            switch (state) {
                case SUCCESSFUL: 
                case FAILED: 
                case TIMED_OUT: {
                    this.handleProjectionResult(serverLevel, holder, stack, state, instance.getProjectionError(level));
                    instance.stopWaitingForProjection();
                    return true;
                }
            }
            return false;
        }).orElse(false);
        if (ExposureServer.debugHighlightEntitiesInFrame && this.isActive(stack)) {
            this.testEntitiesInFrame(stack, level, holder);
        }
        return shutterStateChanged || timerChanged || projectionChanged;
    }

    protected void grabAttentionOfNearbyMobs(CameraHolder holder, class_1799 stack) {
        class_1297 holderEntity = holder.asHolderEntity();
        class_243 pos = this.isInSelfieMode(stack) ? holderEntity.method_33571().method_1019(holderEntity.method_5720().method_1021(((Double)Config.Server.SELFIE_CAMERA_DISTANCE.get()).doubleValue())) : holderEntity.method_33571();
        holderEntity.method_37908().method_8335(holderEntity, new class_238(holderEntity.method_24515()).method_1014((double)((Integer)Config.Server.TIMER_ATTENTION_RADIUS.get()).intValue())).stream().filter(entity -> entity instanceof class_1308).map(entity -> (class_1308)entity).filter(mob -> this.canGrabAttentionOf(holder, (class_1308)mob)).forEach(mob -> {
            long startLookingTick = this.getTimer().getStartTick(stack) + (long)(mob.method_5628() % 15);
            if (mob.method_37908().method_8510() > startLookingTick) {
                mob.method_5702(class_2183.class_2184.field_9851, pos);
            }
        });
    }

    protected boolean canGrabAttentionOf(CameraHolder holder, class_1308 mob) {
        return mob.method_5805() && !mob.method_29504() && !mob.method_6113() && !mob.method_5864().method_20210(Exposure.Tags.Entities.IGNORES_CAMERA) && (mob.method_5968() == null || mob.method_5968().equals((Object)holder)) && !mob.method_6059(class_1294.field_5919) && mob.method_6057(holder.asHolderEntity());
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 level, @NotNull class_1657 player, @NotNull class_1268 hand) {
        CameraItem offhandCameraItem;
        class_1792 class_17922;
        class_1799 stack = player.method_5998(hand);
        if (hand == class_1268.field_5808 && (class_17922 = player.method_6079().method_7909()) instanceof CameraItem && (offhandCameraItem = (CameraItem)class_17922).isActive(player.method_6079())) {
            return class_1271.method_22430((Object)stack);
        }
        if (!this.isActive(stack)) {
            return player.method_21823() ? this.openCameraAttachments(player, stack, false) : this.activateInHand(player, stack, hand);
        }
        return this.release((CameraHolder)player, stack);
    }

    public boolean canTakePhoto(CameraHolder holder, class_1799 stack) {
        return !this.isOnCooldown(holder, stack) && !this.getTimer().isTicking(holder, stack) && !this.getShutter().isOpen(stack) && Attachment.FILM.map(stack, FilmRollItem::canAddFrame).orElse(false) != false && CameraInstances.canReleaseShutter(CameraId.ofStack(stack));
    }

    public boolean isOnCooldown(CameraHolder holder, class_1799 stack) {
        class_1297 class_12972 = holder.asHolderEntity();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            return player.method_7357().method_7904((class_1792)this);
        }
        if (holder instanceof CameraStandEntity) {
            CameraStandEntity stand = (CameraStandEntity)holder;
            return stand.isOnCooldown();
        }
        return false;
    }

    public float getCooldownPercent(CameraHolder holder, class_1799 stack) {
        class_1297 class_12972 = holder.asHolderEntity();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            return player.method_7357().method_7904(stack.method_7909()) ? player.method_7357().method_7905(stack.method_7909(), 0.0f) : 0.0f;
        }
        if (holder instanceof CameraStandEntity) {
            CameraStandEntity stand = (CameraStandEntity)holder;
            return stand.isOnCooldown() ? stand.getCooldownPercent() : 0.0f;
        }
        return 0.0f;
    }

    @NotNull
    public class_1271<class_1799> release(CameraHolder holder, class_1799 stack) {
        SelfTimer selfTimer;
        class_1297 entity = holder.asHolderEntity();
        class_1937 level = entity.method_37908();
        Sound.playSided(entity, this.getReleaseButtonSound(), entity.method_5634(), 0.3f, 1.0f, 0.1f);
        if (level.field_9236 || !this.canTakePhoto(holder, stack)) {
            return class_1271.method_22428((Object)stack);
        }
        if (this.getTimer().getEndTick(stack) != level.method_8510() && (selfTimer = CameraSettings.SELF_TIMER.getOrDefault(stack)) != SelfTimer.OFF) {
            this.getTimer().set(holder, stack, selfTimer.getTicks());
            return class_1271.method_22428((Object)stack);
        }
        holder.getServerPlayerExecutingExposure().ifPresentOrElse(player -> this.takePhoto(holder, (class_3222)player, stack), () -> Exposure.LOGGER.error("Cannot start capture: photographer '{}' does not have valid executing player.", (Object)holder));
        return class_1271.method_22428((Object)stack);
    }

    protected void takePhoto(CameraHolder holder, class_3222 executingPlayer, class_1799 stack) {
        class_3218 level = executingPlayer.method_51469();
        class_1297 entity = holder.asHolderEntity();
        ShutterSpeed shutterSpeed = CameraSettings.SHUTTER_SPEED.getOrDefault(stack);
        this.getShutter().open(holder, level, stack, shutterSpeed);
        CameraId cameraId = this.getOrCreateId(stack);
        String exposureId = ExposureIdentifier.createId((class_1297)executingPlayer, new String[0]);
        int lightLevel = LevelUtil.getLightLevelAt((class_1937)level, entity.method_24515());
        boolean flash = this.getFlash().isAvailable(stack) && this.getFlash().shouldFire(stack, lightLevel) && this.getFlash().fire(holder, level, stack);
        CaptureParameters captureParameters = new CaptureParameters.Builder(exposureId).setCameraID(cameraId).setCameraHolder(holder).setFov(this.getFov((class_1937)level, stack)).setCropFactor(this.getCropFactor()).setFilter(this.getFilterShaderLocation(level.method_30349(), stack).orElse(null)).setProjection(this.getProjection(stack)).setChromaticChannel(this.getChromaticChannel(stack)).setFilmProperties(this.getFilmProperties(stack)).extraData(CaptureParameters.SHUTTER_SPEED, CameraSettings.SHUTTER_SPEED.getOrDefault(stack)).extraData(CaptureParameters.FLASH, flash).extraData(CaptureParameters.LIGHT_LEVEL, lightLevel).build();
        if (shutterSpeed.shouldCauseTickingSound() || captureParameters.projection().isPresent()) {
            int duration = Math.max(shutterSpeed.getDurationTicks(), captureParameters.projection().map(l -> (Integer)Config.Server.PROJECT_TIMEOUT_TICKS.get()).orElse(0));
            Sound.playShutterTicking(entity, cameraId, duration);
        }
        CameraInstances.createOrUpdate(cameraId, instance -> {
            int cooldown = this.calculateCooldownAfterShot(stack, captureParameters);
            instance.setDeferredCooldown(cooldown);
            captureParameters.projection().ifPresent(fileLoading -> instance.waitForProjection(level.method_8510() + (long)((Integer)Config.Server.PROJECT_TIMEOUT_TICKS.get()).intValue()));
        });
        this.addNewFrame(level, holder, stack, captureParameters);
        ExposureServer.exposureRepository().expect(executingPlayer, exposureId);
        Packets.sendToClient(new CaptureStartS2CP(this.getCaptureType(stack), captureParameters), executingPlayer);
    }

    protected void onShutterOpen(CameraHolder holder, class_3218 serverLevel, class_1799 stack) {
        holder.getExposureCameraOperator().ifPresent(operator -> {
            if (operator instanceof class_3222) {
                class_3222 player = (class_3222)operator;
                Packets.sendToClient(ShutterOpenedS2CP.INSTANCE, player);
            }
        });
    }

    protected void onShutterClosed(CameraHolder holder, class_3218 serverLevel, class_1799 stack) {
        if (holder instanceof class_1657) {
            class_1657 player = (class_1657)holder;
            int cooldown = CameraInstances.getOptional(stack).map(CameraInstance::getDeferredCooldown).orElse(2);
            player.method_7357().method_7906((class_1792)this, cooldown);
        } else if (holder instanceof CameraStandEntity) {
            CameraStandEntity stand = (CameraStandEntity)holder;
            int cooldown = CameraInstances.getOptional(stack).map(CameraInstance::getDeferredCooldown).orElse(2);
            stand.startCooldown(cooldown);
        }
        Attachment.FILM.ifPresent(stack, (filmItem, filmStack) -> {
            class_3414 sound = filmItem.isFull(filmStack) ? Exposure.SoundEvents.FILM_ADVANCE_LAST.get() : Exposure.SoundEvents.FILM_ADVANCE.get();
            float fullness = filmItem.getFullness(filmStack);
            String id = holder.asHolderEntity().method_5628() + this.getOrCreateId(stack).uuid().toString();
            Sound.playUnique(id, holder.asHolderEntity(), sound, class_3419.field_15248, 1.0f, 0.85f + 0.2f * fullness);
        });
    }

    public void addNewFrame(class_3218 level, CameraHolder holder, class_1799 stack, CaptureParameters captureParameters) {
        boolean projecting = captureParameters.projection().isPresent();
        PointOfView pov = this.getPointOfView(holder, stack);
        double fov = this.getViewfinderFov((class_1937)level, stack);
        List<class_2338> positionsInFrame = !projecting ? this.getPositionsInFrame(holder, pov, fov) : Collections.emptyList();
        List<class_1309> entitiesInFrame = !projecting ? EntitiesInFrame.get(holder, pov, fov) : Collections.emptyList();
        Frame frame = this.createFrame(holder, level, stack, captureParameters, positionsInFrame, entitiesInFrame);
        this.addFrameToFilm(stack, frame);
        this.onFrameAdded(holder, level, stack, frame, positionsInFrame, entitiesInFrame);
    }

    public Frame createFrame(CameraHolder holder, class_3218 level, class_1799 stack, CaptureParameters captureParameters, List<class_2338> positionsInFrame, List<class_1309> entitiesInFrame) {
        return Frame.create().setIdentifier(ExposureIdentifier.id(captureParameters.exposureId())).setType(captureParameters.filmProperties().type()).setPhotographer(new Photographer(holder)).setEntitiesInFrame(entitiesInFrame.stream().limit(10L).map(entity -> EntityInFrame.of(holder.asHolderEntity(), (class_1297)entity, data -> PlatformHelper.postModifyEntityInFrameExtraDataEvent(holder, stack, entity, data))).toList()).addExtraData(Frame.SHUTTER_SPEED, CameraSettings.SHUTTER_SPEED.getOrDefault(stack)).addExtraData(Frame.TIMESTAMP, UnixTimestamp.Seconds.now()).updateExtraData(data -> this.addFrameExtraData(holder, level, stack, captureParameters, positionsInFrame, entitiesInFrame, (ExtraData)((Object)data))).toImmutable();
    }

    protected void addFrameExtraData(CameraHolder holder, class_3218 level, class_1799 camera, CaptureParameters params, List<class_2338> positionsInFrame, List<class_1309> entitiesInFrame, ExtraData data) {
        class_1297 cameraHolder = holder.asHolderEntity();
        boolean projecting = params.projection().isPresent();
        if (projecting) {
            data.put(Frame.PROJECTED, true);
            return;
        }
        if (params.getFlash()) {
            data.put(Frame.FLASH, true);
        }
        if (this.isInSelfieMode(camera)) {
            data.put(Frame.SELFIE, true);
        }
        if (holder instanceof CameraStandEntity) {
            data.put(Frame.ON_STAND, true);
        }
        double zoom = CameraSettings.ZOOM.getOrDefault(camera).floatValue();
        FocalRange focalRange = this.getFocalRange(level.method_30349(), camera);
        int focalLength = (int)focalRange.focalLengthFromZoom(zoom);
        data.put(Frame.FOCAL_LENGTH, focalLength);
        params.extraData().get(CaptureParameters.LIGHT_LEVEL).ifPresent(lightLevel -> data.put(Frame.LIGHT_LEVEL, lightLevel));
        if (params.filmProperties().type() == ExposureType.BLACK_AND_WHITE) {
            params.singleChannel().ifPresent(channel -> data.put(Frame.COLOR_CHANNEL, channel));
        }
        data.put(Frame.POSITION, cameraHolder.method_19538());
        data.put(Frame.PITCH, Float.valueOf(cameraHolder.method_36455()));
        data.put(Frame.YAW, Float.valueOf(cameraHolder.method_36454()));
        data.put(Frame.DAY_TIME, (int)level.method_8532());
        data.put(Frame.DIMENSION, level.method_27983().method_29177());
        class_2338 blockPos = cameraHolder.method_24515();
        int surfaceHeight = level.method_8624(class_2902.class_2903.field_13202, cameraHolder.method_31477(), cameraHolder.method_31479());
        level.method_8533();
        int skyLight = level.method_8314(class_1944.field_9284, blockPos);
        if (cameraHolder.method_5869()) {
            data.put(Frame.UNDERWATER, true);
        }
        if (cameraHolder.method_31478() < Math.min(level.method_8615(), surfaceHeight) && skyLight == 0) {
            data.put(Frame.IN_CAVE, true);
        } else if (!cameraHolder.method_5869()) {
            class_1959.class_1963 precipitation = ((class_1959)level.method_23753(blockPos).comp_349()).method_48162(blockPos);
            if (level.method_8546() && precipitation != class_1959.class_1963.field_9384) {
                data.put(Frame.WEATHER, precipitation == class_1959.class_1963.field_9383 ? "Snowstorm" : "Thunder");
            } else if (level.method_8419() && precipitation != class_1959.class_1963.field_9384) {
                data.put(Frame.WEATHER, precipitation == class_1959.class_1963.field_9383 ? "Snow" : "Rain");
            } else {
                data.put(Frame.WEATHER, "Clear");
            }
        }
        positionsInFrame.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).flatMap(pos -> level.method_23753(pos).method_40230().map(class_5321::method_29177)).ifPresent(biome -> data.put(Frame.BIOME, biome));
        List structures = positionsInFrame.stream().map(pos -> LevelUtil.getStructuresAt(level, pos)).flatMap(Collection::stream).collect(Collectors.toSet()).stream().toList();
        if (!structures.isEmpty()) {
            data.put(Frame.STRUCTURES, structures);
        }
        PlatformHelper.postModifyFrameExtraDataEvent(holder, camera, params, positionsInFrame, entitiesInFrame, data);
    }

    public List<class_2338> getPositionsInFrame(CameraHolder cameraHolder, PointOfView pov, double fov) {
        float offsetDegrees = (float)(fov * (double)this.getCropFactor() / 4.3);
        return Vec3Util.getProbeVectors(pov.dir(), offsetDegrees).stream().map(direction -> {
            class_243 endPos = pov.pos().method_1019(direction.method_1021(100.0));
            return cameraHolder.asHolderEntity().method_37908().method_17742(new class_3959(pov.pos(), endPos, class_3959.class_3960.field_17559, class_3959.class_242.field_1347, cameraHolder.asHolderEntity()));
        }).filter(hit -> hit.method_17783() != class_239.class_240.field_1333).map(class_3965::method_17777).toList();
    }

    public void addFrameToFilm(class_1799 stack, Frame frame) {
        Attachment.FILM.ifPresentOrElse(stack, (filmItem, filmStack) -> {
            class_1799 updatedFilmStack = filmStack.method_7972();
            filmItem.addFrame(updatedFilmStack, frame);
            Attachment.FILM.set(stack, updatedFilmStack);
        }, () -> Exposure.LOGGER.error("Cannot add frame: no film attachment is present."));
    }

    public void onFrameAdded(CameraHolder holder, class_3218 level, class_1799 stack, Frame frame, List<class_2338> positionsInFrame, List<class_1309> entitiesInFrame) {
        class_1297 executor = holder.getPlayerExecutingExposure().map(pl -> pl).orElse(holder.asHolderEntity());
        ExposureServer.frameHistory().add(executor, frame);
        entitiesInFrame.forEach(entity -> this.entityCaptured(holder, stack, (class_1309)entity));
        holder.getPlayerAwardedForExposure().filter(player -> player instanceof class_3222).ifPresent(player -> {
            class_3222 serverPlayer = (class_3222)player;
            serverPlayer.method_7281(Exposure.Stats.FILM_FRAMES_EXPOSED);
            Exposure.CriteriaTriggers.FRAME_EXPOSED.get().trigger(serverPlayer, holder, stack, frame, positionsInFrame, entitiesInFrame);
        });
        PlatformHelper.postFrameAddedEvent(holder, stack, frame, positionsInFrame, entitiesInFrame);
    }

    protected void entityCaptured(CameraHolder cameraHolder, class_1799 stack, class_1309 entity) {
        class_1297 class_12972 = cameraHolder.asHolderEntity();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            if (entity instanceof class_1560) {
                boolean lookingAtAngryEnderMan;
                class_1560 enderMan = (class_1560)entity;
                boolean bl = lookingAtAngryEnderMan = player.equals((Object)enderMan.method_5968()) && enderMan.method_7026((class_1657)player);
                if (lookingAtAngryEnderMan) {
                    Exposure.CriteriaTriggers.PHOTOGRAPH_ENDERMAN_EYES.get().method_9141(player);
                }
            }
        }
    }

    public void handleProjectionResult(class_3218 level, CameraHolder holder, class_1799 stack, CameraInstance.ProjectionState projectionState, Optional<TranslatableError> error) {
        StoredItemStack filter = Attachment.FILTER.get(stack);
        if (filter.isEmpty()) {
            return;
        }
        class_1792 class_17922 = filter.getItem();
        if (!(class_17922 instanceof InterplanarProjectorItem)) {
            return;
        }
        InterplanarProjectorItem interplanarProjector = (InterplanarProjectorItem)class_17922;
        if (!interplanarProjector.isConsumable(filter.getForReading())) {
            return;
        }
        class_1297 entity = holder.asHolderEntity();
        if (projectionState == CameraInstance.ProjectionState.FAILED || projectionState == CameraInstance.ProjectionState.TIMED_OUT) {
            class_1799 filterStack = filter.getCopy().method_60503((class_1935)Exposure.Items.BROKEN_INTERPLANAR_PROJECTOR.get());
            error.ifPresent(err -> filterStack.method_57379(Exposure.DataComponents.INTERPLANAR_PROJECTOR_ERROR_CODE, (Object)err.code()));
            Attachment.FILTER.set(stack, filterStack);
            Sound.play(entity, Exposure.SoundEvents.BSOD.get());
            if (this.getShutter().isOpen(stack)) {
                this.getShutter().close(holder, level, stack);
            }
            return;
        }
        class_1799 filterStack = filter.getCopy();
        filterStack.method_7934(1);
        Attachment.FILTER.set(stack, filterStack);
        if (projectionState == CameraInstance.ProjectionState.SUCCESSFUL) {
            holder.getServerPlayerAwardedForExposure().ifPresent(player -> Exposure.CriteriaTriggers.SUCCESSFULLY_PROJECT_IMAGE.get().method_9141(player));
            Sound.play(entity, Exposure.SoundEvents.INTERPLANAR_PROJECT.get(), entity.method_5634(), 0.8f, 1.1f);
            for (int i = 0; i < 16; ++i) {
                level.method_14199((class_2394)class_2398.field_11214, entity.method_23317(), entity.method_23318() + 1.2, entity.method_23321(), 2, entity.method_59922().method_43059() * 0.3, entity.method_59922().method_43059() * 0.3, entity.method_59922().method_43059() * 0.3, 0.01);
            }
        }
    }

    protected int getMatchingSlotInInventory(class_1661 inventory, class_1799 stack) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            if (!inventory.method_5438(i).equals(stack)) continue;
            return i;
        }
        return -1;
    }

    protected void testEntitiesInFrame(class_1799 stack, class_1937 level, CameraHolder holder) {
        PointOfView pov = this.getPointOfView(holder, stack);
        double fov = this.getViewfinderFov(level, stack);
        List<class_1309> entities = EntitiesInFrame.get(holder.asHolderEntity(), pov, fov);
        for (class_1309 livingEntity : entities) {
            livingEntity.method_6092(new class_1293(class_1294.field_5912, 2, 1, true, false, false));
        }
    }

    protected void testPositionsInFrame(class_1799 stack, class_1937 level, class_1657 player) {
        if (level.field_9236 && level.method_8510() % 2L == 0L) {
            List<class_2338> positionsInFrame = this.getPositionsInFrame((CameraHolder)player, this.getPointOfView((CameraHolder)player, stack), this.getViewfinderFov(level, stack));
            for (class_2338 pos : positionsInFrame) {
                level.method_17452((class_2394)class_2398.field_11236, true, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 0.0, 0.0, 0.0);
            }
        }
    }

    public static int getGlassTintColor(class_1799 stack, int tintIndex) {
        if (tintIndex == 1) {
            class_1747 item;
            CameraItem cameraItem;
            class_1792 class_17922 = stack.method_7909();
            boolean shutterOpen = class_17922 instanceof CameraItem && (cameraItem = (CameraItem)class_17922).getShutter().isOpen(stack);
            StoredItemStack filter = Attachment.FILTER.get(stack);
            if (filter.isEmpty()) {
                return shutterOpen ? -13421773 : -1;
            }
            class_1792 class_17923 = filter.getForReading().method_7909();
            if (class_17923 instanceof class_1747 && (class_17923 = (item = (class_1747)class_17923).method_7711()) instanceof class_2504) {
                class_2504 pane = (class_2504)class_17923;
                return shutterOpen ? Color.argb(pane.method_10622().method_7787()).multiply(0.2f).withAlpha(255).getARGB() : pane.method_10622().method_7787();
            }
            if (filter.getForReading().method_31574((class_1792)Exposure.Items.INTERPLANAR_PROJECTOR.get())) {
                return shutterOpen ? -16442865 : -11488642;
            }
            if (filter.getForReading().method_31574((class_1792)Exposure.Items.BROKEN_INTERPLANAR_PROJECTOR.get())) {
                return shutterOpen ? -16761482 : -11227649;
            }
            return -1;
        }
        return -1;
    }
}

