/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item.camera;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.exposure.world.camera.component.ShutterSpeed;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record ShutterState(boolean isOpen, long openedAtTick, ShutterSpeed shutterSpeed) {
    public static final ShutterState CLOSED = new ShutterState(false, 0L, ShutterSpeed.DEFAULT);
    public static final Codec<ShutterState> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("is_open", (Object)false).forGetter(ShutterState::isOpen), (App)Codec.LONG.optionalFieldOf("opened_at", (Object)0L).forGetter(ShutterState::openedAtTick), (App)ShutterSpeed.CODEC.optionalFieldOf("shutter_speed", (Object)ShutterSpeed.DEFAULT).forGetter(ShutterState::shutterSpeed)).apply((Applicative)instance, ShutterState::new));
    public static final class_9139<ByteBuf, ShutterState> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.field_48547, ShutterState::isOpen, (class_9139)class_9135.field_48551, ShutterState::openedAtTick, ShutterSpeed.STREAM_CODEC, ShutterState::shutterSpeed, ShutterState::new);

    public static ShutterState open(long openedAt, ShutterSpeed shutterSpeed) {
        return new ShutterState(true, openedAt, shutterSpeed);
    }

    public static ShutterState closed() {
        return CLOSED;
    }

    public long getCloseTick() {
        return this.isOpen ? this.openedAtTick + (long)this.shutterSpeed.getDurationTicks() : -1L;
    }
}

