/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.sound;

import io.github.mortuusars.exposure.client.sound.UniqueSoundManager;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.clientbound.UniqueSoundPlayS2CP;
import io.github.mortuusars.exposure.network.packet.clientbound.UniqueSoundPlayShutterTickingS2CP;
import io.github.mortuusars.exposure.world.camera.CameraId;
import io.github.mortuusars.exposure.world.sound.SoundEffect;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

public class Sound {
    public static void play(class_1937 level, double x, double y, double z, class_3414 sound, class_3419 source) {
        Sound.play(level, x, y, z, sound, source, 1.0f, 1.0f, 0.0f);
    }

    public static void play(class_1937 level, double x, double y, double z, class_3414 sound, class_3419 source, float volume, float pitch) {
        Sound.play(level, x, y, z, sound, source, volume, pitch, 0.0f);
    }

    public static void play(class_1937 level, double x, double y, double z, class_3414 sound, class_3419 source, float volume, float pitch, float pitchVariability) {
        pitch = Sound.vary(pitch, pitchVariability);
        level.method_43128(null, x, y, z, sound, source, volume, pitch);
    }

    public static void play(class_1297 entity, class_3414 sound) {
        Sound.play(entity, sound, entity.method_5634(), 1.0f, 1.0f, 0.0f);
    }

    public static void play(class_1297 entity, class_3414 sound, class_3419 source) {
        Sound.play(entity, sound, source, 1.0f, 1.0f, 0.0f);
    }

    public static void play(class_1297 entity, class_3414 sound, class_3419 source, float volume, float pitch) {
        Sound.play(entity, sound, source, volume, pitch, 0.0f);
    }

    public static void play(class_1297 entity, class_3414 sound, class_3419 source, float volume, float pitch, float pitchVariability) {
        pitch = Sound.vary(pitch, pitchVariability);
        entity.method_37908().method_43129(null, entity, sound, source, volume, pitch);
    }

    public static void playSided(class_1657 player, double x, double y, double z, class_3414 sound, class_3419 source) {
        Sound.playSided(player, x, y, z, sound, source, 1.0f, 1.0f, 0.0f);
    }

    public static void playSided(class_1657 player, double x, double y, double z, class_3414 sound, class_3419 source, float volume, float pitch) {
        Sound.playSided(player, x, y, z, sound, source, volume, pitch, 0.0f);
    }

    public static void playSided(class_1657 player, double x, double y, double z, class_3414 sound, class_3419 source, float volume, float pitch, float pitchVariability) {
        pitch = Sound.vary(pitch, pitchVariability);
        player.method_37908().method_43128(player, x, y, z, sound, source, volume, pitch);
    }

    public static void playSided(class_1297 entity, SoundEffect sound) {
        Sound.playSided(entity, sound.get(), entity.method_5634(), sound.volume(), sound.pitch(), sound.pitchVariability());
    }

    public static void playSided(class_1297 entity, class_3414 sound) {
        Sound.playSided(entity, sound, entity.method_5634());
    }

    public static void playSided(class_1297 entity, class_3414 sound, class_3419 source) {
        Sound.playSided(entity, sound, source, 1.0f, 1.0f);
    }

    public static void playSided(class_1297 entity, class_3414 sound, class_3419 source, float volume, float pitch) {
        Sound.playSided(entity, sound, source, volume, pitch, 0.0f);
    }

    public static void playSided(class_1297 entity, class_3414 sound, class_3419 source, float volume, float pitch, float pitchVariability) {
        pitch = Sound.vary(pitch, pitchVariability);
        class_1657 player = entity instanceof class_1657 ? (class_1657)entity : null;
        entity.method_37908().method_43129(player, entity, sound, source, volume, pitch);
    }

    public static void playUnique(String id, class_1297 entity, SoundEffect sound, class_3419 source) {
        Sound.playUnique(id, entity, sound.get(), source, sound.volume(), sound.pitch(), sound.pitchVariability());
    }

    public static void playUnique(String id, class_1297 entity, class_3414 sound, class_3419 source) {
        Sound.playUnique(id, entity, sound, source, 1.0f, 1.0f, 0.0f);
    }

    public static void playUnique(String id, class_1297 entity, class_3414 sound, class_3419 source, float volume, float pitch) {
        Sound.playUnique(id, entity, sound, source, volume, pitch, 0.0f);
    }

    public static void playUnique(String id, class_1297 entity, class_3414 sound, class_3419 source, float volume, float pitch, float pitchVariability) {
        pitch = Sound.vary(pitch, pitchVariability);
        class_1937 class_19372 = entity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            UniqueSoundPlayS2CP packet = new UniqueSoundPlayS2CP(id, entity.method_5628(), sound, source, volume, pitch);
            Packets.sendToPlayersNear(packet, serverLevel, null, entity, sound.method_43044(1.0f) * 4.0f);
        }
    }

    public static void playUniqueSided(String id, class_1297 entity, SoundEffect sound, class_3419 source) {
        class_3222 player;
        class_3222 excludedPlayer = entity instanceof class_3222 ? (player = (class_3222)entity) : null;
        float pitch = Sound.vary(sound.pitch(), sound.pitchVariability());
        class_1937 class_19372 = entity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            UniqueSoundPlayS2CP packet = new UniqueSoundPlayS2CP(id, entity.method_5628(), sound.get(), source, sound.volume(), sound.pitch());
            Packets.sendToPlayersNear(packet, serverLevel, excludedPlayer, entity, sound.get().method_43044(1.0f) * 4.0f);
        } else if (entity instanceof class_1657 && entity.method_37908().method_8608()) {
            UniqueSoundManager.play(id, entity, sound.get(), source, sound.volume(), pitch);
        }
    }

    public static void playUniqueSided(String id, class_1657 player, class_1297 entity, SoundEffect sound, class_3419 source) {
        Sound.playUniqueSided(id, player, entity, sound.get(), source, sound.volume(), sound.pitch(), sound.pitchVariability());
    }

    public static void playUniqueSided(String id, class_1657 player, class_1297 entity, class_3414 sound, class_3419 source, float volume, float pitch, float pitchVariability) {
        pitch = Sound.vary(pitch, pitchVariability);
        class_1937 class_19372 = player.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            UniqueSoundPlayS2CP packet = new UniqueSoundPlayS2CP(id, entity.method_5628(), sound, source, volume, pitch);
            Packets.sendToPlayersNear(packet, serverLevel, (class_3222)player, entity, sound.method_43044(1.0f) * 4.0f);
        } else if (player.method_37908().method_8608()) {
            UniqueSoundManager.play(id, entity, sound, source, volume, pitch);
        }
    }

    private static float vary(float value, float variability) {
        return value - variability / 2.0f + ThreadLocalRandom.current().nextFloat() * variability;
    }

    public static void playShutterTicking(class_1297 entity, CameraId cameraId, int duration) {
        if (!entity.method_37908().method_8608()) {
            Packets.sendToAllClients(new UniqueSoundPlayShutterTickingS2CP(entity.method_5628(), cameraId, 1.0f, 1.0f, duration));
        }
    }
}

