/*
 * Decompiled with CFR 0.152.
 */
package io.github.amerebagatelle.fabricskyboxes.skyboxes.textured;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.amerebagatelle.fabricskyboxes.api.skyboxes.Skybox;
import io.github.amerebagatelle.fabricskyboxes.mixin.skybox.WorldRendererAccess;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.AbstractSkybox;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.SkyboxType;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.textured.SquareTexturedSkybox;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.textured.TexturedSkybox;
import io.github.amerebagatelle.fabricskyboxes.util.object.Blend;
import io.github.amerebagatelle.fabricskyboxes.util.object.Conditions;
import io.github.amerebagatelle.fabricskyboxes.util.object.Decorations;
import io.github.amerebagatelle.fabricskyboxes.util.object.Properties;
import io.github.amerebagatelle.fabricskyboxes.util.object.Textures;
import java.util.List;
import net.minecraft.class_4184;
import net.minecraft.class_4587;

public class AnimatedSquareTexturedSkybox
extends SquareTexturedSkybox {
    public static final Codec<AnimatedSquareTexturedSkybox> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Properties.CODEC.fieldOf("properties").forGetter(AbstractSkybox::getProperties), (App)Conditions.CODEC.optionalFieldOf("conditions", (Object)Conditions.DEFAULT).forGetter(AbstractSkybox::getConditions), (App)Decorations.CODEC.optionalFieldOf("decorations", (Object)Decorations.DEFAULT).forGetter(AbstractSkybox::getDecorations), (App)Blend.CODEC.optionalFieldOf("blend", (Object)Blend.DEFAULT).forGetter(TexturedSkybox::getBlend), (App)Textures.CODEC.listOf().fieldOf("animationTextures").forGetter(AnimatedSquareTexturedSkybox::getAnimationTextures), (App)Codec.FLOAT.fieldOf("fps").forGetter(AnimatedSquareTexturedSkybox::getFps)).apply((Applicative)instance, AnimatedSquareTexturedSkybox::new));
    private final List<Textures> animationTextures;
    private final float fps;
    private final long frameTimeMillis;
    private int count = 0;
    private long lastTime = 0L;

    public AnimatedSquareTexturedSkybox(Properties properties, Conditions conditions, Decorations decorations, Blend blend, List<Textures> animationTextures, float fps) {
        super(properties, conditions, decorations, blend, null);
        this.animationTextures = animationTextures;
        this.fps = fps;
        this.frameTimeMillis = fps > 0.0f && fps <= 360.0f ? (long)(1000.0f / fps) : 16L;
    }

    @Override
    public SkyboxType<? extends Skybox> getType() {
        return SkyboxType.ANIMATED_SQUARE_TEXTURED_SKYBOX;
    }

    @Override
    public void renderSkybox(WorldRendererAccess worldRendererAccess, class_4587 matrices, float tickDelta, class_4184 camera, boolean thickFog, Runnable runnable) {
        if (this.lastTime == 0L) {
            this.lastTime = System.currentTimeMillis();
        }
        this.textures = this.getAnimationTextures().get(this.count);
        super.renderSkybox(worldRendererAccess, matrices, tickDelta, camera, thickFog, runnable);
        if (System.currentTimeMillis() >= this.lastTime + this.frameTimeMillis) {
            if (this.count < this.getAnimationTextures().size()) {
                this.count = this.count + 1 == this.getAnimationTextures().size() ? 0 : ++this.count;
            }
            this.lastTime = System.currentTimeMillis();
        }
    }

    public List<Textures> getAnimationTextures() {
        return this.animationTextures;
    }

    public float getFps() {
        return this.fps;
    }
}

