/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.dataexchange;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_634;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public abstract class BaseDataHandler<T extends class_8710> {
    private final boolean originatesOnServer;
    @NotNull
    private final class_2960 identifier;
    private class_3222 lastMessageSender;

    protected BaseDataHandler(@NotNull class_2960 identifier, boolean originatesOnServer) {
        this.originatesOnServer = originatesOnServer;
        this.identifier = identifier;
    }

    public final boolean getOriginatesOnServer() {
        return this.originatesOnServer;
    }

    @NotNull
    public final class_2960 getIdentifier() {
        return this.identifier;
    }

    @Environment(value=EnvType.CLIENT)
    abstract void receiveFromServer(class_310 var1, class_634 var2, T var3, PacketSender var4);

    void receiveFromClient(MinecraftServer server, class_3222 player, class_3244 handler, T payload, PacketSender responseSender) {
        this.lastMessageSender = player;
    }

    protected final <M extends class_8710> boolean reply(BaseDataHandler<M> message, MinecraftServer server) {
        if (this.lastMessageSender == null) {
            return false;
        }
        message.sendToClient(server, this.lastMessageSender);
        return true;
    }

    abstract void sendToClient(MinecraftServer var1);

    abstract void sendToClient(MinecraftServer var1, class_3222 var2);

    @Environment(value=EnvType.CLIENT)
    abstract void sendToServer(class_310 var1);

    protected boolean isBlocking() {
        return false;
    }

    public String toString() {
        return "BasDataHandler{originatesOnServer=" + this.originatesOnServer + ", identifier=" + String.valueOf(this.identifier) + "}";
    }

    public static void writeString(class_2540 buf, String s) {
        buf.method_10813(s.getBytes(StandardCharsets.UTF_8));
    }

    public static String readString(class_2540 buf) {
        byte[] data = buf.method_10795();
        return new String(data, StandardCharsets.UTF_8);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseDataHandler)) {
            return false;
        }
        BaseDataHandler that = (BaseDataHandler)o;
        return this.originatesOnServer == that.originatesOnServer && this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.originatesOnServer, this.identifier);
    }
}

