/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.block;

import com.google.common.collect.UnmodifiableIterator;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.block.BlockOffsets;
import net.mehvahdjukaar.polytone.block.BlockSetTypeProvider;
import net.mehvahdjukaar.polytone.color.MapColorHelper;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.colormap.IndexCompoundColorGetter;
import net.mehvahdjukaar.polytone.particle.BlockParticleEmitter;
import net.mehvahdjukaar.polytone.sound.BlockSoundEmitter;
import net.mehvahdjukaar.polytone.sound.PolytoneSoundType;
import net.mehvahdjukaar.polytone.utils.Targets;
import net.mehvahdjukaar.polytone.utils.Utils;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2323;
import net.minecraft.class_2440;
import net.minecraft.class_2498;
import net.minecraft.class_2533;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_322;
import net.minecraft.class_324;
import net.minecraft.class_3542;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record BlockPropertyModifier(Optional<? extends class_322> tintGetter, Optional<class_2498> soundType, Optional<Function<class_2680, class_3620>> mapColor, Optional<Boolean> canOcclude, Optional<Boolean> spawnParticlesOnBreak, Optional<Boolean> breakingParticlesTinted, Optional<RenderType> renderType, Optional<ToIntFunction<class_2680>> clientLight, List<BlockParticleEmitter> particleEmitters, List<BlockSoundEmitter> soundEmitters, Optional<class_4970.class_8176> offsetType, Optional<BlockSetTypeProvider> blockSetType, Boolean disableParticles, @NotNull Targets targets, boolean tintHack) {
    public static final Decoder<BlockPropertyModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IndexCompoundColorGetter.SINGLE_OR_MULTIPLE.optionalFieldOf("colormap").forGetter(b -> b.tintGetter.flatMap(t -> {
        IndexCompoundColorGetter c;
        return Optional.ofNullable(t instanceof IndexCompoundColorGetter ? (c = (IndexCompoundColorGetter)t) : null);
    })), (App)PolytoneSoundType.CODEC.optionalFieldOf("sound_type").forGetter(BlockPropertyModifier::soundType), (App)MapColorHelper.CODEC.xmap(c -> a -> c, f -> class_3620.field_16008).optionalFieldOf("map_color").forGetter(BlockPropertyModifier::mapColor), (App)Codec.BOOL.optionalFieldOf("can_occlude").forGetter(BlockPropertyModifier::canOcclude), (App)Codec.BOOL.optionalFieldOf("spawn_particles_on_break").forGetter(BlockPropertyModifier::spawnParticlesOnBreak), (App)Codec.BOOL.optionalFieldOf("tinted_breaking_particles").forGetter(BlockPropertyModifier::breakingParticlesTinted), (App)class_3542.method_28140(RenderType::values).optionalFieldOf("render_type").forGetter(BlockPropertyModifier::renderType), (App)Codec.intRange((int)0, (int)15).xmap(integer -> s -> integer, toIntFunction -> 0).optionalFieldOf("client_light").forGetter(BlockPropertyModifier::clientLight), (App)BlockParticleEmitter.CODEC.listOf().optionalFieldOf("particle_emitters", List.of()).forGetter(BlockPropertyModifier::particleEmitters), (App)BlockSoundEmitter.CODEC.listOf().optionalFieldOf("sound_emitters", List.of()).forGetter(BlockPropertyModifier::soundEmitters), (App)BlockOffsets.CODEC.optionalFieldOf("offset_type").forGetter(BlockPropertyModifier::offsetType), (App)BlockSetTypeProvider.CODEC.optionalFieldOf("block_set_type").forGetter(BlockPropertyModifier::blockSetType), (App)Codec.BOOL.optionalFieldOf("disable_particles", (Object)false).forGetter(BlockPropertyModifier::disableParticles), (App)Targets.CODEC.optionalFieldOf("targets", (Object)Targets.EMPTY).forGetter(BlockPropertyModifier::targets), (App)Codec.BOOL.optionalFieldOf("force_tint_hack", (Object)false).forGetter(BlockPropertyModifier::tintHack)).apply((Applicative)instance, BlockPropertyModifier::new));
    public static final Decoder<BlockPropertyModifier> PARTIAL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IndexCompoundColorGetter.SINGLE_OR_MULTIPLE.optionalFieldOf("colormap").forGetter(b -> b.tintGetter.flatMap(t -> {
        IndexCompoundColorGetter c;
        return Optional.ofNullable(t instanceof IndexCompoundColorGetter ? (c = (IndexCompoundColorGetter)t) : null);
    }))).apply((Applicative)instance, c -> BlockPropertyModifier.ofBlockColor(c.orElse(null))));

    public BlockPropertyModifier merge(BlockPropertyModifier newMod) {
        return new BlockPropertyModifier(newMod.tintGetter.isPresent() ? newMod.tintGetter() : this.tintGetter(), newMod.soundType().isPresent() ? newMod.soundType() : this.soundType(), newMod.mapColor.isPresent() ? newMod.mapColor() : this.mapColor(), newMod.canOcclude().isPresent() ? newMod.canOcclude() : this.canOcclude(), newMod.spawnParticlesOnBreak().isPresent() ? newMod.spawnParticlesOnBreak() : this.spawnParticlesOnBreak(), newMod.breakingParticlesTinted().isPresent() ? newMod.breakingParticlesTinted() : this.breakingParticlesTinted(), newMod.renderType().isPresent() ? newMod.renderType() : this.renderType(), newMod.clientLight.isPresent() ? newMod.clientLight : this.clientLight, Utils.mergeList(newMod.particleEmitters, this.particleEmitters), Utils.mergeList(newMod.soundEmitters, this.soundEmitters), newMod.offsetType().isPresent() ? newMod.offsetType() : this.offsetType(), newMod.blockSetType().isPresent() ? newMod.blockSetType() : this.blockSetType(), newMod.disableParticles != false || this.disableParticles != false, newMod.targets.merge(this.targets), newMod.tintHack || this.tintHack);
    }

    public static BlockPropertyModifier ofBlockColor(class_322 colormap) {
        return new BlockPropertyModifier(Optional.ofNullable(colormap), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), List.of(), List.of(), Optional.empty(), Optional.empty(), false, Targets.EMPTY, false);
    }

    public static BlockPropertyModifier coloringBlocks(class_322 colormap, class_2248 ... blocks) {
        return BlockPropertyModifier.coloringBlocks(colormap, Set.of((class_2960[])Arrays.stream(blocks).map(arg_0 -> ((class_7922)class_7923.field_41175).method_10221(arg_0)).toArray(class_2960[]::new)));
    }

    public static BlockPropertyModifier coloringBlocks(class_322 colormap, List<class_2248> blocks) {
        return BlockPropertyModifier.coloringBlocks(colormap, blocks.stream().map(arg_0 -> ((class_7922)class_7923.field_41175).method_10221(arg_0)).collect(Collectors.toSet()));
    }

    public static BlockPropertyModifier coloringBlocks(class_322 colormap, Set<class_2960> blocks) {
        Targets t = Targets.ofIds(blocks);
        return new BlockPropertyModifier(Optional.of(colormap), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), List.of(), List.of(), Optional.empty(), Optional.empty(), false, t, false);
    }

    public BlockPropertyModifier apply(class_2248 block) {
        class_2498 oldSound = null;
        if (this.soundType.isPresent()) {
            oldSound = block.field_23162;
            block.field_23162 = this.soundType.get();
        }
        Function oldMapColor = null;
        if (this.mapColor.isPresent()) {
            oldMapColor = block.field_23155.field_10662;
            block.field_23155.field_10662 = this.mapColor.get();
            for (class_2680 s : block.method_9595().method_11662()) {
                s.field_23171 = (class_3620)block.field_23155.field_10662.apply(s);
            }
        }
        Boolean oldCanOcclude = null;
        if (this.canOcclude.isPresent()) {
            oldCanOcclude = block.field_23155.field_20721;
            block.field_23155.field_20721 = this.canOcclude.get();
            for (UnmodifiableIterator s : block.method_9595().method_11662()) {
                s.field_23173 = this.canOcclude.get();
            }
        }
        Boolean oldSpawnParticlesOnBreak = null;
        if (this.spawnParticlesOnBreak.isPresent()) {
            oldSpawnParticlesOnBreak = block.field_23155.field_40341;
            block.field_23155.field_40341 = this.spawnParticlesOnBreak.get();
            for (UnmodifiableIterator s : block.method_9595().method_11662()) {
                s.field_40338 = block.field_23155.field_40341;
            }
        }
        ToIntFunction oldClientLight = null;
        if (this.clientLight.isPresent()) {
            oldClientLight = block.field_23155.field_10663;
            block.field_23155.field_10663 = this.clientLight.get();
            for (class_2680 s : block.method_9595().method_11662()) {
                s.field_23167 = block.field_23155.field_10663.applyAsInt(s);
            }
        }
        class_322 oldColor = null;
        if (this.tintGetter.isPresent()) {
            class_324 blockColors = class_310.method_1551().method_1505();
            oldColor = PlatStuff.getBlockColor(blockColors, block);
            class_322 blockColor = this.tintGetter.get();
            if (blockColor instanceof IColorGetter) {
                IColorGetter cg = (IColorGetter)blockColor;
                blockColor = Polytone.COLORMAPS.getOrCreateConcurrentColormap(cg);
            }
            blockColors.method_1690(blockColor, new class_2248[]{block});
            Polytone.BLOCK_MODIFIERS.maybeAssignToDefaultGrassAndFoliage(block, blockColor);
        }
        BlockSetTypeProvider.Vanilla oldType = null;
        if (this.blockSetType.isPresent()) {
            if (block instanceof class_2323) {
                class_2323 db = (class_2323)block;
                oldType = new BlockSetTypeProvider.Vanilla(db.field_42757);
                db.field_42757 = this.blockSetType.get().getOrCreate(db.method_51169(), this.soundType);
            } else if (block instanceof class_2533) {
                class_2533 tb = (class_2533)block;
                oldType = new BlockSetTypeProvider.Vanilla(tb.field_42779);
                tb.field_42779 = this.blockSetType.get().getOrCreate(tb.field_42779, this.soundType);
            } else if (block instanceof class_2269) {
                class_2269 bb = (class_2269)block;
                oldType = new BlockSetTypeProvider.Vanilla(bb.field_42753);
                bb.field_42753 = this.blockSetType.get().getOrCreate(bb.field_42753, this.soundType);
            } else if (block instanceof class_2440) {
                class_2440 ppb = (class_2440)block;
                oldType = new BlockSetTypeProvider.Vanilla(ppb.field_42726);
                ppb.field_42726 = this.blockSetType.get().getOrCreate(ppb.field_42726, this.soundType);
            }
        }
        if (this.tintHack) {
            Polytone.VARIANT_TEXTURES.addTintOverrideHack(block);
        }
        RenderType oldRenderType = null;
        if (this.renderType.isPresent() && !Polytone.isForge) {
            oldRenderType = this.renderType.get().fromVanilla(PlatStuff.getRenderType(block));
            PlatStuff.setRenderType(block, this.renderType.get().toVanilla());
        }
        return new BlockPropertyModifier(Optional.ofNullable(oldColor), Optional.ofNullable(oldSound), Optional.ofNullable(oldMapColor), Optional.ofNullable(oldCanOcclude), Optional.ofNullable(oldSpawnParticlesOnBreak), Optional.empty(), Optional.ofNullable(oldRenderType), Optional.ofNullable(oldClientLight), List.of(), List.of(), Optional.empty(), Optional.ofNullable(oldType), false, Targets.EMPTY, false);
    }

    public boolean hasColormap() {
        return this.tintGetter.isPresent();
    }

    @Nullable
    public IColorGetter getColormap() {
        return this.tintGetter.orElse(null);
    }

    private static enum RenderType implements class_3542
    {
        SOLID,
        CUTOUT,
        CUTOUT_MIPPED,
        TRIPWIRE,
        TRANSLUCENT;


        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        class_1921 toVanilla() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> class_1921.method_23577();
                case 2 -> class_1921.method_23579();
                case 3 -> class_1921.method_29997();
                case 1 -> class_1921.method_23581();
                case 4 -> class_1921.method_23583();
            };
        }

        RenderType fromVanilla(class_1921 type) {
            if (class_1921.method_23577() == type) {
                return SOLID;
            }
            if (class_1921.method_23581() == type) {
                return CUTOUT;
            }
            if (class_1921.method_23579() == type) {
                return CUTOUT_MIPPED;
            }
            if (class_1921.method_29997() == type) {
                return TRIPWIRE;
            }
            if (class_1921.method_23583() == type) {
                return TRANSLUCENT;
            }
            throw new IllegalStateException("Unknown render type value: " + String.valueOf(type));
        }
    }
}

