/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.slotify;

import com.google.gson.JsonElement;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.slotify.BlitModifier;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.minecraft.class_1058;
import net.minecraft.class_2960;
import net.minecraft.class_329;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_5455;
import net.minecraft.class_6903;

public class GuiOverlayManager
extends JsonPartialReloader {
    private final Map<class_329.class_6411, HeartSprites> heartSprites = new EnumMap<class_329.class_6411, HeartSprites>(class_329.class_6411.class);
    private final Map<class_2960, BlitModifier> blitModifiers = new HashMap<class_2960, BlitModifier>();
    private int index = 0;
    private boolean active = false;

    public GuiOverlayManager() {
        super("overlay_modifiers");
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.blitModifiers.clear();
    }

    @Override
    protected void parseWithLevel(Map<class_2960, JsonElement> jsons, class_6903<JsonElement> ops, class_5455 access) {
        for (Map.Entry<class_2960, BlitModifier> j : Parsed.batchParseOnlyEnabled(jsons, BlitModifier.CODEC, ops, "overlay modifier")) {
            BlitModifier effect = j.getValue();
            class_2960 textureId = effect.target();
            if (this.blitModifiers.containsKey(textureId)) {
                Polytone.LOGGER.warn("Overlay Modifier with texture id {} already exists. Overwriting", (Object)textureId);
            }
            this.blitModifiers.put(textureId, effect);
        }
    }

    @Override
    protected void applyWithLevel(class_5455 access, boolean isLogIn) {
    }

    @Override
    protected Map<class_2960, JsonElement> prepare(class_3300 resourceManager) {
        this.reloadHearths(resourceManager);
        return super.prepare(resourceManager);
    }

    public boolean maybeModifyBlit(class_332 gui, class_1058 sprite, int x, int y, int offset, int width, int height) {
        if (!this.active || this.blitModifiers.isEmpty()) {
            return false;
        }
        BlitModifier mod = this.blitModifiers.get(sprite.method_45851().method_45816());
        if (mod != null) {
            int ind = mod.index();
            if (ind == -1 || ind == this.index) {
                mod.blitModified(gui, sprite, x, x + width, y, y + height, offset, sprite.method_4594(), sprite.method_4577(), sprite.method_4593(), sprite.method_4575());
                return true;
            }
            ++this.index;
        }
        return false;
    }

    public boolean maybeModifyBlit(class_332 guiGraphics, class_1058 sprite, int x, int y, int offset, int textureWidth, int textureHeight, int uPosition, int vPosition, int uWidth, int vHeight) {
        if (!this.active || this.blitModifiers.isEmpty()) {
            return false;
        }
        BlitModifier mod = this.blitModifiers.get(sprite.method_45851().method_45816());
        if (mod != null) {
            int ind = mod.index();
            if (ind == -1 || ind == this.index) {
                mod.blitModified(guiGraphics, sprite, x, x + uWidth, y, y + vHeight, offset, sprite.method_4580((float)uPosition / (float)textureWidth), sprite.method_4580((float)(uPosition + uWidth) / (float)textureWidth), sprite.method_4570((float)vPosition / (float)textureHeight), sprite.method_4570((float)(vPosition + vHeight) / (float)textureHeight));
                return true;
            }
            ++this.index;
        }
        return false;
    }

    public void onStartRenderingOverlay() {
        this.index = 0;
        this.active = true;
    }

    public void onEndRenderingOverlay() {
        this.active = false;
    }

    private void reloadHearths(class_3300 manager) {
        this.heartSprites.clear();
        for (class_329.class_6411 h : class_329.class_6411.values()) {
            if (h == class_329.class_6411.field_33944 || h == class_329.class_6411.field_33945) continue;
            String name = h.name().toLowerCase(Locale.ROOT);
            class_2960 fullRes = class_2960.method_60654((String)("textures/gui/sprites/polytone/heart/container_" + name + "_full.png"));
            class_2960 halfRes = class_2960.method_60654((String)("textures/gui/sprites/polytone/heart/container_" + name + "_half.png"));
            if (!manager.method_14486(fullRes).isPresent() || !manager.method_14486(halfRes).isPresent()) continue;
            class_2960 fullBlinkingRes = Polytone.res("textures/gui/sprites/polytone/heart/container_" + name + "_full_blinking.png");
            Optional fullBlinking = manager.method_14486(fullBlinkingRes);
            class_2960 halfBlinkingRes = Polytone.res("textures/gui/sprites/polytone/heart/container_" + name + "_half_blinking.png");
            Optional halfBlinking = manager.method_14486(halfBlinkingRes);
            class_2960 hardcoreFullRes = Polytone.res("textures/gui/sprites/polytone/heart/container_" + name + "_hardcore_full.png");
            Optional hardcoreFull = manager.method_14486(hardcoreFullRes);
            class_2960 hardcoreFullBlinkingRes = Polytone.res("textures/gui/sprites/polytone/heart/container_" + name + "_hardcore_full_blinking.png");
            Optional hardcoreFullBlinking = manager.method_14486(hardcoreFullBlinkingRes);
            class_2960 hardcoreHalfRes = Polytone.res("textures/gui/sprites/polytone/heart/container_" + name + "_hardcore_half.png");
            Optional hardcoreHalf = manager.method_14486(hardcoreHalfRes);
            class_2960 hardcoreHalfBlinkingRes = Polytone.res("textures/gui/sprites/polytone/heart/container_" + name + "_hardcore_half_blinking.png");
            Optional hardcoreHalfBlinking = manager.method_14486(hardcoreHalfBlinkingRes);
            if (fullBlinking.isEmpty()) {
                fullBlinkingRes = fullRes;
            }
            if (halfBlinking.isEmpty()) {
                halfBlinkingRes = halfRes;
            }
            if (hardcoreFull.isEmpty()) {
                hardcoreFullRes = fullRes;
            }
            if (hardcoreFullBlinking.isEmpty()) {
                hardcoreFullBlinkingRes = hardcoreFullRes;
            }
            if (hardcoreHalf.isEmpty()) {
                hardcoreHalfRes = halfRes;
            }
            if (hardcoreHalfBlinking.isEmpty()) {
                hardcoreHalfBlinkingRes = hardcoreHalfRes;
            }
            fullRes = fullRes.method_45134(p -> p.replace("textures/gui/sprites/", "").replace(".png", ""));
            halfRes = halfRes.method_45134(p -> p.replace("textures/gui/sprites/", "").replace(".png", ""));
            fullBlinkingRes = fullBlinkingRes.method_45134(p -> p.replace("textures/gui/sprites/", "").replace(".png", ""));
            halfBlinkingRes = halfBlinkingRes.method_45134(p -> p.replace("textures/gui/sprites/", "").replace(".png", ""));
            hardcoreFullRes = hardcoreFullRes.method_45134(p -> p.replace("textures/gui/sprites/", "").replace(".png", ""));
            hardcoreFullBlinkingRes = hardcoreFullBlinkingRes.method_45134(p -> p.replace("textures/gui/sprites/", "").replace(".png", ""));
            hardcoreHalfRes = hardcoreHalfRes.method_45134(p -> p.replace("textures/gui/sprites/", "").replace(".png", ""));
            hardcoreHalfBlinkingRes = hardcoreHalfBlinkingRes.method_45134(p -> p.replace("textures/gui/sprites/", "").replace(".png", ""));
            this.heartSprites.put(h, new HeartSprites(fullRes, halfRes, fullBlinkingRes, halfBlinkingRes, hardcoreFullRes, hardcoreHalfRes, hardcoreFullBlinkingRes, hardcoreHalfBlinkingRes));
        }
    }

    public boolean maybeFancifyHeart(class_329 instance, class_332 graphics, class_329.class_6411 actualType, int i, int j, boolean bl, boolean bl2, boolean bl3) {
        if (this.heartSprites.isEmpty()) {
            return false;
        }
        HeartSprites sprites = this.heartSprites.get(actualType);
        if (sprites != null) {
            graphics.method_52706(sprites.getSprite(bl, bl3, bl2), i, j, 9, 9);
            return true;
        }
        return false;
    }

    private record HeartSprites(class_2960 full, class_2960 half, class_2960 fullBlinking, class_2960 halfBlinking, class_2960 hardcoreFull, class_2960 hardcoreHalf, class_2960 hardcoreFullBlinking, class_2960 hardcoreHalfBlinking) {
        public class_2960 getSprite(boolean bl, boolean bl2, boolean bl3) {
            if (!bl) {
                if (bl2) {
                    return bl3 ? this.halfBlinking : this.half;
                }
                return bl3 ? this.fullBlinking : this.full;
            }
            if (bl2) {
                return bl3 ? this.hardcoreHalfBlinking : this.hardcoreHalf;
            }
            return bl3 ? this.hardcoreFullBlinking : this.hardcoreFull;
        }
    }
}

