/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.init;

import glitchcore.event.EventManager;
import glitchcore.event.client.ItemTooltipEvent;
import glitchcore.event.client.RegisterColorsEvent;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1926;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5272;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6395;
import net.minecraft.class_6880;
import sereneseasons.api.SSItems;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.init.ModConfig;
import sereneseasons.init.ModFertility;
import sereneseasons.init.ModTags;
import sereneseasons.season.SeasonColorHandlers;
import sereneseasons.season.SeasonHandlerClient;
import sereneseasons.season.SeasonTime;
import sereneseasons.util.SeasonColorUtil;

public class ModClient {
    public static void setup() {
        SeasonColorHandlers.setup();
    }

    public static void addClientHandlers() {
        EventManager.addListener(SeasonHandlerClient::onClientTick);
        EventManager.addListener(ModFertility::setupTooltips);
        EventManager.addListener(ModClient::registerBlockColors);
        EventManager.addListener(ModClient::onItemTooltip);
    }

    public static void onItemTooltip(ItemTooltipEvent event) {
        List tooltip = event.getTooltip();
        class_1657 player = event.getPlayer();
        if (event.getStack().method_7909() != SSItems.CALENDAR) {
            return;
        }
        if (player != null && ModConfig.seasons.isDimensionWhitelisted((class_5321<class_1937>)player.method_37908().method_27983())) {
            int seasonCycleTicks = SeasonHelper.getSeasonState(player.method_37908()).getSeasonCycleTicks();
            SeasonTime time = new SeasonTime(seasonCycleTicks);
            int subSeasonDuration = ModConfig.seasons.subSeasonDuration;
            tooltip.add(class_2561.method_43471((String)("desc.sereneseasons." + time.getSubSeason().toString().toLowerCase(Locale.ROOT))).method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43471((String)("desc.sereneseasons." + time.getTropicalSeason().toString().toLowerCase(Locale.ROOT))).method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1063)));
            tooltip.add(class_2561.method_43469((String)"desc.sereneseasons.day_counter", (Object[])new Object[]{time.getDay() % subSeasonDuration + 1, subSeasonDuration}).method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43469((String)"desc.sereneseasons.tropical_day_counter", (Object[])new Object[]{(time.getDay() + subSeasonDuration) % (subSeasonDuration * 2) + 1, subSeasonDuration * 2}).method_27692(class_124.field_1063)));
        } else {
            tooltip.add(class_2561.method_43470((String)"???").method_27692(class_124.field_1080));
        }
    }

    public static void registerItemProperties() {
        class_5272.method_27879((class_1792)SSItems.CALENDAR, (class_2960)class_2960.method_60655((String)"sereneseasons", (String)"time"), (class_6395)new class_6395(){

            public float unclampedCall(class_1799 stack, class_638 clientWorld, class_1309 entity, int seed) {
                class_1309 holder;
                class_638 world = clientWorld;
                Object object = holder = entity != null ? entity : stack.method_7945();
                if (world == null && holder != null) {
                    world = holder.method_37908();
                }
                if (world == null) {
                    return 0.0f;
                }
                int seasonCycleTicks = SeasonHelper.getSeasonState((class_1937)world).getSeasonCycleTicks();
                double d0 = (float)seasonCycleTicks / (float)SeasonTime.ZERO.getCycleDuration();
                return class_3532.method_15341((float)((float)d0), (float)1.0f);
            }
        });
        class_5272.method_27879((class_1792)SSItems.CALENDAR, (class_2960)class_2960.method_60655((String)"sereneseasons", (String)"seasontype"), (class_6395)new class_6395(){

            public float unclampedCall(class_1799 stack, class_638 clientWorld, class_1309 entity, int seed) {
                class_6880 biome;
                class_1309 holder;
                class_638 level = clientWorld;
                Object object = holder = entity != null ? entity : stack.method_7945();
                if (level == null && holder != null) {
                    level = holder.method_37908();
                }
                if (level == null) {
                    return 2.0f;
                }
                float type = ModConfig.seasons.isDimensionWhitelisted((class_5321<class_1937>)level.method_27983()) ? (holder != null ? ((biome = level.method_23753(holder.method_24515())).method_40220(ModTags.Biomes.TROPICAL_BIOMES) ? 1.0f : 0.0f) : 0.0f) : 2.0f;
                return type;
            }
        });
    }

    private static void registerBlockColors(RegisterColorsEvent.Block event) {
        event.register((state, dimensionReader, pos, tintIndex) -> {
            class_6880 biome;
            int birchColor = class_1926.method_8343();
            class_1937 level = class_310.method_1551().field_1724.method_37908();
            class_5321 dimension = class_310.method_1551().field_1724.method_37908().method_27983();
            if (level != null && pos != null && ModConfig.seasons.changeBirchColor && ModConfig.seasons.isDimensionWhitelisted((class_5321<class_1937>)dimension) && !(biome = level.method_23753(pos)).method_40220(ModTags.Biomes.BLACKLISTED_BIOMES)) {
                ISeasonState calendar = SeasonHelper.getSeasonState(level);
                Enum colorProvider = biome.method_40220(ModTags.Biomes.TROPICAL_BIOMES) ? calendar.getTropicalSeason() : calendar.getSubSeason();
                birchColor = colorProvider.getBirchColor();
                if (biome.method_40220(ModTags.Biomes.LESSER_COLOR_CHANGE_BIOMES)) {
                    birchColor = SeasonColorUtil.mixColours(colorProvider.getBirchColor(), class_1926.method_8343(), 0.75f);
                }
            }
            return birchColor;
        }, (Object[])new class_2248[]{class_2246.field_10539});
    }
}

