/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.animatica.animation;

import io.github.foundationgames.animatica.util.PropertyUtil;
import io.github.foundationgames.animatica.util.Utilities;
import io.github.foundationgames.animatica.util.exception.InvalidPropertyException;
import io.github.foundationgames.animatica.util.exception.PropertyParseException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import net.minecraft.class_151;
import net.minecraft.class_2960;

public record AnimationMeta(class_2960 source, class_2960 target, int targetX, int targetY, int width, int height, int defaultFrameDuration, boolean interpolate, int interpolationDelay, Map<Integer, Integer> frameMapping, Map<Integer, Integer> frameDurations) {
    public static AnimationMeta of(class_2960 file, Properties properties) throws PropertyParseException {
        class_2960 target;
        class_2960 source;
        try {
            source = Utilities.processPath(file, class_2960.method_60654((String)PropertyUtil.get(file, properties, "from")));
        }
        catch (class_151 ex) {
            throw new InvalidPropertyException(file, "from", "resource location");
        }
        try {
            target = Utilities.processPath(file, class_2960.method_60654((String)PropertyUtil.get(file, properties, "to")));
        }
        catch (class_151 ex) {
            throw new InvalidPropertyException(file, "to", "resource location");
        }
        return new AnimationMeta(source, target, PropertyUtil.getInt(file, properties, "x"), PropertyUtil.getInt(file, properties, "y"), PropertyUtil.getInt(file, properties, "w"), PropertyUtil.getInt(file, properties, "h"), PropertyUtil.getIntOr(file, properties, "duration", 1), PropertyUtil.getBoolOr(file, properties, "interpolate", false), PropertyUtil.getIntOr(file, properties, "skip", 0), PropertyUtil.intToIntMap(PropertyUtil.getSubProperties(properties, "tile")), PropertyUtil.intToIntMap(PropertyUtil.getSubProperties(properties, "duration")));
    }

    public int getGreatestUsedFrame() {
        HashSet<Integer> frames = new HashSet<Integer>(this.frameMapping.keySet());
        frames.addAll(this.frameDurations.keySet());
        int greatestFrame = 0;
        Iterator iterator = frames.iterator();
        while (iterator.hasNext()) {
            int frame = (Integer)iterator.next();
            greatestFrame = Math.max(frame, greatestFrame);
        }
        return greatestFrame;
    }
}

