/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.structure.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.yungsapi.module.StructurePlacementTypeModule;
import com.yungnickyoung.minecraft.yungsapi.world.structure.exclusion.EnhancedExclusionZone;
import java.util.Optional;
import net.minecraft.class_2382;
import net.minecraft.class_5699;
import net.minecraft.class_6872;
import net.minecraft.class_6873;
import net.minecraft.class_6874;
import net.minecraft.class_6875;
import net.minecraft.class_7869;

public class EnhancedRandomSpread
extends class_6872 {
    public static final MapCodec<EnhancedRandomSpread> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)class_2382.method_39677((int)16).optionalFieldOf("locate_offset", (Object)class_2382.field_11176).forGetter(placement -> placement.method_41642()), (App)class_6874.class_7154.field_37786.optionalFieldOf("frequency_reduction_method", (Object)class_6874.class_7154.field_37782).forGetter(placement -> placement.method_41643()), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("frequency", (Object)Float.valueOf(1.0f)).forGetter(placement -> Float.valueOf(placement.method_41644())), (App)class_5699.field_33441.fieldOf("salt").forGetter(placement -> placement.method_41645()), (App)class_6874.class_7152.field_37781.optionalFieldOf("exclusion_zone").forGetter(placement -> placement.method_41646()), (App)EnhancedExclusionZone.CODEC.optionalFieldOf("enhanced_exclusion_zone").forGetter(placement -> placement.enhancedExclusionZone), (App)class_5699.field_33441.fieldOf("spacing").forGetter(class_6872::method_41632), (App)class_5699.field_33441.fieldOf("separation").forGetter(class_6872::method_41633), (App)class_6873.field_36423.optionalFieldOf("spread_type", (Object)class_6873.field_36421).forGetter(class_6872::method_41634)).apply((Applicative)builder, builder.stable(EnhancedRandomSpread::new))).validate(EnhancedRandomSpread::validateSpacing);
    private final Optional<EnhancedExclusionZone> enhancedExclusionZone;

    private static DataResult<EnhancedRandomSpread> validateSpacing(EnhancedRandomSpread placement) {
        return placement.method_41632() <= placement.method_41633() ? DataResult.error(() -> "EnhancedRandomSpread's spacing has to be larger than separation") : DataResult.success((Object)((Object)placement));
    }

    public EnhancedRandomSpread(class_2382 locateOffset, class_6874.class_7154 frequencyReductionMethod, Float frequency, Integer salt, Optional<class_6874.class_7152> exclusionZone, Optional<EnhancedExclusionZone> enhancedExclusionZone, Integer spacing, Integer separation, class_6873 randomSpreadType) {
        super(locateOffset, frequencyReductionMethod, frequency.floatValue(), salt.intValue(), exclusionZone, spacing.intValue(), separation.intValue(), randomSpreadType);
        this.enhancedExclusionZone = enhancedExclusionZone;
    }

    public class_6875<?> method_40166() {
        return StructurePlacementTypeModule.ENHANCED_RANDOM_SPREAD;
    }

    public boolean method_41639(class_7869 chunkGeneratorStructureState, int x, int z) {
        if (!super.method_41639(chunkGeneratorStructureState, x, z)) {
            return false;
        }
        return this.enhancedExclusionZone.isEmpty() || !this.enhancedExclusionZone.get().isPlacementForbidden(chunkGeneratorStructureState, x, z);
    }
}

