/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus;

import com.Gabou.sereneseasonsplus.SereneSeasonPlusCommon;
import com.Gabou.sereneseasonsplus.config.SereneExtendedConfig;
import com.Gabou.sereneseasonsplus.event.SeasonChangeEvent;
import com.Gabou.sereneseasonsplus.features.CommonSnowBlockFeature;
import com.Gabou.sereneseasonsplus.util.DebugCommands;
import com.Gabou.sereneseasonsplus.util.EnvironmentHelper;
import com.Gabou.sereneseasonsplus.util.FabricAsyncExecutorHandler;
import com.Gabou.sereneseasonsplus.util.FabricEnvironmentHelper;
import com.Gabou.sereneseasonsplus.util.SereneService;
import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class SereneSeasonsPlusFabric
extends SereneSeasonPlusCommon
implements ModInitializer {
    public void onInitialize() {
        LOGGER.info("Initializing Serene Seasons Plus (Fabric)");
        ServerLifecycleEvents.SERVER_STARTED.register(this::onServerStarted);
        ServerLifecycleEvents.SERVER_STARTING.register(this::onServerStarting);
        ServerLifecycleEvents.SERVER_STOPPING.register(this::onServerStopping);
        ServerChunkEvents.CHUNK_LOAD.register(this::onChunkLoad);
        EnvironmentHelper.init(new FabricEnvironmentHelper());
        SeasonChangeEvent.register();
        SereneExtendedConfig.registerReloadListener(this::onConfigReload);
        ServerTickEvents.START_WORLD_TICK.register(this::onWorldTick);
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, selection) -> DebugCommands.registerTo((CommandDispatcher<class_2168>)dispatcher));
    }

    private void onConfigReload() {
        CommonSnowBlockFeature.onConfigReload(SereneExtendedConfig.TICK_SNOW_REPLACER.get(), SereneExtendedConfig.SNOWSTORM_ENABLED.get());
        SereneService.reloadConfig();
    }

    private void onServerStarting(MinecraftServer server) {
        LOGGER.info("Serene Seasons Plus server starting!");
        SereneService.HANDLER = new FabricAsyncExecutorHandler();
        CommonSnowBlockFeature.onServerStarting(SereneExtendedConfig.TICK_SNOW_REPLACER.get(), SereneExtendedConfig.SNOWSTORM_ENABLED.get());
    }

    private void onServerStarted(MinecraftServer server) {
        EnvironmentHelper.onServerStarted(server.method_3847(class_1937.field_25179));
        ((class_1928.class_4312)server.method_3767().method_20746(class_1928.field_40883)).method_35236(SereneExtendedConfig.MAX_SNOW_ACCUMULATION_LAYERS.get(), server);
    }

    private void onServerStopping(MinecraftServer server) {
        SereneService.shutdown();
        SereneService.HANDLER = null;
        CommonSnowBlockFeature.onServerStopping();
    }

    private void onWorldTick(class_3218 level) {
        if (level.method_27983() != class_1937.field_25179) {
            return;
        }
        this.onTick((class_1937)level, SereneExtendedConfig.ENABLE_SEASONAL_DAYLIGHT_CYCLE.get(), SereneExtendedConfig.CUSTOM_CYCLE_LENGTH.get(), SereneExtendedConfig.CUSTOM_DAY_LENGTH.get(), SereneExtendedConfig.CUSTOM_NIGHT_LENGTH.get());
        CommonSnowBlockFeature.handleServerTick(level.method_8503(), level);
    }

    private void onChunkLoad(class_3218 level, class_2791 chunkAccess) {
        if (level == null) {
            return;
        }
        if (!(chunkAccess instanceof class_2818)) {
            return;
        }
        class_2818 chunk = (class_2818)chunkAccess;
        if (level.method_8608()) {
            return;
        }
        if (level.method_27983() != class_1937.field_25179) {
            return;
        }
        CommonSnowBlockFeature.handleOnChunkLoad(chunk);
    }
}

