/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.driver.sdl;

import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.log.ControlifyLogger;
import dev.isxander.sdl3java.api.SdlInit;
import dev.isxander.sdl3java.api.error.SdlError;
import dev.isxander.sdl3java.api.hints.SdlHints;
import dev.isxander.sdl3java.api.version.SdlVersion;
import dev.isxander.sdl3java.api.version.SdlVersionRecord;

public class LoadedSDLNatives {
    private static final ControlifyLogger logger = CUtil.LOGGER.createSubLogger("LoadedSDLNatives");
    private boolean hasAttemptedLoad = false;
    private boolean hasAudio = false;

    void startSDL3() {
        if (this.hasAttemptedLoad) {
            logger.warn("SDL3 has already been started, not starting again");
            return;
        }
        this.hasAttemptedLoad = true;
        SdlHints.SDL_SetHint((String)"SDL_JOYSTICK_HIDAPI", (String)"1");
        SdlHints.SDL_SetHint((String)"SDL_JOYSTICK_ENHANCED_REPORTS", (String)"1");
        SdlHints.SDL_SetHint((String)"SDL_JOYSTICK_HIDAPI_STEAM", (String)"1");
        SdlHints.SDL_SetHint((String)"SDL_JOYSTICK_ROG_CHAKRAM", (String)"1");
        SdlHints.SDL_SetHint((String)"SDL_JOYSTICK_ALLOW_BACKGROUND_EVENTS", (String)"1");
        SdlHints.SDL_SetHint((String)"SDL_JOYSTICK_LINUX_DEADZONES", (String)"1");
        SdlVersionRecord nativesVersion = SdlVersionRecord.fromPacked((int)SdlVersion.SDL_GetVersion());
        SdlVersionRecord javaVersion = SdlVersion.SDL_GetJavaBindingsVersion();
        logger.log("Loading SDL3 version: {}. Java bindings targeting: {}", nativesVersion, javaVersion);
        if (!nativesVersion.equals((Object)javaVersion)) {
            logger.warn("SDL3 NATIVE LIBRARY VERSION MISMATCH! Java bindings are targeting a different version of SDL3 than the loaded native library. This may cause issues.");
        }
        if (!SdlInit.SDL_Init((int)25088)) {
            logger.error("Failed to initialise SDL3: {}", SdlError.SDL_GetError());
            throw new RuntimeException("Failed to initialise SDL3: " + SdlError.SDL_GetError());
        }
        if (!SdlInit.SDL_InitSubSystem((int)16)) {
            logger.warn("Failed to initialise SDL3's audio subsystem, continuing without audio: {}", SdlError.SDL_GetError());
            this.hasAudio = false;
        } else {
            this.hasAudio = true;
        }
        logger.log("Successfully initialised SDL subsystems");
    }

    public boolean hasAudio() {
        return this.hasAudio;
    }
}

