/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.datafixer;

import de.ambertation.wunderlib.utils.Version;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import org.betterx.bclib.api.v2.datafixer.MigrationProfile;
import org.betterx.bclib.interfaces.PatchBiFunction;
import org.betterx.bclib.interfaces.PatchFunction;
import org.betterx.wover.core.api.ModCore;
import org.jetbrains.annotations.NotNull;

public abstract class Patch {
    private static final List<Patch> ALL = new ArrayList<Patch>(10);
    public final int level;
    public final Version version;
    @NotNull
    public final ModCore modCore;
    public final boolean alwaysApply;

    static List<Patch> getALL() {
        return ALL;
    }

    public static Version maxPatchVersion(@NotNull ModCore modCore) {
        return ALL.stream().filter(p -> p.modCore.equals((Object)modCore)).map(p -> p.version).reduce((p, c) -> c).orElse(Version.ZERO);
    }

    public static int maxPatchLevel(@NotNull ModCore modCore) {
        return ALL.stream().filter(p -> p.modCore.equals((Object)modCore)).mapToInt(p -> p.level).max().orElse(0);
    }

    protected Patch(@NotNull ModCore modCore, Version version) {
        this(modCore, version, false);
    }

    Patch(@NotNull ModCore modCore, Version version, boolean alwaysApply) {
        if (modCore == null) {
            throw new RuntimeException("[INTERNAL ERROR] Patches need a valid modID!");
        }
        if (version == null || version == Version.ZERO) {
            throw new RuntimeException("Invalid Mod-Version");
        }
        this.modCore = modCore;
        this.version = version;
        this.alwaysApply = alwaysApply;
        this.level = version.toInt();
        if (!ALL.stream().filter(p -> p.modCore.equals((Object)this.modCore)).noneMatch(p -> p.level >= this.level) || this.level <= 0) {
            throw new RuntimeException("[INTERNAL ERROR] Patch-levels need to be created in ascending order beginning with 1.");
        }
    }

    public String toString() {
        return "Patch{" + String.valueOf(this.modCore) + ":" + String.valueOf(this.version) + ":" + this.level + "}";
    }

    public Map<String, String> getIDReplacements() {
        return new HashMap<String, String>();
    }

    public PatchFunction<class_2487, Boolean> getLevelDatPatcher() {
        return null;
    }

    public PatchFunction<class_2487, Boolean> getWorldDataPatcher() {
        return null;
    }

    public PatchBiFunction<class_2499, class_2499, Boolean> getBlockStatePatcher() {
        return null;
    }

    static MigrationProfile createMigrationData(class_2487 config) {
        return new MigrationProfile(config, false);
    }

    static MigrationProfile createMigrationData() {
        return new MigrationProfile(null, true);
    }

    public List<String> getWorldDataIDPaths() {
        return null;
    }
}

