/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.furniture.block;

import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2383;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_9062;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.blocks.BaseBlockNotFull;
import org.betterx.bclib.furniture.block.BaseChair;
import org.betterx.bclib.furniture.entity.EntityChair;
import org.betterx.bclib.registry.BaseBlockEntities;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.wover.block.api.model.BlockModelProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.betterx.wover.loot.api.BlockLootProvider;
import org.betterx.wover.loot.api.LootLookupProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractChair
extends BaseBlockNotFull
implements BlockModelProvider,
BlockLootProvider {
    public static final class_2753 FACING = class_2383.field_11177;
    public final class_2248 baseMaterial;
    protected final float height;

    public static class_4970.class_2251 defaultFurnitureProperties(class_2248 block) {
        return class_4970.class_2251.method_9630((class_4970)block).method_22488();
    }

    public AbstractChair(class_2248 baseMaterial, int height) {
        super(AbstractChair.defaultFurnitureProperties(baseMaterial));
        this.height = ((float)height - 3.0f) / 16.0f;
        this.baseMaterial = baseMaterial;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
        stateManager.method_11667(new class_2769[]{FACING});
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042().method_10153());
    }

    @NotNull
    public class_9062 method_55765(class_1799 itemStack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        EntityChair entity;
        if (world.field_9236) {
            return class_9062.field_47733;
        }
        if (player.method_5765() || player.method_7325()) {
            return class_9062.field_47733;
        }
        Optional<EntityChair> active = this.getEntity(world, pos);
        if (active.isEmpty()) {
            entity = this.createEntity(state, world, pos);
        } else {
            entity = active.get();
            if (entity.method_5782()) {
                return class_9062.field_47733;
            }
        }
        if (entity != null) {
            float yaw = ((class_2350)state.method_11654((class_2769)FACING)).method_10153().method_10144();
            player.method_5873((class_1297)entity, true);
            player.method_5636(yaw);
            player.method_5847(yaw);
            return class_9062.field_47728;
        }
        return class_9062.field_47733;
    }

    @Nullable
    private EntityChair createEntity(class_2680 state, class_1937 world, class_2338 pos) {
        BCLib.LOGGER.info("Creating Chair at " + String.valueOf(pos) + ", " + String.valueOf(state));
        double px = (double)pos.method_10263() + 0.5;
        double py = (float)pos.method_10264() + this.height;
        double pz = (double)pos.method_10260() + 0.5;
        float yaw = ((class_2350)state.method_11654((class_2769)FACING)).method_10153().method_10144();
        EntityChair entity = (EntityChair)BaseBlockEntities.CHAIR.method_5883(world);
        entity.method_5808(px, py, pz, yaw, 0.0f);
        entity.method_5875(true);
        entity.method_5803(true);
        entity.method_5648(true);
        entity.method_5847(yaw);
        entity.method_5636(yaw);
        if (!world.method_8649((class_1297)entity)) {
            entity = null;
        }
        return entity;
    }

    private Optional<EntityChair> getEntity(class_1937 level, class_2338 pos) {
        List list = level.method_8390(EntityChair.class, new class_238(pos), entity -> true);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((EntityChair)((Object)list.get(0)));
    }

    @NotNull
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return BlocksHelper.rotateHorizontal(state, rotation, (class_2769<class_2350>)FACING);
    }

    @NotNull
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return BlocksHelper.mirrorHorizontal(state, mirror, (class_2769<class_2350>)FACING);
    }

    public void method_9615(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2680 blockState2, boolean bl) {
        super.method_9615(blockState, level, blockPos, blockState2, bl);
        BCLib.LOGGER.info("Created at " + String.valueOf(blockPos) + ", " + String.valueOf(blockState) + ", " + String.valueOf(blockState2));
        if (blockState.method_28498((class_2769)BaseChair.TOP) && ((Boolean)blockState.method_11654((class_2769)BaseChair.TOP)).booleanValue()) {
            return;
        }
        this.createEntity(blockState, level, blockPos);
    }

    @Override
    public class_52.class_53 registerBlockLoot(@NotNull class_2960 location, @NotNull LootLookupProvider provider, @NotNull class_5321<class_52> tableKey) {
        return provider.drop((class_1935)this.method_8389());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void provideBlockModels(WoverBlockModelGenerators generator) {
    }
}

