/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure;

import com.google.common.base.Function;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.client.ExposureStore;
import io.github.mortuusars.exposure.client.RenderedExposures;
import io.github.mortuusars.exposure.client.animation.CameraModelPoses;
import io.github.mortuusars.exposure.client.animation.CameraPoses;
import io.github.mortuusars.exposure.client.camera.viewfinder.Viewfinder;
import io.github.mortuusars.exposure.client.camera.viewfinder.ViewfinderRegistry;
import io.github.mortuusars.exposure.client.capture.template.CameraCaptureTemplate;
import io.github.mortuusars.exposure.client.capture.template.CaptureTemplates;
import io.github.mortuusars.exposure.client.capture.template.ExposeCaptureTemplate;
import io.github.mortuusars.exposure.client.capture.template.PathCaptureTemplate;
import io.github.mortuusars.exposure.client.capture.template.SingleChannelCaptureTemplate;
import io.github.mortuusars.exposure.client.image.modifier.ImageEffect;
import io.github.mortuusars.exposure.client.render.image.ImageRenderer;
import io.github.mortuusars.exposure.client.render.photograph.PhotographRenderer;
import io.github.mortuusars.exposure.client.render.photograph.PhotographStyle;
import io.github.mortuusars.exposure.client.render.photograph.PhotographStyles;
import io.github.mortuusars.exposure.client.task.ClearStaleRenderedImagesIndefiniteTask;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.util.cycles.Cycles;
import io.github.mortuusars.exposure.world.camera.Camera;
import io.github.mortuusars.exposure.world.camera.capture.CaptureType;
import io.github.mortuusars.exposure.world.item.AlbumItem;
import io.github.mortuusars.exposure.world.item.ChromaticSheetItem;
import io.github.mortuusars.exposure.world.item.StackedPhotographsItem;
import io.github.mortuusars.exposure.world.item.camera.Attachment;
import io.github.mortuusars.exposure.world.item.camera.CameraItem;
import io.github.mortuusars.exposure.world.photograph.PhotographType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1091;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_5272;
import net.minecraft.class_9334;

public class ExposureClient {
    private static final Cycles CYCLES = new Cycles();
    private static final ExposureStore EXPOSURE_STORE = new ExposureStore();
    private static final RenderedExposures RENDERED_EXPOSURES = new RenderedExposures();
    private static final ImageRenderer IMAGE_RENDERER = new ImageRenderer();
    private static final PhotographRenderer PHOTOGRAPH_RENDERER = new PhotographRenderer();

    public static void init() {
        CameraModelPoses.register(Exposure.Items.CAMERA.get(), new CameraPoses());
        ViewfinderRegistry.register(Exposure.Items.CAMERA.get(), (Function<Camera, Viewfinder>)((Function)Viewfinder::new));
        CaptureTemplates.register(CaptureType.CAMERA, new CameraCaptureTemplate());
        CaptureTemplates.register(CaptureType.EXPOSE_COMMAND, new ExposeCaptureTemplate());
        CaptureTemplates.register(CaptureType.LOAD_COMMAND, new PathCaptureTemplate());
        CaptureTemplates.register(CaptureType.DEBUG_RGB, new SingleChannelCaptureTemplate());
        PhotographStyles.register(PhotographType.REGULAR, PhotographStyle.REGULAR);
        PhotographStyles.register(PhotographType.AGED, new PhotographStyle(Textures.Photograph.AGED_PAPER, Textures.Photograph.AGED_OVERLAY, Textures.Photograph.AGED_ALBUM_PAPER, Textures.Photograph.AGED_ALBUM_OVERLAY, ImageEffect.AGED));
        ExposureClient.cycles().addParallelTask(new ClearStaleRenderedImagesIndefiniteTask());
        ExposureClient.registerItemModelProperties();
    }

    public static Cycles cycles() {
        return CYCLES;
    }

    public static ExposureStore exposureStore() {
        return EXPOSURE_STORE;
    }

    public static RenderedExposures renderedExposures() {
        return RENDERED_EXPOSURES;
    }

    public static ImageRenderer imageRenderer() {
        return IMAGE_RENDERER;
    }

    public static PhotographRenderer photographRenderer() {
        return PHOTOGRAPH_RENDERER;
    }

    public static boolean shouldUseDirectCapture() {
        if (PlatformHelper.isModLoaded("distanthorizons") && (PlatformHelper.isModLoaded("oculus") || PlatformHelper.isModLoaded("iris"))) {
            return true;
        }
        return Config.Client.FORCE_DIRECT_CAPTURE.isTrue() || ((List)Config.Client.FORCE_DIRECT_CAPTURE_MODS.get()).stream().anyMatch(PlatformHelper::isModLoaded);
    }

    private static void registerItemModelProperties() {
        class_5272.method_27879((class_1792)Exposure.Items.CAMERA.get(), (class_2960)Exposure.resource("camera_gold"), (stack, level, entity, seed) -> (Boolean)stack.method_57825(Exposure.DataComponents.CAMERA_GOLD, (Object)false) != false ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)Exposure.Items.CAMERA.get(), (class_2960)Exposure.resource("camera_active"), (stack, level, entity, seed) -> {
            CameraItem cameraItem;
            class_1792 patt0$temp = stack.method_7909();
            return patt0$temp instanceof CameraItem && (cameraItem = (CameraItem)patt0$temp).isActive(stack) ? 1 : 0;
        });
        class_5272.method_27879((class_1792)Exposure.Items.CAMERA.get(), (class_2960)Exposure.resource("camera_selfie"), (stack, level, entity, seed) -> {
            CameraItem cameraItem;
            class_1792 patt0$temp = stack.method_7909();
            return patt0$temp instanceof CameraItem && (cameraItem = (CameraItem)patt0$temp).isInSelfieMode(stack) ? (entity == Minecrft.get().method_1560() ? 0.5f : 1.0f) : 0.0f;
        });
        class_5272.method_27879((class_1792)Exposure.Items.CAMERA.get(), (class_2960)Exposure.resource("camera_has_lens"), (stack, level, entity, seed) -> !Attachment.LENS.get(stack).isEmpty() ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)Exposure.Items.CAMERA.get(), (class_2960)Exposure.resource("camera_has_flash"), (stack, level, entity, seed) -> !Attachment.FLASH.get(stack).isEmpty() ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)Exposure.Items.CHROMATIC_SHEET.get(), (class_2960)Exposure.resource("channels"), (stack, clientLevel, livingEntity, seed) -> {
            float f;
            class_1792 patt0$temp = stack.method_7909();
            if (patt0$temp instanceof ChromaticSheetItem) {
                ChromaticSheetItem chromaticSheet = (ChromaticSheetItem)patt0$temp;
                f = (float)chromaticSheet.getLayers(stack).size() / 10.0f;
            } else {
                f = 0.0f;
            }
            return f;
        });
        class_5272.method_27879((class_1792)Exposure.Items.STACKED_PHOTOGRAPHS.get(), (class_2960)Exposure.resource("count"), (stack, clientLevel, livingEntity, seed) -> {
            float f;
            class_1792 patt0$temp = stack.method_7909();
            if (patt0$temp instanceof StackedPhotographsItem) {
                StackedPhotographsItem stackedPhotographsItem = (StackedPhotographsItem)patt0$temp;
                f = (float)stackedPhotographsItem.getPhotographs(stack).size() / 100.0f;
            } else {
                f = 0.0f;
            }
            return f;
        });
        class_5272.method_27879((class_1792)Exposure.Items.ALBUM.get(), (class_2960)Exposure.resource("photos"), (stack, clientLevel, livingEntity, seed) -> {
            float f;
            class_1792 patt0$temp = stack.method_7909();
            if (patt0$temp instanceof AlbumItem) {
                AlbumItem albumItem = (AlbumItem)patt0$temp;
                f = (float)albumItem.getPhotographsCount(stack) / 100.0f;
            } else {
                f = 0.0f;
            }
            return f;
        });
        class_5272.method_27879((class_1792)Exposure.Items.INTERPLANAR_PROJECTOR.get(), (class_2960)Exposure.resource("projector_active"), (stack, clientLevel, livingEntity, seed) -> (Boolean)Config.Server.CAN_PROJECT.get() != false && stack.method_57826(class_9334.field_49631) ? 1.0f : 0.0f);
    }

    public static class Textures {
        public static final class_2960 EMPTY = Exposure.resource("textures/empty.png");

        public static class Photograph {
            public static final class_2960 REGULAR_PAPER = Exposure.resource("textures/photograph/photograph.png");
            public static final class_2960 REGULAR_ALBUM_PAPER = Exposure.resource("textures/photograph/photograph_album.png");
            public static final class_2960 AGED_PAPER = Exposure.resource("textures/photograph/aged_photograph.png");
            public static final class_2960 AGED_OVERLAY = Exposure.resource("textures/photograph/aged_photograph_overlay.png");
            public static final class_2960 AGED_ALBUM_PAPER = Exposure.resource("textures/photograph/aged_photograph_album.png");
            public static final class_2960 AGED_ALBUM_OVERLAY = Exposure.resource("textures/photograph/aged_photograph_album_overlay.png");
        }
    }

    public static class Models {
        public static final Set<class_1091> MODELS = new HashSet<class_1091>();
        public static final class_1091 CAMERA_GUI = Models.register("item/camera_gui");
        public static final class_1091 CAMERA_ACTIVE = Models.register("item/camera_active");
        public static final class_1091 CAMERA_SELFIE = Models.register("item/camera_selfie");
        public static final class_1091 CAMERA_VIEWFINDER = Models.register("item/camera_parts/viewfinder");
        public static final class_1091 CAMERA_FLASH = Models.register("item/camera_parts/flash");
        public static final class_1091 CAMERA_LENS = Models.register("item/camera_parts/lens");
        public static final class_1091 CAMERA_SELFIE_STICK = Models.register("item/camera_parts/selfie_stick");
        public static final class_1091 SELFIE_STICK = Models.register("item/selfie_stick");
        public static final class_1091 PHOTOGRAPH_FRAME_SMALL = Models.register("block/photograph_frame_small");
        public static final class_1091 PHOTOGRAPH_FRAME_MEDIUM = Models.register("block/photograph_frame_medium");
        public static final class_1091 PHOTOGRAPH_FRAME_LARGE = Models.register("block/photograph_frame_large");
        public static final class_1091 CLEAR_PHOTOGRAPH_FRAME_SMALL = Models.register("block/glass_photograph_frame_small");
        public static final class_1091 CLEAR_PHOTOGRAPH_FRAME_MEDIUM = Models.register("block/glass_photograph_frame_medium");
        public static final class_1091 CLEAR_PHOTOGRAPH_FRAME_LARGE = Models.register("block/glass_photograph_frame_large");
        public static final class_1091 CAMERA_STAND = Models.register("block/camera_stand");
        public static final class_1091 CAMERA_STAND_MOUNT = Models.register("block/camera_stand_mount");

        public static class_1091 register(String path) {
            class_1091 location = new class_1091(Exposure.resource(path), "standalone");
            MODELS.add(location);
            return location;
        }
    }
}

