/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.world.level.storage.ExposureFrameHistory;
import io.github.mortuusars.exposure.world.level.storage.ExposureRepository;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ExposureServer {
    private static ExposureRepository vault;
    private static ExposureFrameHistory frameHistory;
    public static boolean debugHighlightEntitiesInFrame;

    public static void init(MinecraftServer server) {
        vault = new ExposureRepository(server);
        frameHistory = ExposureFrameHistory.loadOrCreate(server);
    }

    public static ExposureRepository exposureRepository() {
        return ExposureServer.ensureInitialized(vault);
    }

    public static ExposureFrameHistory frameHistory() {
        return ExposureServer.ensureInitialized(frameHistory);
    }

    private static <T> T ensureInitialized(@Nullable T obj) {
        Preconditions.checkNotNull(obj, (Object)"Cannot get a field in ExposureServer: server is not initialized yet.");
        return obj;
    }

    static {
        debugHighlightEntitiesInFrame = false;
    }
}

