/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.camera;

import io.github.mortuusars.exposure.client.camera.viewfinder.Viewfinder;
import io.github.mortuusars.exposure.client.camera.viewfinder.ViewfinderRegistry;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.common.ActiveCameraDeactivateCommonPacket;
import io.github.mortuusars.exposure.world.camera.Camera;
import io.github.mortuusars.exposure.world.camera.CameraOnStand;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_5498;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CameraClient {
    @Nullable
    private static Viewfinder activeViewfinder;

    public static void tick() {
        if (activeViewfinder != null) {
            activeViewfinder.tick();
        }
    }

    public static Optional<Camera> getActive() {
        return Minecrft.player().getActiveExposureCameraOptional();
    }

    public static boolean isActive() {
        return CameraClient.getActive().isPresent();
    }

    public static void deactivate() {
        Minecrft.player().getActiveExposureCameraOptional().ifPresent(camera -> {
            camera.map((item, stack) -> item.deactivate(camera.getHolder().asHolderEntity(), (class_1799)stack));
            Minecrft.player().removeActiveExposureCamera();
        });
        Packets.sendToServer(ActiveCameraDeactivateCommonPacket.INSTANCE);
    }

    public static void setCameraEntity(class_1297 entity) {
        Minecrft.get().field_1719 = entity;
        Minecrft.get().field_1773.method_19418().field_18721 = entity.method_5751();
        Minecrft.get().field_1773.method_19418().field_18722 = entity.method_5751();
        Minecrft.get().field_1773.method_19418().method_19337();
    }

    public static void resetCameraEntity() {
        CameraClient.setCameraEntity((class_1297)Minecrft.player());
    }

    @Nullable
    public static Viewfinder viewfinder() {
        return activeViewfinder;
    }

    public static void setupViewfinder(@NotNull Camera camera) {
        CameraClient.removeViewfinder();
        activeViewfinder = ViewfinderRegistry.get(camera);
        if (camera instanceof CameraOnStand) {
            Minecrft.options().method_31043(class_5498.field_26664);
        }
    }

    public static void removeViewfinder() {
        if (activeViewfinder != null) {
            activeViewfinder.close();
            activeViewfinder = null;
        }
    }
}

