/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui.screen;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.client.gui.component.CycleButton;
import io.github.mortuusars.exposure.client.gui.screen.LightroomFrameInspectScreen;
import io.github.mortuusars.exposure.client.gui.toast.BetterTutorialToast;
import io.github.mortuusars.exposure.client.gui.toast.ToastIcon;
import io.github.mortuusars.exposure.client.image.modifier.ImageEffect;
import io.github.mortuusars.exposure.client.image.renderable.RenderableImage;
import io.github.mortuusars.exposure.client.input.Key;
import io.github.mortuusars.exposure.client.input.KeyBindings;
import io.github.mortuusars.exposure.client.render.image.RenderCoordinates;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.util.PagingDirection;
import io.github.mortuusars.exposure.world.camera.ExposureType;
import io.github.mortuusars.exposure.world.camera.FilmColor;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.inventory.LightroomMenu;
import io.github.mortuusars.exposure.world.item.DevelopedFilmItem;
import io.github.mortuusars.exposure.world.item.FilmRollItem;
import io.github.mortuusars.exposure.world.lightroom.PrintingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_465;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_757;
import net.minecraft.class_768;
import net.minecraft.class_7919;
import net.minecraft.class_8666;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightroomScreen
extends class_465<LightroomMenu> {
    public static final class_2960 MAIN_TEXTURE = Exposure.resource("textures/gui/lightroom.png");
    public static final class_2960 FILM_OVERLAYS_TEXTURE = Exposure.resource("textures/gui/lightroom_film_overlays.png");
    public static final class_8666 PRINT_BUTTON_SPRITES = new class_8666(Exposure.resource("lightroom/print_button"), Exposure.resource("lightroom/print_button_disabled"), Exposure.resource("lightroom/print_button_highlighted"));
    public static final class_8666 PRINTING_MODE_TOGGLE_REGULAR_SPRITES = new class_8666(Exposure.resource("lightroom/printing_mode_regular"), Exposure.resource("lightroom/printing_mode_regular_highlighted"));
    public static final class_8666 PRINTING_MODE_TOGGLE_CHROMATIC_SPRITES = new class_8666(Exposure.resource("lightroom/printing_mode_chromatic"), Exposure.resource("lightroom/printing_mode_chromatic_highlighted"));
    public static final int FRAME_SIZE = 54;
    protected final KeyBindings keyBindings = KeyBindings.of(Key.press(334).or(Key.press(61)).executes(this::enterFrameInspectMode), Key.press(263).or(Key.press(65)).executes(() -> this.changeFrame(PagingDirection.PREVIOUS)), Key.press(262).or(Key.press(68)).executes(() -> this.changeFrame(PagingDirection.NEXT)));
    protected class_1657 player;
    protected class_4185 printButton;
    protected PrintingMode mode;
    protected CycleButton<PrintingMode> printingModeToggleButton;
    protected Map<Integer, class_768> slotPlaceholders = Collections.emptyMap();
    protected boolean hasShownDevelopingToast;

    public LightroomScreen(LightroomMenu menu, class_1661 playerInventory, class_2561 title) {
        super((class_1703)menu, playerInventory, title);
        this.player = playerInventory.field_7546;
        this.mode = ((LightroomMenu)this.method_17577()).getBlockEntity().getActualPrintingMode();
    }

    protected void method_25426() {
        this.field_2792 = 176;
        this.field_2779 = 209;
        super.method_25426();
        this.field_25270 = 116;
        this.slotPlaceholders = Map.of(0, new class_768(238, 0, 18, 18), 1, new class_768(238, 18, 18, 18), 2, new class_768(238, 36, 18, 18), 3, new class_768(238, 54, 18, 18), 4, new class_768(238, 72, 18, 18), 5, new class_768(238, 90, 18, 18));
        this.printButton = new class_344(this.field_2776 + 117, this.field_2800 + 89, 22, 22, PRINT_BUTTON_SPRITES, button -> {
            int buttonId = class_437.method_25442() && this.player.method_7337() ? 1 : 0;
            this.clickButton(buttonId);
        }, (class_2561)class_2561.method_43471((String)"gui.exposure.lightroom.print"));
        this.updatePrintButtonTooltip();
        this.method_37063((class_364)this.printButton);
        this.printingModeToggleButton = this.createPrintingModeToggleButton();
        this.method_37063((class_364)this.printingModeToggleButton);
        this.updateButtons();
    }

    protected void updatePrintButtonTooltip() {
        class_5250 tooltip = class_2561.method_43471((String)"gui.exposure.lightroom.print");
        if (!((LightroomMenu)this.method_17577()).getBlockEntity().hasSufficientLightLevel()) {
            tooltip.method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"gui.exposure.lightroom.print.not_enough_light_tooltip").method_27692(class_124.field_1061));
        }
        if (this.player.method_7337()) {
            tooltip.method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"gui.exposure.lightroom.print.creative_tooltip"));
        }
        this.printButton.method_47400(class_7919.method_47407((class_2561)tooltip));
    }

    protected CycleButton<PrintingMode> createPrintingModeToggleButton() {
        Map<PrintingMode, class_8666> spritesMap = Map.of(PrintingMode.REGULAR, PRINTING_MODE_TOGGLE_REGULAR_SPRITES, PrintingMode.CHROMATIC, PRINTING_MODE_TOGGLE_CHROMATIC_SPRITES);
        Map<PrintingMode, class_7919> tooltipMap = Map.of(PrintingMode.REGULAR, class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.exposure.lightroom.printing_mode.regular").method_10852(class_5244.field_33849).method_10852((class_2561)class_2561.method_43471((String)"gui.exposure.lightroom.printing_mode.regular.info").method_27692(class_124.field_1080))), PrintingMode.CHROMATIC, class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.exposure.lightroom.printing_mode.chromatic").method_10852(class_5244.field_33849).method_10852((class_2561)class_2561.method_43471((String)"gui.exposure.lightroom.printing_mode.chromatic.info").method_27692(class_124.field_1080))));
        return new CycleButton<PrintingMode>(this.field_2776 - 17, this.field_2800 + 91, 18, 18, Arrays.asList(PrintingMode.values()), ((LightroomMenu)this.method_17577()).getBlockEntity().getActualPrintingMode(), spritesMap, (button, newMode) -> this.clickButton(4)).setClickSound((class_3414)class_3417.field_15015.comp_349()).setTooltips(tooltipMap);
    }

    protected void clickButton(int buttonId) {
        ((LightroomMenu)this.method_17577()).method_7604(this.player, buttonId);
        Minecrft.gameMode().method_2900(((LightroomMenu)this.method_17577()).field_7763, buttonId);
    }

    protected void method_37432() {
        PrintingMode currentMode = ((LightroomMenu)this.method_17577()).getBlockEntity().getActualPrintingMode();
        if (currentMode != this.printingModeToggleButton.getCurrentValue()) {
            this.printingModeToggleButton.setCurrentValue(currentMode);
        }
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.updateButtons();
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    protected void updateButtons() {
        this.printButton.field_22763 = ((LightroomMenu)this.method_17577()).getBlockEntity().canPrint() || this.player.method_7337() && class_437.method_25442() && ((LightroomMenu)this.method_17577()).getBlockEntity().canPrintInCreativeMode();
        this.printButton.field_22764 = !((LightroomMenu)this.method_17577()).isPrinting();
        this.updatePrintButtonTooltip();
        this.printingModeToggleButton.field_22763 = true;
        this.printingModeToggleButton.field_22764 = ((LightroomMenu)this.method_17577()).canChangeProcess();
    }

    protected void method_2389(@NotNull class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        List<Frame> frames;
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.method_25302(MAIN_TEXTURE, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
        guiGraphics.method_25302(MAIN_TEXTURE, this.field_2776 - 27, this.field_2800 + 35, 0, 209, 28, 31);
        this.renderSlotPlaceholders(guiGraphics, mouseX, mouseY, partialTick);
        if (((LightroomMenu)this.method_17577()).isPrinting()) {
            int progress = ((LightroomMenu)this.method_17577()).getData().method_17390(0);
            int time = ((LightroomMenu)this.method_17577()).getData().method_17390(1);
            int width = progress != 0 && time != 0 ? progress * 24 / time : 0;
            guiGraphics.method_25302(MAIN_TEXTURE, this.field_2776 + 116, this.field_2800 + 91, 176, 0, width, 17);
        }
        if ((frames = ((LightroomMenu)this.method_17577()).getExposedFrames()).isEmpty()) {
            guiGraphics.method_25302(FILM_OVERLAYS_TEXTURE, this.field_2776 + 4, this.field_2800 + 15, 0, 136, 168, 68);
            return;
        }
        class_1799 filmStack = ((LightroomMenu)this.method_17577()).method_7611(0).method_7677();
        class_1792 class_17922 = filmStack.method_7909();
        if (!(class_17922 instanceof DevelopedFilmItem)) {
            return;
        }
        DevelopedFilmItem film = (DevelopedFilmItem)class_17922;
        ExposureType exposureType = film.getType();
        FilmColor filmColor = exposureType.getFilmColor();
        int selectedFrame = ((LightroomMenu)this.method_17577()).getSelectedFrame();
        @Nullable Frame leftFrame = ((LightroomMenu)this.method_17577()).getFrameByIndex(selectedFrame - 1);
        @Nullable Frame centerFrame = ((LightroomMenu)this.method_17577()).getFrameByIndex(selectedFrame);
        @Nullable Frame rightFrame = ((LightroomMenu)this.method_17577()).getFrameByIndex(selectedFrame + 1);
        RenderSystem.setShaderColor((float)filmColor.r(), (float)filmColor.g(), (float)filmColor.b(), (float)filmColor.a());
        guiGraphics.method_25302(FILM_OVERLAYS_TEXTURE, this.field_2776 + 1, this.field_2800 + 15, 0, leftFrame != null ? 68 : 0, 54, 68);
        guiGraphics.method_25302(FILM_OVERLAYS_TEXTURE, this.field_2776 + 55, this.field_2800 + 15, 55, rightFrame != null ? 0 : 68, 64, 68);
        if (rightFrame != null) {
            boolean hasMoreFrames = selectedFrame + 2 < frames.size();
            guiGraphics.method_25302(FILM_OVERLAYS_TEXTURE, this.field_2776 + 119, this.field_2800 + 15, 120, hasMoreFrames ? 68 : 0, 56, 68);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_4587 poseStack = guiGraphics.method_51448();
        if (leftFrame != null) {
            this.renderFrame(leftFrame, poseStack, this.field_2776 + 6, this.field_2800 + 22, 54.0f, this.isOverLeftFrame(mouseX, mouseY) ? 0.8f : 0.25f, exposureType);
        }
        if (centerFrame != null) {
            this.renderFrame(centerFrame, poseStack, this.field_2776 + 61, this.field_2800 + 22, 54.0f, 0.9f, exposureType);
        }
        if (rightFrame != null) {
            this.renderFrame(rightFrame, poseStack, this.field_2776 + 116, this.field_2800 + 22, 54.0f, this.isOverRightFrame(mouseX, mouseY) ? 0.8f : 0.25f, exposureType);
        }
        RenderSystem.setShaderColor((float)filmColor.r(), (float)filmColor.g(), (float)filmColor.b(), (float)filmColor.a());
        if (((LightroomMenu)this.method_17577()).getBlockEntity().isAdvancingFrameOnPrint()) {
            poseStack.method_22903();
            poseStack.method_46416(0.0f, 0.0f, 800.0f);
            if (selectedFrame < ((LightroomMenu)this.method_17577()).getTotalFramesCount() - 1) {
                guiGraphics.method_25302(MAIN_TEXTURE, this.field_2776 + 111, this.field_2800 + 44, 200, 0, 10, 10);
            } else {
                guiGraphics.method_25302(MAIN_TEXTURE, this.field_2776 + 111, this.field_2800 + 44, 210, 0, 10, 10);
            }
            poseStack.method_22909();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderSlotPlaceholders(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (int slotIndex : this.slotPlaceholders.keySet()) {
            class_1735 slot = ((LightroomMenu)this.method_17577()).method_7611(slotIndex);
            if (slot.method_7681()) continue;
            class_768 placeholder = this.slotPlaceholders.get(slotIndex);
            guiGraphics.method_25302(MAIN_TEXTURE, this.field_2776 + slot.field_7873 - 1, this.field_2800 + slot.field_7872 - 1, placeholder.method_3321(), placeholder.method_3322(), placeholder.method_3319(), placeholder.method_3320());
        }
    }

    protected void method_2380(@NotNull class_332 guiGraphics, int mouseX, int mouseY) {
        super.method_2380(guiGraphics, mouseX, mouseY);
        boolean advancedTooltips = class_310.method_1551().field_1690.field_1827;
        int selectedFrame = ((LightroomMenu)this.method_17577()).getSelectedFrame();
        ArrayList<class_2561> tooltipLines = new ArrayList<class_2561>();
        int hoveredFrameIndex = -1;
        if (this.isOverLeftFrame(mouseX, mouseY)) {
            hoveredFrameIndex = selectedFrame - 1;
            tooltipLines.add((class_2561)class_2561.method_43471((String)"gui.exposure.lightroom.previous_frame"));
        } else if (this.isOverCenterFrame(mouseX, mouseY)) {
            hoveredFrameIndex = selectedFrame;
            tooltipLines.add((class_2561)class_2561.method_43469((String)"gui.exposure.lightroom.current_frame", (Object[])new Object[]{Integer.toString(((LightroomMenu)this.method_17577()).getSelectedFrame() + 1)}));
        } else if (this.isOverRightFrame(mouseX, mouseY)) {
            hoveredFrameIndex = selectedFrame + 1;
            tooltipLines.add((class_2561)class_2561.method_43471((String)"gui.exposure.lightroom.next_frame"));
        }
        if (hoveredFrameIndex != -1) {
            this.addFrameInfoTooltipLines(tooltipLines, hoveredFrameIndex, advancedTooltips);
        }
        if (this.isOverCenterFrame(mouseX, mouseY)) {
            tooltipLines.add((class_2561)class_2561.method_43471((String)"gui.exposure.lightroom.zoom_in.tooltip"));
        }
        guiGraphics.method_51437(class_310.method_1551().field_1772, tooltipLines, Optional.empty(), mouseX, mouseY);
    }

    private void addFrameInfoTooltipLines(List<class_2561> tooltipLines, int frameIndex, boolean isAdvancedTooltips) {
        @Nullable Frame frame = ((LightroomMenu)this.method_17577()).getFrameByIndex(frameIndex);
        if (frame != null) {
            if (((LightroomMenu)this.method_17577()).getBlockEntity().isRefracted()) {
                frame.getColorChannel().ifPresent(c -> tooltipLines.add((class_2561)class_2561.method_43471((String)("gui.exposure.channel." + c.method_15434())).method_27696(class_2583.field_24360.method_36139(c.getRepresentationColor()))));
            }
            if (isAdvancedTooltips) {
                class_5250 component = frame.identifier().map(id -> !id.isEmpty() ? class_2561.method_43469((String)"gui.exposure.frame.id", (Object[])new Object[]{class_2561.method_43470((String)id).method_27692(class_124.field_1080)}) : class_2561.method_43473(), texture -> class_2561.method_43469((String)"gui.exposure.frame.texture", (Object[])new Object[]{class_2561.method_43470((String)texture.toString()).method_27692(class_124.field_1080)})).method_27692(class_124.field_1063);
                tooltipLines.add((class_2561)component);
            }
        }
    }

    private boolean isOverLeftFrame(int mouseX, int mouseY) {
        List<Frame> frames = ((LightroomMenu)this.method_17577()).getExposedFrames();
        int selectedFrame = ((LightroomMenu)this.method_17577()).getSelectedFrame();
        return selectedFrame - 1 >= 0 && selectedFrame - 1 < frames.size() && this.method_2378(6, 22, 54, 54, mouseX, mouseY);
    }

    private boolean isOverCenterFrame(int mouseX, int mouseY) {
        List<Frame> frames = ((LightroomMenu)this.method_17577()).getExposedFrames();
        int selectedFrame = ((LightroomMenu)this.method_17577()).getSelectedFrame();
        return selectedFrame >= 0 && selectedFrame < frames.size() && this.method_2378(61, 22, 54, 54, mouseX, mouseY);
    }

    private boolean isOverRightFrame(int mouseX, int mouseY) {
        List<Frame> frames = ((LightroomMenu)this.method_17577()).getExposedFrames();
        int selectedFrame = ((LightroomMenu)this.method_17577()).getSelectedFrame();
        return selectedFrame + 1 >= 0 && selectedFrame + 1 < frames.size() && this.method_2378(116, 22, 54, 54, mouseX, mouseY);
    }

    public void renderFrame(@NotNull Frame frame, class_4587 poseStack, float x, float y, float size, float alpha, ExposureType exposureType) {
        RenderableImage image = ExposureClient.renderedExposures().getOrCreate(frame).modifyWith(ImageEffect.NEGATIVE_FILM);
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        ExposureClient.imageRenderer().render(image, poseStack, (class_4597)bufferSource, new RenderCoordinates(x, y, size, size), exposureType.getImageColor().withAlpha((int)(alpha * 255.0f)));
        bufferSource.method_22993();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return this.keyBindings.keyPressed(keyCode, scanCode, modifiers) || super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        return this.keyBindings.keyReleased(keyCode, scanCode, modifiers) || super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean handled = super.method_25401(mouseX, mouseY, scrollX, scrollY);
        if (!handled && scrollY >= 0.0 && this.isOverCenterFrame((int)mouseX, (int)mouseY)) {
            this.enterFrameInspectMode();
        }
        return handled;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            class_1735 filmSlot = ((LightroomMenu)this.method_17577()).method_7611(0);
            if (!this.hasShownDevelopingToast && !filmSlot.method_7681() && this.method_2378(filmSlot.field_7873, filmSlot.field_7872, 16, 16, mouseX, mouseY) && ((LightroomMenu)this.method_17577()).method_34255().method_7909() instanceof FilmRollItem) {
                Minecrft.get().method_1566().method_1999((class_368)new BetterTutorialToast(ToastIcon.HEADS_UP, (class_2561)class_2561.method_43471((String)"gui.exposure.lightroom.toast.develop_film.title"), null, 7000));
                this.hasShownDevelopingToast = true;
            }
            if (this.isOverCenterFrame((int)mouseX, (int)mouseY)) {
                this.enterFrameInspectMode();
                return true;
            }
            if (this.isOverLeftFrame((int)mouseX, (int)mouseY)) {
                this.changeFrame(PagingDirection.PREVIOUS);
                return true;
            }
            if (this.isOverRightFrame((int)mouseX, (int)mouseY)) {
                this.changeFrame(PagingDirection.NEXT);
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void changeFrame(PagingDirection navigation) {
        if (navigation == PagingDirection.PREVIOUS && ((LightroomMenu)this.method_17577()).getSelectedFrame() == 0 || navigation == PagingDirection.NEXT && ((LightroomMenu)this.method_17577()).getSelectedFrame() == ((LightroomMenu)this.method_17577()).getTotalFramesCount() - 1) {
            return;
        }
        Preconditions.checkState((this.field_22787 != null ? 1 : 0) != 0);
        Preconditions.checkState((this.field_22787.field_1724 != null ? 1 : 0) != 0);
        Preconditions.checkState((this.field_22787.field_1761 != null ? 1 : 0) != 0);
        int buttonId = navigation == PagingDirection.NEXT ? 3 : 2;
        this.clickButton(buttonId);
        Minecrft.get().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)Exposure.SoundEvents.CAMERA_LENS_RING_CLICK.get(), (float)1.0f, (float)(ThreadLocalRandom.current().nextFloat() * 0.4f + 0.8f)));
        ((LightroomMenu)this.method_17577()).getBlockEntity().setSelectedFrameIndex(((LightroomMenu)this.method_17577()).getBlockEntity().getSelectedFrameIndex() + (navigation == PagingDirection.NEXT ? 1 : -1));
    }

    private void enterFrameInspectMode() {
        class_310.method_1551().method_1507((class_437)new LightroomFrameInspectScreen(this));
        this.player.method_5783(Exposure.SoundEvents.CAMERA_LENS_RING_CLICK.get(), 1.0f, 1.3f);
    }

    protected boolean method_2381(double mouseX, double mouseY, int guiLeft, int guiTop, int mouseButton) {
        return super.method_2381(mouseX, mouseY, guiLeft, guiTop, mouseButton) && this.field_2787 == null;
    }
}

