/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui.screen.camera;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.client.gui.Widgets;
import io.github.mortuusars.exposure.client.gui.screen.ItemListScreen;
import io.github.mortuusars.exposure.client.gui.screen.element.ToggleImageButton;
import io.github.mortuusars.exposure.client.gui.toast.BetterTutorialToast;
import io.github.mortuusars.exposure.client.gui.toast.ToastIcon;
import io.github.mortuusars.exposure.client.input.KeyboardHandler;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.data.Filter;
import io.github.mortuusars.exposure.data.Filters;
import io.github.mortuusars.exposure.data.Lenses;
import io.github.mortuusars.exposure.util.color.Color;
import io.github.mortuusars.exposure.util.supporter.Supporters;
import io.github.mortuusars.exposure.world.inventory.AbstractCameraAttachmentsMenu;
import io.github.mortuusars.exposure.world.inventory.CameraInHandAttachmentsMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_407;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6880;
import net.minecraft.class_757;
import net.minecraft.class_768;
import net.minecraft.class_7919;
import net.minecraft.class_7923;
import net.minecraft.class_8666;
import org.jetbrains.annotations.NotNull;

public class CameraAttachmentsScreen
extends class_465<AbstractCameraAttachmentsMenu> {
    public static final class_2960 TEXTURE = Exposure.resource("textures/gui/camera_attachments.png");
    public static final class_8666 SKIN_REGULAR_BUTTON_SPRITES = Widgets.threeStateSprites(Exposure.resource("camera_attachments/regular"));
    public static final class_8666 SKIN_GOLD_BUTTON_SPRITES = Widgets.threeStateSprites(Exposure.resource("camera_attachments/gold"));
    protected final class_1657 player;
    protected Map<Integer, class_768> slotPlaceholders = Map.of(0, new class_768(238, 0, 18, 18), 1, new class_768(238, 18, 18, 18), 2, new class_768(238, 36, 18, 18), 3, new class_768(238, 54, 18, 18));
    protected final HoveredElement flash = new HoveredElement(List.of(new class_768(96, 11, 28, 27)), () -> ((AbstractCameraAttachmentsMenu)this.method_17577()).method_7611(1).method_7681());
    protected final HoveredElement filterOnLens = new HoveredElement(List.of(new class_768(114, 57, 13, 6), new class_768(110, 63, 17, 24)), () -> ((AbstractCameraAttachmentsMenu)this.method_17577()).method_7611(2).method_7681());
    protected final HoveredElement lens = new HoveredElement(List.of(new class_768(93, 48, 33, 34)), () -> ((AbstractCameraAttachmentsMenu)this.method_17577()).method_7611(2).method_7681());
    protected final HoveredElement filter = new HoveredElement(List.of(new class_768(110, 55, 13, 6), new class_768(106, 61, 17, 24)), () -> !((AbstractCameraAttachmentsMenu)this.method_17577()).method_7611(2).method_7681());
    protected final HoveredElement lensBuiltIn = new HoveredElement(List.of(new class_768(93, 48, 29, 32)), () -> !((AbstractCameraAttachmentsMenu)this.method_17577()).method_7611(2).method_7681());
    protected final HoveredElement selfTimer = new HoveredElement(List.of(new class_768(92, 77, 6, 7)), () -> true);
    protected final HoveredElement viewfinder = new HoveredElement(List.of(new class_768(65, 25, 30, 12), new class_768(72, 31, 39, 11), new class_768(80, 42, 24, 5)), () -> true);
    protected final HoveredElement film = new HoveredElement(List.of(new class_768(48, 33, 15, 38), new class_768(52, 24, 16, 11)), () -> true);
    protected final HoveredElement shutterSpeedKnob = new HoveredElement(List.of(new class_768(68, 49, 21, 26)), () -> true);
    protected long openedAt = System.currentTimeMillis();
    protected boolean hasHoveredOverPart;

    public CameraAttachmentsScreen(AbstractCameraAttachmentsMenu menu, class_1661 playerInventory, class_2561 title) {
        super((class_1703)menu, playerInventory, title);
        this.player = playerInventory.field_7546;
        this.showTutorialToasts();
    }

    protected void showTutorialToasts() {
        if (((Boolean)Config.Client.ATTACHMENTS_SHOW_INFO_TOAST.get()).booleanValue()) {
            Minecrft.get().method_1566().method_1999((class_368)new BetterTutorialToast(ToastIcon.HOVER, (class_2561)class_2561.method_43471((String)"gui.exposure.camera_attachments.mouse_over_toast.title"), (class_2561)class_2561.method_43471((String)"gui.exposure.camera_attachments.mouse_over_toast.message"), () -> {
                if (Minecrft.get().field_1755 != this) {
                    Config.Client.ATTACHMENTS_SHOW_INFO_TOAST.set((Object)true);
                    Config.Client.SPEC.save();
                    return true;
                }
                return this.hasHoveredOverPart;
            }));
            Config.Client.ATTACHMENTS_SHOW_INFO_TOAST.set((Object)false);
            Config.Client.SPEC.save();
        }
        if (((Boolean)Config.Client.ATTACHMENTS_SHOW_WIKI_TOAST.get()).booleanValue()) {
            Minecrft.get().method_1566().method_1999((class_368)new BetterTutorialToast(ToastIcon.F1, (class_2561)class_2561.method_43471((String)"gui.exposure.camera_attachments.wiki_toast.title"), (class_2561)class_2561.method_43471((String)"gui.exposure.camera_attachments.wiki_toast.message"), 7000, () -> {
                if (Minecrft.get().field_1755 != this && !(Minecrft.get().field_1755 instanceof class_407)) {
                    Config.Client.ATTACHMENTS_SHOW_WIKI_TOAST.set((Object)true);
                    Config.Client.SPEC.save();
                    return true;
                }
                return false;
            }));
            Config.Client.ATTACHMENTS_SHOW_WIKI_TOAST.set((Object)false);
            Config.Client.SPEC.save();
        }
    }

    protected void method_25426() {
        this.field_2779 = 185;
        this.field_25270 = this.field_2779 - 94;
        super.method_25426();
        if (Supporters.hasAccessToGoldenSkin(Minecrft.player().method_5667())) {
            ToggleImageButton button = new ToggleImageButton(this.field_2776 + 8, this.field_2800 + 18, 7, 7, SKIN_GOLD_BUTTON_SPRITES, SKIN_REGULAR_BUTTON_SPRITES, this::changeSkin);
            button.setState(((AbstractCameraAttachmentsMenu)this.method_17577()).getCamera().map((i, s) -> (Boolean)s.method_57825(Exposure.DataComponents.CAMERA_GOLD, (Object)false)));
            button.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.exposure.camera_attachments.change_skin")));
            this.method_37063((class_364)button);
        }
    }

    protected void changeSkin(boolean gold) {
        int buttonId = gold ? 101 : 100;
        Minecrft.gameMode().method_2900(((AbstractCameraAttachmentsMenu)this.method_17577()).field_7763, buttonId);
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        for (class_1735 slot : ((AbstractCameraAttachmentsMenu)this.method_17577()).field_7761) {
            if (slot.method_7674(this.player)) continue;
            guiGraphics.method_51427(slot.method_7677(), this.field_2776 + slot.field_7873, this.field_2800 + slot.field_7872);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            guiGraphics.method_25291(TEXTURE, this.field_2776 + slot.field_7873 - 2, this.field_2800 + slot.field_7872 - 2, 350, 236.0f, 92.0f, 20, 20, 256, 256);
            RenderSystem.disableBlend();
        }
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    protected void method_2389(@NotNull class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.method_25302(TEXTURE, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
        this.renderSlotPlaceholders(guiGraphics, mouseX, mouseY, partialTick);
        this.renderAttachments(guiGraphics, mouseX, mouseY, partialTick);
        for (class_1735 slot : ((AbstractCameraAttachmentsMenu)this.method_17577()).field_7761) {
            if (slot.method_7674(this.player)) continue;
            guiGraphics.method_25302(TEXTURE, this.field_2776 + slot.field_7873 - 2, this.field_2800 + slot.field_7872 - 2, 236, 72, 20, 20);
        }
        RenderSystem.disableBlend();
    }

    protected void renderAttachments(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        int filterY;
        boolean hasLens;
        if (((AbstractCameraAttachmentsMenu)this.method_17577()).method_7611(1).method_7681()) {
            int vOffset = this.isMouseOver(this.flash, mouseX, mouseY) ? 28 : 0;
            guiGraphics.method_25302(TEXTURE, this.field_2776 + 96, this.field_2800 + 11, 176, vOffset, 28, 28);
        }
        if (hasLens = ((AbstractCameraAttachmentsMenu)this.method_17577()).method_7611(2).method_7681()) {
            int vOffset = this.isMouseOver(this.lens, mouseX, mouseY) && !this.isMouseOver(this.filterOnLens, mouseX, mouseY) ? 37 : 0;
            guiGraphics.method_25302(TEXTURE, this.field_2776 + 93, this.field_2800 + 47, 176, 56 + vOffset, 35, 37);
        } else if (this.isMouseOver(this.lensBuiltIn, mouseX, mouseY) && !this.isMouseOver(this.filter, mouseX, mouseY)) {
            guiGraphics.method_25302(TEXTURE, this.field_2776 + 93, this.field_2800 + 47, 176, 130, 31, 35);
        }
        class_1735 filterSlot = ((AbstractCameraAttachmentsMenu)this.method_17577()).method_7611(3);
        int filterX = hasLens ? 102 : 98;
        int n = filterY = hasLens ? 54 : 52;
        if (filterSlot.method_7681()) {
            Filters.of(Minecrft.registryAccess(), filterSlot.method_7677()).ifPresent(filter -> this.renderFilter(guiGraphics, mouseX, mouseY, (Filter)filter, filterX, filterY));
        } else if (this.isMouseOver(this.filterOnLens, mouseX, mouseY)) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            guiGraphics.method_25302(TEXTURE, this.field_2776 + 110, this.field_2800 + 58, 176, 165, 15, 23);
        } else if (this.isMouseOver(this.filter, mouseX, mouseY)) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            guiGraphics.method_25302(TEXTURE, this.field_2776 + 106, this.field_2800 + 56, 176, 165, 15, 23);
        } else if (this.isMouseOver(this.viewfinder, mouseX, mouseY) && !this.isMouseOver(this.flash, mouseX, mouseY)) {
            guiGraphics.method_25302(TEXTURE, this.field_2776 + 65, this.field_2800 + 24, 42, 185, 49, 26);
        } else if (this.isMouseOver(this.film, mouseX, mouseY)) {
            guiGraphics.method_25302(TEXTURE, this.field_2776 + 47, this.field_2800 + 20, 0, 185, 42, 52);
        } else if (this.isMouseOver(this.shutterSpeedKnob, mouseX, mouseY)) {
            guiGraphics.method_25302(TEXTURE, this.field_2776 + 68, this.field_2800 + 49, 148, 185, 21, 26);
        } else if (this.isMouseOver(this.selfTimer, mouseX, mouseY)) {
            guiGraphics.method_25302(TEXTURE, this.field_2776 + 93, this.field_2800 + 78, 169, 185, 4, 5);
        }
    }

    protected void renderFilter(@NotNull class_332 guiGraphics, int mouseX, int mouseY, Filter filter, int filterX, int filterY) {
        Color tint = filter.attachmentTintColor();
        float r = tint.getRF();
        float g = tint.getGF();
        float b = tint.getBF();
        if (this.isMouseOver(this.filterOnLens, mouseX, mouseY) || this.isMouseOver(this.filter, mouseX, mouseY)) {
            r *= 1.35f;
            g *= 1.35f;
            b *= 1.35f;
        }
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        class_2960 filterTexture = filter.attachmentTexture();
        guiGraphics.method_25290(filterTexture, this.field_2776 + filterX, this.field_2800 + filterY, 0.0f, 0.0f, 32, 32, 32, 32);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected boolean isMouseOver(HoveredElement element, int mouseX, int mouseY) {
        if (!element.isEnabled.get().booleanValue()) {
            return false;
        }
        mouseX -= this.field_2776;
        mouseY -= this.field_2800;
        for (class_768 area : element.hoverArea) {
            if (mouseX < area.method_3321() || mouseX >= area.method_3321() + area.method_3319() || mouseY < area.method_3322() || mouseY >= area.method_3322() + area.method_3320()) continue;
            return true;
        }
        return false;
    }

    protected void renderSlotPlaceholders(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (int slotIndex : this.slotPlaceholders.keySet()) {
            class_1735 slot = ((AbstractCameraAttachmentsMenu)this.method_17577()).method_7611(slotIndex);
            if (slot.method_7681()) continue;
            class_768 placeholder = this.slotPlaceholders.get(slotIndex);
            guiGraphics.method_25302(TEXTURE, this.field_2776 + slot.field_7873 - 1, this.field_2800 + slot.field_7872 - 1, placeholder.method_3321(), placeholder.method_3322(), placeholder.method_3319(), placeholder.method_3320());
        }
    }

    protected void method_2380(class_332 guiGraphics, int x, int y) {
        boolean hoveredOverPart = true;
        if (this.isMouseOver(this.flash, x, y)) {
            guiGraphics.method_51447(this.field_22793, this.getTooltipLines((class_2561)this.translate("flash.tooltip")), x, y);
        } else if (this.isMouseOver(this.viewfinder, x, y)) {
            class_5250 controlsKey = this.translateKey(KeyboardHandler.getCameraControlsKey(), class_124.field_1080);
            class_5250 middleClick = (Boolean)Config.Client.VIEWFINDER_MIDDLE_CLICK_CONTROLS.get() != false ? this.translate("viewfinder.tooltip.or_middle_click") : class_2561.method_43473();
            class_5250 selfieKey = this.translateKey(Minecrft.options().field_1824, class_124.field_1080);
            class_5250 sprintKey = this.translateKey(Minecrft.options().field_1867, class_124.field_1080);
            guiGraphics.method_51447(this.field_22793, this.getTooltipLines((class_2561)this.translate("viewfinder.tooltip", controlsKey, middleClick, selfieKey, sprintKey)), x, y);
        } else if (this.isMouseOver(this.shutterSpeedKnob, x, y)) {
            guiGraphics.method_51447(this.field_22793, this.getTooltipLines((class_2561)this.translate("shutter_speed.tooltip")), x, y);
        } else if (this.isMouseOver(this.filter, x, y) || this.isMouseOver(this.filterOnLens, x, y)) {
            guiGraphics.method_51447(this.field_22793, this.getTooltipLines((class_2561)this.translate("filter.tooltip")), x, y);
        } else if (this.isMouseOver(this.lens, x, y) || this.isMouseOver(this.lensBuiltIn, x, y)) {
            guiGraphics.method_51447(this.field_22793, this.getTooltipLines((class_2561)this.translate("lens.tooltip")), x, y);
        } else if (this.isMouseOver(this.film, x, y)) {
            guiGraphics.method_51447(this.field_22793, this.getTooltipLines((class_2561)this.translate("film.tooltip")), x, y);
        } else if (this.isMouseOver(this.selfTimer, x, y)) {
            class_5250 tooltip = this.translate("self_timer.tooltip");
            if (((Boolean)Config.Server.TIMER_ATTRACTS_MOB_ATTENTION.get()).booleanValue()) {
                tooltip.method_10852((class_2561)this.translate("self_timer_attention.tooltip"));
            }
            guiGraphics.method_51447(this.field_22793, this.getTooltipLines((class_2561)tooltip), x, y);
        } else {
            hoveredOverPart = false;
            super.method_2380(guiGraphics, x, y);
        }
        if (!this.hasHoveredOverPart && hoveredOverPart && System.currentTimeMillis() - this.openedAt > 3000L) {
            this.hasHoveredOverPart = true;
        }
    }

    @NotNull
    public List<class_2561> method_51454(class_1799 stack) {
        List tooltip = super.method_51454(stack);
        Lenses.getFocalRange(Minecrft.registryAccess(), stack).ifPresent(focalRange -> tooltip.add(class_2561.method_43469((String)"gui.exposure.camera_controls.focal_range", (Object[])new Object[]{focalRange.method_15434()}).method_27692(class_124.field_1065)));
        Filters.of(Minecrft.registryAccess(), stack).filter(f -> Minecrft.options().field_1827).ifPresent(filter -> tooltip.add(class_2561.method_43470((String)filter.shader().toString()).method_27692(class_124.field_1080)));
        return tooltip;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 290) {
            String url = "https://moddedmc.wiki/project/exposure";
            Minecrft.get().method_1507((class_437)new class_407(confirmed -> {
                if (confirmed) {
                    class_156.method_668().method_670(url);
                }
                Minecrft.get().method_1507((class_437)this);
            }, "https://moddedmc.wiki/project/exposure", true));
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int x = (int)mouseX;
        int y = (int)mouseY;
        if (this.isMouseOver(this.filter, x, y) || this.isMouseOver(this.filterOnLens, x, y)) {
            ArrayList<class_1799> itemStacks = new ArrayList<class_1799>();
            for (class_6880 holder : class_7923.field_41178.method_40286(Exposure.Tags.Items.FILTERS)) {
                itemStacks.add(new class_1799(holder));
            }
            ItemListScreen screen = new ItemListScreen((class_437)this, (class_2561)class_2561.method_43471((String)"gui.exposure.filters"), itemStacks);
            class_310.method_1551().method_1507((class_437)screen);
            return true;
        }
        if (this.isMouseOver(this.lens, x, y) || this.isMouseOver(this.lensBuiltIn, x, y)) {
            ArrayList<class_1799> itemStacks = new ArrayList<class_1799>();
            for (class_6880 holder : class_7923.field_41178.method_40286(Exposure.Tags.Items.LENSES)) {
                itemStacks.add(new class_1799(holder));
            }
            Object screen = new ItemListScreen((class_437)this, (class_2561)class_2561.method_43471((String)"gui.exposure.lenses"), itemStacks);
            Minecrft.get().method_1507(screen);
            return true;
        }
        if (this.isMouseOver(this.film, x, y)) {
            ArrayList<class_1799> itemStacks = new ArrayList<class_1799>();
            for (class_6880 holder : class_7923.field_41178.method_40286(Exposure.Tags.Items.FILM_ROLLS)) {
                itemStacks.add(new class_1799(holder));
            }
            Object screen = new ItemListScreen((class_437)this, (class_2561)class_2561.method_43471((String)"gui.exposure.film_rolls"), itemStacks);
            Minecrft.get().method_1507(screen);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25419() {
        CameraInHandAttachmentsMenu attachmentsMenu;
        super.method_25419();
        class_1703 class_17032 = this.method_17577();
        if (class_17032 instanceof CameraInHandAttachmentsMenu && (attachmentsMenu = (CameraInHandAttachmentsMenu)class_17032).isOpenedFromGui()) {
            Minecrft.get().method_1507((class_437)new class_490(this.player));
        }
    }

    protected class_5250 translate(String key) {
        return class_2561.method_43471((String)("gui.exposure.camera_attachments." + key));
    }

    protected class_5250 translate(String key, Object ... args) {
        return class_2561.method_43469((String)("gui.exposure.camera_attachments." + key), (Object[])args);
    }

    protected class_5250 translate(String key, class_124 formatting) {
        return class_2561.method_43471((String)("gui.exposure.camera_attachments." + key)).method_27692(formatting);
    }

    protected class_5250 translateKey(class_304 mapping, class_124 formatting) {
        return class_2561.method_43470((String)mapping.method_16007().getString()).method_27692(formatting);
    }

    protected List<class_5481> getTooltipLines(class_2561 component, int width) {
        return this.field_22793.method_1728((class_5348)component, width);
    }

    protected List<class_5481> getTooltipLines(class_2561 component) {
        return this.field_22793.method_1728((class_5348)component, this.getMaxTooltipWidth());
    }

    protected int getMaxTooltipWidth() {
        return 250;
    }

    public record HoveredElement(List<class_768> hoverArea, Supplier<Boolean> isEnabled) {
    }
}

