/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.fabric;

import fuzs.forgeconfigapiport.fabric.api.neoforge.v4.client.ConfigScreenFactoryRegistry;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.client.gui.screen.ItemRenameScreen;
import io.github.mortuusars.exposure.client.gui.screen.LightroomScreen;
import io.github.mortuusars.exposure.client.gui.screen.album.AlbumScreen;
import io.github.mortuusars.exposure.client.gui.screen.album.LecternAlbumScreen;
import io.github.mortuusars.exposure.client.gui.screen.camera.CameraAttachmentsScreen;
import io.github.mortuusars.exposure.client.gui.tooltip.CameraStandTooltip;
import io.github.mortuusars.exposure.client.gui.tooltip.PhotographClientTooltip;
import io.github.mortuusars.exposure.client.input.KeyboardHandler;
import io.github.mortuusars.exposure.client.render.CameraStandEntityRenderer;
import io.github.mortuusars.exposure.client.render.GlassPhotographFrameEntityRenderer;
import io.github.mortuusars.exposure.client.render.PhotographFrameEntityRenderer;
import io.github.mortuusars.exposure.fabric.resources.ExposureFabricClientReloadListener;
import io.github.mortuusars.exposure.integration.ModCompatibilityClient;
import io.github.mortuusars.exposure.network.fabric.FabricS2CPacketHandler;
import io.github.mortuusars.exposure.world.inventory.tooltip.PhotographTooltip;
import io.github.mortuusars.exposure.world.item.camera.CameraItem;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.TooltipComponentCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3929;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;

public class ExposureFabricClient
implements ClientModInitializer {
    public void onInitializeClient() {
        ExposureClient.init();
        ConfigScreenFactoryRegistry.INSTANCE.register("exposure", ConfigurationScreen::new);
        ColorProviderRegistry.ITEM.register(CameraItem::getGlassTintColor, (Object[])new class_1935[]{(class_1935)Exposure.Items.CAMERA.get()});
        KeyboardHandler.registerKeymappings(KeyBindingHelper::registerKeyBinding);
        class_3929.method_17542(Exposure.MenuTypes.CAMERA_IN_HAND.get(), CameraAttachmentsScreen::new);
        class_3929.method_17542(Exposure.MenuTypes.CAMERA_ON_STAND.get(), CameraAttachmentsScreen::new);
        class_3929.method_17542(Exposure.MenuTypes.ALBUM.get(), AlbumScreen::new);
        class_3929.method_17542(Exposure.MenuTypes.LECTERN_ALBUM.get(), LecternAlbumScreen::new);
        class_3929.method_17542(Exposure.MenuTypes.LIGHTROOM.get(), LightroomScreen::new);
        class_3929.method_17542(Exposure.MenuTypes.ITEM_RENAME.get(), ItemRenameScreen::new);
        ModelLoadingPlugin.register(pluginContext -> ExposureClient.Models.MODELS.forEach(model -> pluginContext.addModels(new class_2960[]{model.comp_2875()})));
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new ExposureFabricClientReloadListener());
        EntityRendererRegistry.register(Exposure.EntityTypes.PHOTOGRAPH_FRAME.get(), PhotographFrameEntityRenderer::new);
        EntityRendererRegistry.register(Exposure.EntityTypes.CLEAR_PHOTOGRAPH_FRAME.get(), GlassPhotographFrameEntityRenderer::new);
        EntityRendererRegistry.register(Exposure.EntityTypes.CAMERA_STAND.get(), CameraStandEntityRenderer::new);
        TooltipComponentCallback.EVENT.register(data -> {
            PhotographClientTooltip photographClientTooltip;
            if (data instanceof PhotographTooltip) {
                PhotographTooltip photographTooltip = (PhotographTooltip)data;
                photographClientTooltip = new PhotographClientTooltip(photographTooltip);
            } else {
                photographClientTooltip = null;
            }
            return photographClientTooltip;
        });
        HudRenderCallback.EVENT.register(CameraStandTooltip::render);
        FabricS2CPacketHandler.register();
        ModCompatibilityClient.handle();
    }
}

