/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.util.cycles.task;

import io.github.mortuusars.exposure.util.cycles.task.NestedTask;
import io.github.mortuusars.exposure.util.cycles.task.Task;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;

public class TimeoutTask<T>
extends NestedTask<T> {
    private final int timeout;
    private final TimeUnit timeUnit;
    private final T valueIfTimedOut;

    public TimeoutTask(Task<T> task, int timeout, TimeUnit timeUnit, @Nullable T valueIfTimedOut) {
        super(task);
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.valueIfTimedOut = valueIfTimedOut;
    }

    public TimeoutTask(Task<T> task, int timeout, TimeUnit timeUnit) {
        super(task);
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.valueIfTimedOut = null;
    }

    @Override
    public CompletableFuture<T> execute() {
        return this.valueIfTimedOut != null ? this.getTask().execute().completeOnTimeout(this.valueIfTimedOut, this.timeout, this.timeUnit) : this.getTask().execute().orTimeout(this.timeout, this.timeUnit);
    }
}

