/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.inventory;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.world.block.entity.LightroomBlockEntity;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.item.DevelopedFilmItem;
import io.github.mortuusars.exposure.world.item.FilmItem;
import io.github.mortuusars.exposure.world.lightroom.PrintingMode;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import net.minecraft.class_3919;
import net.minecraft.class_9129;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightroomMenu
extends class_1703 {
    public static final int PRINT_BUTTON_ID = 0;
    public static final int PRINT_CREATIVE_BUTTON_ID = 1;
    public static final int PREVIOUS_FRAME_BUTTON_ID = 2;
    public static final int NEXT_FRAME_BUTTON_ID = 3;
    public static final int TOGGLE_PROCESS_BUTTON_ID = 4;
    private final LightroomBlockEntity lightroomBlockEntity;
    private final class_3913 data;
    private List<Frame> frames = Collections.emptyList();

    public LightroomMenu(int containerId, final class_1661 playerInventory, final LightroomBlockEntity blockEntity, class_3913 containerData) {
        super(Exposure.MenuTypes.LIGHTROOM.get(), containerId);
        this.lightroomBlockEntity = blockEntity;
        this.data = containerData;
        this.method_7621(new class_1735((class_1263)blockEntity, 0, -20, 42){

            public boolean method_7680(class_1799 stack) {
                return blockEntity.isItemValidForSlot(0, stack);
            }

            public void method_7668() {
                class_1792 class_17922 = this.method_7677().method_7909();
                if (class_17922 instanceof DevelopedFilmItem) {
                    DevelopedFilmItem developedFilm = (DevelopedFilmItem)class_17922;
                    v0 = developedFilm.getStoredFrames(this.method_7677());
                } else {
                    v0 = LightroomMenu.this.frames = Collections.emptyList();
                }
                if (LightroomMenu.this.lightroomBlockEntity.method_10997() != null && !LightroomMenu.this.lightroomBlockEntity.method_10997().field_9236) {
                    LightroomMenu.this.data.method_17391(2, 0);
                }
                super.method_7668();
            }
        });
        this.method_7621(new class_1735(this, (class_1263)blockEntity, 1, 8, 92){

            public boolean method_7680(class_1799 stack) {
                return blockEntity.isItemValidForSlot(1, stack);
            }
        });
        this.method_7621(new class_1735(this, (class_1263)blockEntity, 2, 42, 92){

            public boolean method_7680(class_1799 stack) {
                return blockEntity.isItemValidForSlot(2, stack);
            }
        });
        this.method_7621(new class_1735(this, (class_1263)blockEntity, 3, 60, 92){

            public boolean method_7680(class_1799 stack) {
                return blockEntity.isItemValidForSlot(3, stack);
            }
        });
        this.method_7621(new class_1735(this, (class_1263)blockEntity, 4, 78, 92){

            public boolean method_7680(class_1799 stack) {
                return blockEntity.isItemValidForSlot(4, stack);
            }
        });
        this.method_7621(new class_1735(this, (class_1263)blockEntity, 5, 96, 92){

            public boolean method_7680(class_1799 stack) {
                return blockEntity.isItemValidForSlot(5, stack);
            }
        });
        this.method_7621(new class_1735(this, (class_1263)blockEntity, 6, 148, 92){

            public boolean method_7680(@NotNull class_1799 stack) {
                return false;
            }

            public void method_7667(@NotNull class_1657 player, @NotNull class_1799 pStack) {
                super.method_7667(player, pStack);
                blockEntity.dropStoredExperience(player);
            }

            public void method_7670(@NotNull class_1799 oldStackIn, @NotNull class_1799 newStackIn) {
                super.method_7670(oldStackIn, newStackIn);
                blockEntity.dropStoredExperience(playerInventory.field_7546);
            }
        });
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.method_7621(new class_1735((class_1263)playerInventory, column + row * 9 + 9, 8 + column * 18, 127 + row * 18));
            }
        }
        for (int index = 0; index < 9; ++index) {
            this.method_7621(new class_1735((class_1263)playerInventory, index, 8 + index * 18, 185));
        }
        this.method_17360(this.data);
    }

    public static LightroomMenu fromBuffer(int containerId, class_1661 playerInventory, class_9129 buffer) {
        return new LightroomMenu(containerId, playerInventory, LightroomMenu.getBlockEntity(playerInventory, (class_2540)buffer), (class_3913)new class_3919(3));
    }

    public LightroomBlockEntity getBlockEntity() {
        return this.lightroomBlockEntity;
    }

    public class_3913 getData() {
        return this.data;
    }

    public List<Frame> getExposedFrames() {
        return this.frames;
    }

    @Nullable
    public Frame getFrameByIndex(int index) {
        return index >= 0 && index < this.getExposedFrames().size() ? this.getExposedFrames().get(index) : null;
    }

    public int getSelectedFrame() {
        return this.data.method_17390(2);
    }

    public boolean isPrinting() {
        return this.data.method_17390(1) > 0;
    }

    public int getTotalFramesCount() {
        int n;
        class_1792 class_17922;
        class_1799 filmStack = this.getBlockEntity().method_5438(0);
        if (!filmStack.method_7960() && (class_17922 = filmStack.method_7909()) instanceof FilmItem) {
            FilmItem filmItem = (FilmItem)class_17922;
            n = filmItem.getStoredFramesCount(filmStack);
        } else {
            n = 0;
        }
        return n;
    }

    public boolean canChangeProcess() {
        return this.getBlockEntity().isRefracted();
    }

    public boolean method_7604(class_1657 player, int buttonId) {
        if (buttonId == 0) {
            if (!player.method_37908().method_8608()) {
                this.getBlockEntity().startPrintingProcess(false);
            }
            return true;
        }
        if (buttonId == 1) {
            if (player.method_7337() && !player.method_37908().method_8608()) {
                this.getBlockEntity().printFrameInCreative();
            }
            return true;
        }
        if (buttonId == 2 || buttonId == 3) {
            int framesCount = this.getTotalFramesCount();
            if (framesCount > 0 && !player.method_37908().method_8608()) {
                int selectedFrame = this.data.method_17390(2);
                int change = buttonId == 3 ? 1 : -1;
                selectedFrame += change;
                selectedFrame = class_3532.method_15340((int)selectedFrame, (int)0, (int)(framesCount - 1));
                this.data.method_17391(2, selectedFrame);
            }
            return true;
        }
        if (buttonId == 4) {
            PrintingMode currentProcess = this.getBlockEntity().getActualPrintingMode();
            this.getBlockEntity().setPrintMode(currentProcess.cycle());
            return true;
        }
        return false;
    }

    @NotNull
    public class_1799 method_7601(@NotNull class_1657 player, int index) {
        class_1735 slot = (class_1735)this.field_7761.get(index);
        class_1799 clickedStack = slot.method_7677();
        class_1799 returnedStack = clickedStack.method_7972();
        if (index < 7) {
            if (!this.method_7616(clickedStack, 7, this.field_7761.size(), true)) {
                return class_1799.field_8037;
            }
            if (index == 6) {
                slot.method_7670(clickedStack, returnedStack);
            }
        } else if (index < this.field_7761.size() && !this.method_7616(clickedStack, 0, 7, false)) {
            return class_1799.field_8037;
        }
        if (clickedStack.method_7960()) {
            slot.method_7673(class_1799.field_8037);
        } else {
            slot.method_7668();
        }
        return returnedStack;
    }

    protected boolean method_7616(class_1799 movedStack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean hasRemainder = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (movedStack.method_7946()) {
            while (!movedStack.method_7960() && !(reverseDirection ? i < startIndex : i >= endIndex)) {
                class_1735 slot = (class_1735)this.field_7761.get(i);
                class_1799 slotStack = slot.method_7677();
                if (!slotStack.method_7960() && class_1799.method_31577((class_1799)movedStack, (class_1799)slotStack)) {
                    int maxSize;
                    int j = slotStack.method_7947() + movedStack.method_7947();
                    if (j <= (maxSize = Math.min(slot.method_7675(), movedStack.method_7914()))) {
                        movedStack.method_7939(0);
                        slotStack.method_7939(j);
                        slot.method_7668();
                        hasRemainder = true;
                    } else if (slotStack.method_7947() < maxSize) {
                        movedStack.method_7934(maxSize - slotStack.method_7947());
                        slotStack.method_7939(maxSize);
                        slot.method_7668();
                        hasRemainder = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!movedStack.method_7960()) {
            int n = i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(reverseDirection ? i < startIndex : i >= endIndex)) {
                class_1735 slot1 = (class_1735)this.field_7761.get(i);
                class_1799 itemmovedStack1 = slot1.method_7677();
                if (itemmovedStack1.method_7960() && slot1.method_7680(movedStack)) {
                    if (movedStack.method_7947() > slot1.method_7675()) {
                        slot1.method_53512(movedStack.method_7971(slot1.method_7675()));
                    } else {
                        slot1.method_53512(movedStack.method_7971(movedStack.method_7947()));
                    }
                    slot1.method_7668();
                    hasRemainder = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return hasRemainder;
    }

    public boolean method_7597(@NotNull class_1657 player) {
        return this.lightroomBlockEntity.method_5443(player);
    }

    private static LightroomBlockEntity getBlockEntity(class_1661 playerInventory, class_2540 data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        class_2586 blockEntityAtPos = playerInventory.field_7546.method_37908().method_8321(data.method_10811());
        if (blockEntityAtPos instanceof LightroomBlockEntity) {
            LightroomBlockEntity blockEntity = (LightroomBlockEntity)blockEntityAtPos;
            return blockEntity;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(blockEntityAtPos));
    }
}

