/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item.component.album;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.exposure.world.item.component.album.AlbumPage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record AlbumContent(List<AlbumPage> pages) {
    public static final int MAX_PAGES = 16;
    public static final Codec<AlbumContent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)AlbumPage.CODEC.sizeLimitedListOf(16).fieldOf("pages").forGetter(AlbumContent::pages)).apply((Applicative)instance, AlbumContent::new));
    public static final class_9139<class_9129, AlbumContent> STREAM_CODEC = class_9139.method_56434((class_9139)AlbumPage.STREAM_CODEC.method_56433(class_9135.method_58000((int)16)), AlbumContent::pages, AlbumContent::new);
    public static final AlbumContent EMPTY = new AlbumContent(Collections.emptyList());

    public AlbumContent {
        Preconditions.checkArgument((pages.size() <= 16 ? 1 : 0) != 0, (Object)"Too many pages for album. Max is 16");
    }

    public Optional<AlbumPage> getPage(int index) {
        return index < this.pages.size() ? Optional.ofNullable(this.pages.get(index)) : Optional.empty();
    }

    public boolean isEmpty() {
        return this.equals(EMPTY) || this.pages.stream().allMatch(AlbumPage::isEmpty);
    }

    public AlbumContent removeTrailingPages() {
        AlbumPage page;
        ArrayList<AlbumPage> pages = new ArrayList<AlbumPage>(this.pages);
        for (int i = pages.size() - 1; i >= 0 && (page = pages.get(i)).isEmpty(); --i) {
            pages.remove(i);
        }
        return new AlbumContent(pages);
    }

    public Mutable toMutable() {
        return new Mutable(this);
    }

    public static class Mutable {
        private final ArrayList<AlbumPage> pages;

        public Mutable(AlbumContent content) {
            this.pages = new ArrayList<AlbumPage>(content.pages);
            while (this.pages.size() < 16) {
                this.pages.add(AlbumPage.EMPTY);
            }
        }

        public Mutable setPage(int index, AlbumPage page) {
            Preconditions.checkElementIndex((int)index, (int)16);
            this.pages.set(index, page);
            return this;
        }

        public AlbumContent toImmutable() {
            return new AlbumContent(this.pages);
        }
    }
}

