/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item.crafting.recipe.serializer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.exposure.world.item.crafting.recipe.ComponentTransferringRecipe;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2371;
import net.minecraft.class_3955;
import net.minecraft.class_7710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class ComponentTransferringRecipeSerializer<T extends ComponentTransferringRecipe>
implements class_1865<T> {
    private final MapCodec<T> codec;
    private final class_9139<class_9129, T> streamCodec;

    public ComponentTransferringRecipeSerializer(String recipeName, String sourceName, RecipeConstructor<T> constructor) {
        this.codec = this.createCodec(recipeName, sourceName, constructor);
        this.streamCodec = this.createStreamCodec(constructor);
    }

    public ComponentTransferringRecipeSerializer(String serializedSourceIngredientName, RecipeConstructor<T> constructor) {
        this("component_transferring", serializedSourceIngredientName, constructor);
    }

    public ComponentTransferringRecipeSerializer(RecipeConstructor<T> constructor) {
        this("component_transferring", "source_ingredient", constructor);
    }

    @NotNull
    protected MapCodec<T> createCodec(String recipeTypeName, String sourceIngredientName, RecipeConstructor<T> constructor) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7710.field_40252.fieldOf("category").orElse((Object)class_7710.field_40251).forGetter(class_3955::method_45441), (App)class_1856.field_46096.fieldOf(sourceIngredientName).forGetter(ComponentTransferringRecipe::getSourceIngredient), (App)class_1856.field_46096.listOf().fieldOf("ingredients").flatXmap(list -> {
            if (list.isEmpty()) {
                return DataResult.error(() -> "No ingredients for %s recipe".formatted(recipeTypeName));
            }
            return list.size() > 9 ? DataResult.error(() -> "Too many ingredients for %s recipe. Maximum is: %s".formatted(9, recipeTypeName)) : DataResult.success((Object)class_2371.method_10212((Object)class_1856.field_9017, (Object[])list.toArray(new class_1856[0])));
        }, DataResult::success).forGetter(ComponentTransferringRecipe::method_8117), (App)class_1799.field_51397.fieldOf("result").forGetter(ComponentTransferringRecipe::getResult)).apply((Applicative)instance, constructor::create));
    }

    @NotNull
    protected class_9139<class_9129, T> createStreamCodec(RecipeConstructor<T> constructor) {
        return class_9139.method_56905((class_9139)class_7710.field_48353, class_3955::method_45441, (class_9139)class_1856.field_48355, ComponentTransferringRecipe::getSourceIngredient, (class_9139)class_9135.method_56376(class_2371::method_37434, (class_9139)class_1856.field_48355), ComponentTransferringRecipe::method_8117, (class_9139)class_1799.field_48349, ComponentTransferringRecipe::getResult, constructor::create);
    }

    @NotNull
    public MapCodec<T> method_53736() {
        return this.codec;
    }

    @NotNull
    public class_9139<class_9129, T> method_56104() {
        return this.streamCodec;
    }

    @FunctionalInterface
    public static interface RecipeConstructor<T extends ComponentTransferringRecipe> {
        public T create(class_7710 var1, class_1856 var2, class_2371<class_1856> var3, class_1799 var4);
    }
}

