/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.level.storage;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_4844;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class ExposureFrameHistory
extends class_18 {
    public static final Codec<ExposureFrameHistory> CODEC = Codec.unboundedMap((Codec)class_4844.field_41525, (Codec)Codec.list(Frame.CODEC)).stable().xmap(ExposureFrameHistory::new, ExposureFrameHistory::getFrames);
    public static final int LIMIT = 32;
    private final Map<UUID, List<Frame>> frames;

    public ExposureFrameHistory(Map<UUID, List<Frame>> frames) {
        this.frames = new HashMap<UUID, List<Frame>>(frames);
    }

    public Map<UUID, List<Frame>> getFrames() {
        return this.frames;
    }

    public List<Frame> getFramesOf(class_1297 entity) {
        return this.getFramesOf(entity.method_5667());
    }

    public List<Frame> getFramesOf(UUID uuid) {
        return this.frames.getOrDefault(uuid, Collections.emptyList());
    }

    public void add(class_1297 entity, Frame frame) {
        this.add(entity.method_5667(), frame);
    }

    public void add(UUID uuid, Frame frame) {
        List list = this.frames.compute(uuid, (id, framesList) -> framesList == null ? new ArrayList() : new ArrayList(framesList));
        while (list.size() >= 32) {
            list.removeFirst();
        }
        list.add(frame);
        this.method_80();
    }

    public void clear() {
        this.frames.clear();
    }

    public void clearOf(class_1297 entity) {
        this.frames.remove(entity.method_5667());
    }

    @NotNull
    public class_2487 method_75(class_2487 tag, class_7225.class_7874 registries) {
        DataResult encodingResult = CODEC.encode((Object)this, (DynamicOps)class_2509.field_11560, (Object)tag);
        if (encodingResult.isSuccess()) {
            class_2520 encodedTag = (class_2520)encodingResult.getOrThrow();
            if (encodedTag instanceof class_2487) {
                class_2487 encodedCompoundTag = (class_2487)encodedTag;
                return encodedCompoundTag;
            }
            Exposure.LOGGER.error("Cannot save FramesHistory: '{}'. Encoded tag is not CompoundTag but a {}", (Object)this, (Object)encodedTag.method_23258());
        }
        encodingResult.error().ifPresent(error -> Exposure.LOGGER.error("Cannot save FramesHistory: {}", (Object)error.message()));
        return tag;
    }

    public static class_18.class_8645<ExposureFrameHistory> factory() {
        return new class_18.class_8645(() -> new ExposureFrameHistory(new HashMap<UUID, List<Frame>>()), ExposureFrameHistory::load, null);
    }

    public static ExposureFrameHistory load(class_2487 tag, class_7225.class_7874 levelRegistry) {
        return (ExposureFrameHistory)((Object)((Pair)CODEC.decode((DynamicOps)class_2509.field_11560, (Object)tag).getOrThrow()).getFirst());
    }

    @NotNull
    public static ExposureFrameHistory loadOrCreate(MinecraftServer server) {
        return (ExposureFrameHistory)server.method_30002().method_17983().method_17924(ExposureFrameHistory.factory(), "exposure_frame_history");
    }
}

