/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.level.storage;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.client.ExposureRequester;
import io.github.mortuusars.exposure.world.level.storage.ExposureData;
import io.github.mortuusars.exposure.world.level.storage.RequestedExposureStatus;
import java.lang.runtime.SwitchBootstraps;
import java.util.Optional;
import net.minecraft.class_2540;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class RequestedPalettedExposure {
    public static final RequestedPalettedExposure NOT_REQUESTED = RequestedPalettedExposure.status(RequestedExposureStatus.NOT_REQUESTED);
    public static final RequestedPalettedExposure AWAITING = RequestedPalettedExposure.status(RequestedExposureStatus.AWAITED);
    public static final RequestedPalettedExposure TIMED_OUT = RequestedPalettedExposure.status(RequestedExposureStatus.TIMED_OUT);
    public static final RequestedPalettedExposure INVALID_ID = RequestedPalettedExposure.status(RequestedExposureStatus.INVALID_ID);
    public static final RequestedPalettedExposure NOT_FOUND = RequestedPalettedExposure.status(RequestedExposureStatus.NOT_FOUND);
    public static final RequestedPalettedExposure CANNOT_LOAD = RequestedPalettedExposure.status(RequestedExposureStatus.CANNOT_LOAD);
    public static final class_9139<class_2540, RequestedPalettedExposure> STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.method_56382(ExposureData.STREAM_CODEC), RequestedPalettedExposure::getData, RequestedExposureStatus.STREAM_CODEC, RequestedPalettedExposure::getStatus, RequestedPalettedExposure::fromOptional);
    @Nullable
    protected final ExposureData exposure;
    protected final RequestedExposureStatus status;

    protected RequestedPalettedExposure(@Nullable ExposureData exposure, RequestedExposureStatus status) {
        this.exposure = exposure;
        this.status = status;
    }

    private static RequestedPalettedExposure fromOptional(Optional<ExposureData> data, RequestedExposureStatus status) {
        return new RequestedPalettedExposure(data.orElse(null), status);
    }

    private static RequestedPalettedExposure status(RequestedExposureStatus status) {
        Preconditions.checkArgument((status != RequestedExposureStatus.SUCCESS && status != RequestedExposureStatus.NEEDS_REFRESH ? 1 : 0) != 0, (Object)"Successful result cannot be created without data.");
        return new RequestedPalettedExposure(null, status);
    }

    public static RequestedPalettedExposure success(ExposureData data) {
        Preconditions.checkNotNull((Object)((Object)data), (Object)"Successful result cannot be created without data.");
        if (data.equals((Object)ExposureData.EMPTY)) {
            Exposure.LOGGER.warn("ExposureData.EMPTY is used to create successful ExposureResult. This is probably not intentional.");
        }
        return new RequestedPalettedExposure(data, RequestedExposureStatus.SUCCESS);
    }

    public static RequestedPalettedExposure needsRefresh(RequestedPalettedExposure result) {
        Preconditions.checkArgument((boolean)result.is(RequestedExposureStatus.SUCCESS));
        return new RequestedPalettedExposure(result.exposure, RequestedExposureStatus.NEEDS_REFRESH);
    }

    public static RequestedPalettedExposure fromRequestStatus(ExposureRequester.Status status) {
        ExposureRequester.Status status2 = status;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"AWAITING", "TIMED_OUT"}, (ExposureRequester.Status)status2, n)) {
            case 0 -> AWAITING;
            case 1 -> TIMED_OUT;
            default -> throw new IllegalArgumentException(String.valueOf((Object)status) + " is unexpected.");
        };
    }

    public Optional<ExposureData> getData() {
        return Optional.ofNullable(this.exposure);
    }

    public <T> T map(Function<ExposureData, T> ifPresent, T orElse) {
        return (T)(this.exposure != null ? ifPresent.apply((Object)this.exposure) : orElse);
    }

    public ExposureData orElse(ExposureData orElse) {
        return this.exposure != null ? this.exposure : orElse;
    }

    public RequestedExposureStatus getStatus() {
        return this.status;
    }

    public boolean is(RequestedExposureStatus status) {
        return this.status.equals((Object)status);
    }

    public boolean isError() {
        return this.status != RequestedExposureStatus.SUCCESS && this.status != RequestedExposureStatus.NEEDS_REFRESH && this.status != RequestedExposureStatus.AWAITED && this.status != RequestedExposureStatus.NOT_REQUESTED;
    }
}

