/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.structures.plants;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2381;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3341;
import net.minecraft.class_3532;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.blocks.BlockPlantWall;
import org.betterx.betternether.noise.OpenSimplexNoise;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.features.AnchorTreeFeature;
import org.betterx.betternether.world.structures.IStructure;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;

public class LegacyStructureAnchorTree
implements IStructure {
    protected static final OpenSimplexNoise NOISE = new OpenSimplexNoise(2145L);

    @Override
    public void generate(class_5425 world, class_2338 pos, class_5819 random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        if (this.canGenerate(pos)) {
            this.grow(world, pos, pos.method_10087(BlocksHelper.downRay((class_1936)world, pos, MAX_HEIGHT)), random, MAX_HEIGHT, context);
        }
    }

    private boolean canGenerate(class_2338 pos) {
        return (pos.method_10263() & 0xF) == 7 && (pos.method_10260() & 0xF) == 7;
    }

    private void grow(class_5425 level, class_2338 up, class_2338 down, class_5819 random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        float scale_factor = (float)MAX_HEIGHT / 128.0f;
        int HEIGHT_64 = (int)((double)MAX_HEIGHT / 2.0 + (double)MHelper.nextFloat(random, 10.0f * scale_factor));
        int HEIGHT_45 = (int)(40.0f + MHelper.nextFloat(random, 7.0f * scale_factor));
        int HEIGHT_90 = (int)((double)MAX_HEIGHT / 2.0 + (double)MHelper.nextFloat(random, 15.0f * scale_factor));
        if (up.method_10264() - down.method_10264() < 30) {
            return;
        }
        int pd = BlocksHelper.downRay((class_1936)level, down, MAX_HEIGHT) + 1;
        for (int i = 0; i < 5; ++i) {
            class_2248 block = level.method_8320(down.method_10087(pd + i)).method_26204();
            if (block != class_2246.field_10266 && block != NetherBlocks.NETHER_BRICK_TILE_LARGE && block != NetherBlocks.NETHER_BRICK_TILE_SMALL) continue;
            return;
        }
        class_2338 trunkTop = this.lerp(down, up, 0.6);
        class_2338 trunkBottom = this.lerp(down, up, 0.3);
        int count = (trunkTop.method_10264() - trunkBottom.method_10264()) / 7;
        if (count < 2) {
            count = 2;
        }
        List<class_2338> blocks = this.line(trunkBottom, trunkTop, count, random, 2.5);
        context.BLOCKS.clear();
        this.buildLine(blocks, 4.0, context);
        count = (up.method_10264() - down.method_10264()) / 10 - 1;
        if (count < 3) {
            count = 3;
        }
        this.buildBigCircle(trunkTop, 15, count, 2, random.method_43058() * Math.PI * 2.0, 3.5, random, context);
        this.buildBigCircle(trunkBottom, -15, count, 2, random.method_43058() * Math.PI * 2.0, 3.5, random, context);
        int offset = random.method_43048(4);
        int minBuildHeight = level.method_31607() + 1;
        class_3341 blockBox = BlocksHelper.decorationBounds((class_1936)level, up, minBuildHeight, MAX_HEIGHT - 2);
        for (class_2338 bpos : context.BLOCKS) {
            class_2680 state;
            if (!blockBox.method_14662((class_2382)bpos) || !BlocksHelper.isNetherGround(state = level.method_8320(bpos)) && !state.method_45474()) continue;
            boolean blockUp = context.BLOCKS.contains(bpos.method_10084());
            if (blockUp && context.BLOCKS.contains(bpos.method_10074())) {
                BlocksHelper.setWithUpdate((class_1936)level, bpos, NetherBlocks.MAT_ANCHOR_TREE.getLog().method_9564());
            } else {
                BlocksHelper.setWithUpdate((class_1936)level, bpos, NetherBlocks.MAT_ANCHOR_TREE.getBark().method_9564());
            }
            if (bpos.method_10264() > HEIGHT_45 && bpos.method_10264() < HEIGHT_90 && (bpos.method_10264() & 3) == offset && NOISE.eval((double)bpos.method_10263() * 0.1, (double)bpos.method_10264() * 0.1, (double)bpos.method_10260() * 0.1) > 0.0) {
                if (random.method_43048((int)(32.0f * scale_factor)) == 0 && !context.BLOCKS.contains(bpos.method_10095())) {
                    LegacyStructureAnchorTree.makeMushroom(level, bpos.method_10095(), random.method_43058() * 3.0 + 1.5, blockBox);
                }
                if (random.method_43048((int)(32.0f * scale_factor)) == 0 && !context.BLOCKS.contains(bpos.method_10072())) {
                    LegacyStructureAnchorTree.makeMushroom(level, bpos.method_10072(), random.method_43058() * 3.0 + 1.5, blockBox);
                }
                if (random.method_43048((int)(32.0f * scale_factor)) == 0 && !context.BLOCKS.contains(bpos.method_10078())) {
                    LegacyStructureAnchorTree.makeMushroom(level, bpos.method_10078(), random.method_43058() * 3.0 + 1.5, blockBox);
                }
                if (random.method_43048((int)(32.0f * scale_factor)) == 0 && !context.BLOCKS.contains(bpos.method_10067())) {
                    LegacyStructureAnchorTree.makeMushroom(level, bpos.method_10067(), random.method_43058() * 3.0 + 1.5, blockBox);
                }
            }
            if (bpos.method_10264() <= HEIGHT_64) continue;
            if (!blockUp && level.method_8320(bpos.method_10084()).method_45474()) {
                BlocksHelper.setWithUpdate((class_1936)level, bpos.method_10084(), NetherBlocks.MOSS_COVER.method_9564());
            }
            if (!(NOISE.eval((double)bpos.method_10263() * 0.05, (double)bpos.method_10264() * 0.05, (double)bpos.method_10260() * 0.05) > 0.0)) continue;
            state = AnchorTreeFeature.wallPlants[random.method_43048(AnchorTreeFeature.wallPlants.length)].method_9564();
            class_2338 _pos = bpos.method_10095();
            if (random.method_43048(8) == 0 && !context.BLOCKS.contains(_pos) && level.method_22347(_pos) && _pos.method_10260() >= blockBox.method_35417()) {
                BlocksHelper.setWithUpdate((class_1936)level, _pos, (class_2680)state.method_11657((class_2769)BlockPlantWall.FACING, (Comparable)class_2350.field_11043));
            }
            _pos = bpos.method_10072();
            if (random.method_43048(8) == 0 && !context.BLOCKS.contains(_pos) && level.method_22347(_pos) && _pos.method_10260() <= blockBox.method_35420()) {
                BlocksHelper.setWithUpdate((class_1936)level, _pos, (class_2680)state.method_11657((class_2769)BlockPlantWall.FACING, (Comparable)class_2350.field_11035));
            }
            _pos = bpos.method_10078();
            if (random.method_43048(8) == 0 && !context.BLOCKS.contains(_pos) && level.method_22347(_pos) && _pos.method_10263() <= blockBox.method_35418()) {
                BlocksHelper.setWithUpdate((class_1936)level, _pos, (class_2680)state.method_11657((class_2769)BlockPlantWall.FACING, (Comparable)class_2350.field_11034));
            }
            _pos = bpos.method_10067();
            if (random.method_43048(8) != 0 || context.BLOCKS.contains(_pos) || !level.method_22347(_pos) || _pos.method_10263() < blockBox.method_35415()) continue;
            BlocksHelper.setWithUpdate((class_1936)level, _pos, (class_2680)state.method_11657((class_2769)BlockPlantWall.FACING, (Comparable)class_2350.field_11039));
        }
    }

    private void buildBigCircle(class_2338 pos, int length, int count, int iteration, double angle, double size, class_5819 random, StructureGeneratorThreadContext context) {
        if (iteration < 0) {
            return;
        }
        List<List<class_2338>> lines = this.circleLinesEnds(pos, angle, count, length, (double)Math.abs(length) * 0.7, random);
        double sizeSmall = size * 0.8;
        length = (int)((double)length * 0.8);
        angle += Math.PI * 4 / (double)count;
        angle += random.method_43058() * angle * 0.75;
        for (List<class_2338> line : lines) {
            this.buildLine(line, size, context);
            this.buildBigCircle(line.get(1), length, count, iteration - 1, angle, sizeSmall, random, context);
        }
    }

    private void buildLine(List<class_2338> blocks, double radius, StructureGeneratorThreadContext context) {
        for (int i = 0; i < blocks.size() - 1; ++i) {
            double max;
            class_2338 a = blocks.get(i);
            class_2338 b = blocks.get(i + 1);
            if (b.method_10264() < a.method_10264()) {
                class_2338 c = b;
                b = a;
                a = c;
            }
            if ((max = (double)(b.method_10264() - a.method_10264())) < 1.0) {
                max = 1.0;
            }
            for (int y = a.method_10264(); y <= b.method_10264(); ++y) {
                this.cylinder(this.lerpCos(a, b, y, (double)(y - a.method_10264()) / max), radius, context);
            }
        }
    }

    private class_2338 lerp(class_2338 start, class_2338 end, double mix) {
        double x = class_3532.method_16436((double)mix, (double)start.method_10263(), (double)end.method_10263());
        double y = class_3532.method_16436((double)mix, (double)start.method_10264(), (double)end.method_10264());
        double z = class_3532.method_16436((double)mix, (double)start.method_10260(), (double)end.method_10260());
        return new class_2338((int)x, (int)y, (int)z);
    }

    private class_2338 lerpCos(class_2338 start, class_2338 end, int y, double mix) {
        double v = this.lcos(mix);
        double x = class_3532.method_16436((double)v, (double)start.method_10263(), (double)end.method_10263());
        double z = class_3532.method_16436((double)v, (double)start.method_10260(), (double)end.method_10260());
        return new class_2338((int)x, y, (int)z);
    }

    private double lcos(double mix) {
        return class_3532.method_15350((double)(0.5 - Math.cos(mix * Math.PI) * 0.5), (double)0.0, (double)1.0);
    }

    private List<class_2338> line(class_2338 start, class_2338 end, int count, class_5819 random, double range) {
        ArrayList<class_2338> result = new ArrayList<class_2338>(count);
        int max = count - 1;
        result.add(start);
        for (int i = 1; i < max; ++i) {
            double delta = (double)i / (double)max;
            double x = class_3532.method_16436((double)delta, (double)start.method_10263(), (double)end.method_10263()) + random.method_43059() * range;
            double y = class_3532.method_16436((double)delta, (double)start.method_10264(), (double)end.method_10264());
            double z = class_3532.method_16436((double)delta, (double)start.method_10260(), (double)end.method_10260()) + random.method_43059() * range;
            result.add(new class_2338((int)x, (int)y, (int)z));
        }
        result.add(end);
        return result;
    }

    private void cylinder(class_2338 pos, double radius, StructureGeneratorThreadContext context) {
        int x1 = MHelper.floor((double)pos.method_10263() - radius);
        int z1 = MHelper.floor((double)pos.method_10260() - radius);
        int x2 = MHelper.floor((double)pos.method_10263() + radius + 1.0);
        int z2 = MHelper.floor((double)pos.method_10260() + radius + 1.0);
        radius *= radius;
        for (int x = x1; x <= x2; ++x) {
            int px2 = x - pos.method_10263();
            px2 *= px2;
            for (int z = z1; z <= z2; ++z) {
                int pz2 = z - pos.method_10260();
                if (!((double)(px2 + (pz2 *= pz2)) <= radius * (NOISE.eval((double)x * 0.5, (double)pos.method_10264() * 0.5, (double)z * 0.5) * 0.25 + 0.75))) continue;
                context.BLOCKS.add(new class_2338(x, pos.method_10264(), z));
            }
        }
    }

    private List<List<class_2338>> circleLinesEnds(class_2338 pos, double startAngle, int count, int height, double radius, class_5819 random) {
        ArrayList<List<class_2338>> result = new ArrayList<List<class_2338>>(count);
        double angle = Math.PI * 2 / (double)count;
        for (int i = 0; i < count; ++i) {
            double x = (double)pos.method_10263() + Math.sin(startAngle) * radius;
            double z = (double)pos.method_10260() + Math.cos(startAngle) * radius;
            class_2338 end = new class_2338((int)x, (int)((double)(pos.method_10264() + height) + (double)height * random.method_43058() * 0.5), (int)z);
            ArrayList<class_2338> elem = new ArrayList<class_2338>(2);
            elem.add(pos);
            elem.add(end);
            result.add(elem);
            startAngle += angle;
        }
        return result;
    }

    protected static void makeMushroom(class_5425 world, class_2338 pos, double radius, class_3341 bounds) {
        if (!world.method_8320(pos).method_45474()) {
            return;
        }
        int x1 = MHelper.floor((double)pos.method_10263() - radius);
        int z1 = MHelper.floor((double)pos.method_10260() - radius);
        int x2 = MHelper.floor((double)pos.method_10263() + radius + 1.0);
        int z2 = MHelper.floor((double)pos.method_10260() + radius + 1.0);
        radius *= radius;
        ArrayList<class_2338> placed = new ArrayList<class_2338>((int)(radius * 4.0));
        for (int x = x1; x <= x2; ++x) {
            int px2 = x - pos.method_10263();
            px2 *= px2;
            for (int z = z1; z <= z2; ++z) {
                class_2338 p;
                int pz2 = z - pos.method_10260();
                if (!((double)(px2 + (pz2 *= pz2)) <= radius) || !world.method_8320(p = new class_2338(x, pos.method_10264(), z)).method_45474() || !bounds.method_14662((class_2382)p)) continue;
                placed.add(p);
            }
        }
        for (class_2338 p : placed) {
            boolean north = world.method_8320(p.method_10095()).method_26204() != NetherBlocks.GIANT_LUCIS;
            boolean south = world.method_8320(p.method_10072()).method_26204() != NetherBlocks.GIANT_LUCIS;
            boolean east = world.method_8320(p.method_10078()).method_26204() != NetherBlocks.GIANT_LUCIS;
            boolean west = world.method_8320(p.method_10067()).method_26204() != NetherBlocks.GIANT_LUCIS;
            class_2680 state = NetherBlocks.GIANT_LUCIS.method_9564();
            BlocksHelper.setWithUpdate((class_1936)world, p, (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)class_2381.field_11171, (Comparable)Boolean.valueOf(north))).method_11657((class_2769)class_2381.field_11170, (Comparable)Boolean.valueOf(south))).method_11657((class_2769)class_2381.field_11172, (Comparable)Boolean.valueOf(east))).method_11657((class_2769)class_2381.field_11167, (Comparable)Boolean.valueOf(west)));
        }
    }
}

